package amqp_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListExchangeUpStreamBindings invokes the amqp_open.ListExchangeUpStreamBindings API synchronously
// api document: https://help.aliyun.com/api/amqp-open/listexchangeupstreambindings.html
func (client *Client) ListExchangeUpStreamBindings(request *ListExchangeUpStreamBindingsRequest) (response *ListExchangeUpStreamBindingsResponse, err error) {
	response = CreateListExchangeUpStreamBindingsResponse()
	err = client.DoAction(request, response)
	return
}

// ListExchangeUpStreamBindingsWithChan invokes the amqp_open.ListExchangeUpStreamBindings API asynchronously
// api document: https://help.aliyun.com/api/amqp-open/listexchangeupstreambindings.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListExchangeUpStreamBindingsWithChan(request *ListExchangeUpStreamBindingsRequest) (<-chan *ListExchangeUpStreamBindingsResponse, <-chan error) {
	responseChan := make(chan *ListExchangeUpStreamBindingsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListExchangeUpStreamBindings(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListExchangeUpStreamBindingsWithCallback invokes the amqp_open.ListExchangeUpStreamBindings API asynchronously
// api document: https://help.aliyun.com/api/amqp-open/listexchangeupstreambindings.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListExchangeUpStreamBindingsWithCallback(request *ListExchangeUpStreamBindingsRequest, callback func(response *ListExchangeUpStreamBindingsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListExchangeUpStreamBindingsResponse
		var err error
		defer close(result)
		response, err = client.ListExchangeUpStreamBindings(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListExchangeUpStreamBindingsRequest is the request struct for api ListExchangeUpStreamBindings
type ListExchangeUpStreamBindingsRequest struct {
	*requests.RpcRequest
	ExchangeName string           `position:"Query" name:"ExchangeName"`
	InstanceId   string           `position:"Query" name:"InstanceId"`
	NextToken    string           `position:"Query" name:"NextToken"`
	MaxResults   requests.Integer `position:"Query" name:"MaxResults"`
	VirtualHost  string           `position:"Query" name:"VirtualHost"`
}

// ListExchangeUpStreamBindingsResponse is the response struct for api ListExchangeUpStreamBindings
type ListExchangeUpStreamBindingsResponse struct {
	*responses.BaseResponse
	RequestId string                             `json:"RequestId" xml:"RequestId"`
	Code      int                                `json:"Code" xml:"Code"`
	Message   string                             `json:"Message" xml:"Message"`
	Success   bool                               `json:"Success" xml:"Success"`
	Data      DataInListExchangeUpStreamBindings `json:"Data" xml:"Data"`
}

// CreateListExchangeUpStreamBindingsRequest creates a request to invoke ListExchangeUpStreamBindings API
func CreateListExchangeUpStreamBindingsRequest() (request *ListExchangeUpStreamBindingsRequest) {
	request = &ListExchangeUpStreamBindingsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("amqp-open", "2019-12-12", "ListExchangeUpStreamBindings", "onsproxy", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListExchangeUpStreamBindingsResponse creates a response to parse from ListExchangeUpStreamBindings response
func CreateListExchangeUpStreamBindingsResponse() (response *ListExchangeUpStreamBindingsResponse) {
	response = &ListExchangeUpStreamBindingsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
