package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddIntegration invokes the arms.AddIntegration API synchronously
func (client *Client) AddIntegration(request *AddIntegrationRequest) (response *AddIntegrationResponse, err error) {
	response = CreateAddIntegrationResponse()
	err = client.DoAction(request, response)
	return
}

// AddIntegrationWithChan invokes the arms.AddIntegration API asynchronously
func (client *Client) AddIntegrationWithChan(request *AddIntegrationRequest) (<-chan *AddIntegrationResponse, <-chan error) {
	responseChan := make(chan *AddIntegrationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddIntegration(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddIntegrationWithCallback invokes the arms.AddIntegration API asynchronously
func (client *Client) AddIntegrationWithCallback(request *AddIntegrationRequest, callback func(response *AddIntegrationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddIntegrationResponse
		var err error
		defer close(result)
		response, err = client.AddIntegration(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddIntegrationRequest is the request struct for api AddIntegration
type AddIntegrationRequest struct {
	*requests.RpcRequest
	Integration string `position:"Query" name:"Integration"`
	ClusterId   string `position:"Query" name:"ClusterId"`
}

// AddIntegrationResponse is the response struct for api AddIntegration
type AddIntegrationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateAddIntegrationRequest creates a request to invoke AddIntegration API
func CreateAddIntegrationRequest() (request *AddIntegrationRequest) {
	request = &AddIntegrationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "AddIntegration", "", "")
	request.Method = requests.POST
	return
}

// CreateAddIntegrationResponse creates a response to parse from AddIntegration response
func CreateAddIntegrationResponse() (response *AddIntegrationResponse) {
	response = &AddIntegrationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
