package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateRetcodeApp invokes the arms.CreateRetcodeApp API synchronously
func (client *Client) CreateRetcodeApp(request *CreateRetcodeAppRequest) (response *CreateRetcodeAppResponse, err error) {
	response = CreateCreateRetcodeAppResponse()
	err = client.DoAction(request, response)
	return
}

// CreateRetcodeAppWithChan invokes the arms.CreateRetcodeApp API asynchronously
func (client *Client) CreateRetcodeAppWithChan(request *CreateRetcodeAppRequest) (<-chan *CreateRetcodeAppResponse, <-chan error) {
	responseChan := make(chan *CreateRetcodeAppResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateRetcodeApp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateRetcodeAppWithCallback invokes the arms.CreateRetcodeApp API asynchronously
func (client *Client) CreateRetcodeAppWithCallback(request *CreateRetcodeAppRequest, callback func(response *CreateRetcodeAppResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateRetcodeAppResponse
		var err error
		defer close(result)
		response, err = client.CreateRetcodeApp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateRetcodeAppRequest is the request struct for api CreateRetcodeApp
type CreateRetcodeAppRequest struct {
	*requests.RpcRequest
	RetcodeAppName string `position:"Query" name:"RetcodeAppName"`
	RetcodeAppType string `position:"Query" name:"RetcodeAppType"`
}

// CreateRetcodeAppResponse is the response struct for api CreateRetcodeApp
type CreateRetcodeAppResponse struct {
	*responses.BaseResponse
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	RetcodeAppDataBean RetcodeAppDataBean `json:"RetcodeAppDataBean" xml:"RetcodeAppDataBean"`
}

// CreateCreateRetcodeAppRequest creates a request to invoke CreateRetcodeApp API
func CreateCreateRetcodeAppRequest() (request *CreateRetcodeAppRequest) {
	request = &CreateRetcodeAppRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "CreateRetcodeApp", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateRetcodeAppResponse creates a response to parse from CreateRetcodeApp response
func CreateCreateRetcodeAppResponse() (response *CreateRetcodeAppResponse) {
	response = &CreateRetcodeAppResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
