package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetApgroupDetailedConfig invokes the cloudwf.GetApgroupDetailedConfig API synchronously
// api document: https://help.aliyun.com/api/cloudwf/getapgroupdetailedconfig.html
func (client *Client) GetApgroupDetailedConfig(request *GetApgroupDetailedConfigRequest) (response *GetApgroupDetailedConfigResponse, err error) {
	response = CreateGetApgroupDetailedConfigResponse()
	err = client.DoAction(request, response)
	return
}

// GetApgroupDetailedConfigWithChan invokes the cloudwf.GetApgroupDetailedConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getapgroupdetailedconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetApgroupDetailedConfigWithChan(request *GetApgroupDetailedConfigRequest) (<-chan *GetApgroupDetailedConfigResponse, <-chan error) {
	responseChan := make(chan *GetApgroupDetailedConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetApgroupDetailedConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetApgroupDetailedConfigWithCallback invokes the cloudwf.GetApgroupDetailedConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getapgroupdetailedconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetApgroupDetailedConfigWithCallback(request *GetApgroupDetailedConfigRequest, callback func(response *GetApgroupDetailedConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetApgroupDetailedConfigResponse
		var err error
		defer close(result)
		response, err = client.GetApgroupDetailedConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetApgroupDetailedConfigRequest is the request struct for api GetApgroupDetailedConfig
type GetApgroupDetailedConfigRequest struct {
	*requests.RpcRequest
	Id requests.Integer `position:"Query" name:"Id"`
}

// GetApgroupDetailedConfigResponse is the response struct for api GetApgroupDetailedConfig
type GetApgroupDetailedConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateGetApgroupDetailedConfigRequest creates a request to invoke GetApgroupDetailedConfig API
func CreateGetApgroupDetailedConfigRequest() (request *GetApgroupDetailedConfigRequest) {
	request = &GetApgroupDetailedConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "GetApgroupDetailedConfig", "cloudwf", "openAPI")
	return
}

// CreateGetApgroupDetailedConfigResponse creates a response to parse from GetApgroupDetailedConfig response
func CreateGetApgroupDetailedConfigResponse() (response *GetApgroupDetailedConfigResponse) {
	response = &GetApgroupDetailedConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
