package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GisQueryDeviceLocation invokes the iot.GisQueryDeviceLocation API synchronously
func (client *Client) GisQueryDeviceLocation(request *GisQueryDeviceLocationRequest) (response *GisQueryDeviceLocationResponse, err error) {
	response = CreateGisQueryDeviceLocationResponse()
	err = client.DoAction(request, response)
	return
}

// GisQueryDeviceLocationWithChan invokes the iot.GisQueryDeviceLocation API asynchronously
func (client *Client) GisQueryDeviceLocationWithChan(request *GisQueryDeviceLocationRequest) (<-chan *GisQueryDeviceLocationResponse, <-chan error) {
	responseChan := make(chan *GisQueryDeviceLocationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GisQueryDeviceLocation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GisQueryDeviceLocationWithCallback invokes the iot.GisQueryDeviceLocation API asynchronously
func (client *Client) GisQueryDeviceLocationWithCallback(request *GisQueryDeviceLocationRequest, callback func(response *GisQueryDeviceLocationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GisQueryDeviceLocationResponse
		var err error
		defer close(result)
		response, err = client.GisQueryDeviceLocation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GisQueryDeviceLocationRequest is the request struct for api GisQueryDeviceLocation
type GisQueryDeviceLocationRequest struct {
	*requests.RpcRequest
	IotInstanceId string                             `position:"Query" name:"IotInstanceId"`
	ThingList     *[]GisQueryDeviceLocationThingList `position:"Query" name:"ThingList"  type:"Repeated"`
	ApiProduct    string                             `position:"Body" name:"ApiProduct"`
	ApiRevision   string                             `position:"Body" name:"ApiRevision"`
}

// GisQueryDeviceLocationThingList is a repeated param struct in GisQueryDeviceLocationRequest
type GisQueryDeviceLocationThingList struct {
	ProductKey string `name:"ProductKey"`
	DeviceName string `name:"DeviceName"`
}

// GisQueryDeviceLocationResponse is the response struct for api GisQueryDeviceLocation
type GisQueryDeviceLocationResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         []Data `json:"Data" xml:"Data"`
}

// CreateGisQueryDeviceLocationRequest creates a request to invoke GisQueryDeviceLocation API
func CreateGisQueryDeviceLocationRequest() (request *GisQueryDeviceLocationRequest) {
	request = &GisQueryDeviceLocationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "GisQueryDeviceLocation", "", "")
	request.Method = requests.POST
	return
}

// CreateGisQueryDeviceLocationResponse creates a response to parse from GisQueryDeviceLocation response
func CreateGisQueryDeviceLocationResponse() (response *GisQueryDeviceLocationResponse) {
	response = &GisQueryDeviceLocationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
