package itaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateBoxCode invokes the itaas.CreateBoxCode API synchronously
// api document: https://help.aliyun.com/api/itaas/createboxcode.html
func (client *Client) CreateBoxCode(request *CreateBoxCodeRequest) (response *CreateBoxCodeResponse, err error) {
	response = CreateCreateBoxCodeResponse()
	err = client.DoAction(request, response)
	return
}

// CreateBoxCodeWithChan invokes the itaas.CreateBoxCode API asynchronously
// api document: https://help.aliyun.com/api/itaas/createboxcode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateBoxCodeWithChan(request *CreateBoxCodeRequest) (<-chan *CreateBoxCodeResponse, <-chan error) {
	responseChan := make(chan *CreateBoxCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateBoxCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateBoxCodeWithCallback invokes the itaas.CreateBoxCode API asynchronously
// api document: https://help.aliyun.com/api/itaas/createboxcode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateBoxCodeWithCallback(request *CreateBoxCodeRequest, callback func(response *CreateBoxCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateBoxCodeResponse
		var err error
		defer close(result)
		response, err = client.CreateBoxCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateBoxCodeRequest is the request struct for api CreateBoxCode
type CreateBoxCodeRequest struct {
	*requests.RpcRequest
	Clientappid string `position:"Query" name:"Clientappid"`
	Sysfrom     string `position:"Query" name:"Sysfrom"`
	Operator    string `position:"Query" name:"Operator"`
}

// CreateBoxCodeResponse is the response struct for api CreateBoxCode
type CreateBoxCodeResponse struct {
	*responses.BaseResponse
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	ErrorCode int                      `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string                   `json:"ErrorMsg" xml:"ErrorMsg"`
	Success   bool                     `json:"Success" xml:"Success"`
	Data      Data                     `json:"Data" xml:"Data"`
	ErrorList ErrorListInCreateBoxCode `json:"ErrorList" xml:"ErrorList"`
}

// CreateCreateBoxCodeRequest creates a request to invoke CreateBoxCode API
func CreateCreateBoxCodeRequest() (request *CreateBoxCodeRequest) {
	request = &CreateBoxCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ITaaS", "2017-05-05", "CreateBoxCode", "itaas", "openAPI")
	return
}

// CreateCreateBoxCodeResponse creates a response to parse from CreateBoxCode response
func CreateCreateBoxCodeResponse() (response *CreateBoxCodeResponse) {
	response = &CreateBoxCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
