package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddLiveRecordVodConfig invokes the live.AddLiveRecordVodConfig API synchronously
func (client *Client) AddLiveRecordVodConfig(request *AddLiveRecordVodConfigRequest) (response *AddLiveRecordVodConfigResponse, err error) {
	response = CreateAddLiveRecordVodConfigResponse()
	err = client.DoAction(request, response)
	return
}

// AddLiveRecordVodConfigWithChan invokes the live.AddLiveRecordVodConfig API asynchronously
func (client *Client) AddLiveRecordVodConfigWithChan(request *AddLiveRecordVodConfigRequest) (<-chan *AddLiveRecordVodConfigResponse, <-chan error) {
	responseChan := make(chan *AddLiveRecordVodConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddLiveRecordVodConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddLiveRecordVodConfigWithCallback invokes the live.AddLiveRecordVodConfig API asynchronously
func (client *Client) AddLiveRecordVodConfigWithCallback(request *AddLiveRecordVodConfigRequest, callback func(response *AddLiveRecordVodConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddLiveRecordVodConfigResponse
		var err error
		defer close(result)
		response, err = client.AddLiveRecordVodConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddLiveRecordVodConfigRequest is the request struct for api AddLiveRecordVodConfig
type AddLiveRecordVodConfigRequest struct {
	*requests.RpcRequest
	AutoCompose                string           `position:"Query" name:"AutoCompose"`
	ComposeVodTranscodeGroupId string           `position:"Query" name:"ComposeVodTranscodeGroupId"`
	StorageLocation            string           `position:"Query" name:"StorageLocation"`
	AppName                    string           `position:"Query" name:"AppName"`
	StreamName                 string           `position:"Query" name:"StreamName"`
	VodTranscodeGroupId        string           `position:"Query" name:"VodTranscodeGroupId"`
	DomainName                 string           `position:"Query" name:"DomainName"`
	CycleDuration              requests.Integer `position:"Query" name:"CycleDuration"`
	OwnerId                    requests.Integer `position:"Query" name:"OwnerId"`
}

// AddLiveRecordVodConfigResponse is the response struct for api AddLiveRecordVodConfig
type AddLiveRecordVodConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddLiveRecordVodConfigRequest creates a request to invoke AddLiveRecordVodConfig API
func CreateAddLiveRecordVodConfigRequest() (request *AddLiveRecordVodConfigRequest) {
	request = &AddLiveRecordVodConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "AddLiveRecordVodConfig", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddLiveRecordVodConfigResponse creates a response to parse from AddLiveRecordVodConfig response
func CreateAddLiveRecordVodConfigResponse() (response *AddLiveRecordVodConfigResponse) {
	response = &AddLiveRecordVodConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
