package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryFpFileDeleteJobList invokes the mts.QueryFpFileDeleteJobList API synchronously
func (client *Client) QueryFpFileDeleteJobList(request *QueryFpFileDeleteJobListRequest) (response *QueryFpFileDeleteJobListResponse, err error) {
	response = CreateQueryFpFileDeleteJobListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryFpFileDeleteJobListWithChan invokes the mts.QueryFpFileDeleteJobList API asynchronously
func (client *Client) QueryFpFileDeleteJobListWithChan(request *QueryFpFileDeleteJobListRequest) (<-chan *QueryFpFileDeleteJobListResponse, <-chan error) {
	responseChan := make(chan *QueryFpFileDeleteJobListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryFpFileDeleteJobList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryFpFileDeleteJobListWithCallback invokes the mts.QueryFpFileDeleteJobList API asynchronously
func (client *Client) QueryFpFileDeleteJobListWithCallback(request *QueryFpFileDeleteJobListRequest, callback func(response *QueryFpFileDeleteJobListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryFpFileDeleteJobListResponse
		var err error
		defer close(result)
		response, err = client.QueryFpFileDeleteJobList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryFpFileDeleteJobListRequest is the request struct for api QueryFpFileDeleteJobList
type QueryFpFileDeleteJobListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	JobIds               string           `position:"Query" name:"JobIds"`
}

// QueryFpFileDeleteJobListResponse is the response struct for api QueryFpFileDeleteJobList
type QueryFpFileDeleteJobListResponse struct {
	*responses.BaseResponse
	RequestId           string                                `json:"RequestId" xml:"RequestId"`
	NonExistIds         NonExistIdsInQueryFpFileDeleteJobList `json:"NonExistIds" xml:"NonExistIds"`
	FpFileDeleteJobList FpFileDeleteJobList                   `json:"FpFileDeleteJobList" xml:"FpFileDeleteJobList"`
}

// CreateQueryFpFileDeleteJobListRequest creates a request to invoke QueryFpFileDeleteJobList API
func CreateQueryFpFileDeleteJobListRequest() (request *QueryFpFileDeleteJobListRequest) {
	request = &QueryFpFileDeleteJobListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "QueryFpFileDeleteJobList", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryFpFileDeleteJobListResponse creates a response to parse from QueryFpFileDeleteJobList response
func CreateQueryFpFileDeleteJobListResponse() (response *QueryFpFileDeleteJobListResponse) {
	response = &QueryFpFileDeleteJobListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
