package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePurchasedDevices invokes the vs.DescribePurchasedDevices API synchronously
func (client *Client) DescribePurchasedDevices(request *DescribePurchasedDevicesRequest) (response *DescribePurchasedDevicesResponse, err error) {
	response = CreateDescribePurchasedDevicesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePurchasedDevicesWithChan invokes the vs.DescribePurchasedDevices API asynchronously
func (client *Client) DescribePurchasedDevicesWithChan(request *DescribePurchasedDevicesRequest) (<-chan *DescribePurchasedDevicesResponse, <-chan error) {
	responseChan := make(chan *DescribePurchasedDevicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePurchasedDevices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePurchasedDevicesWithCallback invokes the vs.DescribePurchasedDevices API asynchronously
func (client *Client) DescribePurchasedDevicesWithCallback(request *DescribePurchasedDevicesRequest, callback func(response *DescribePurchasedDevicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePurchasedDevicesResponse
		var err error
		defer close(result)
		response, err = client.DescribePurchasedDevices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePurchasedDevicesRequest is the request struct for api DescribePurchasedDevices
type DescribePurchasedDevicesRequest struct {
	*requests.RpcRequest
	SortDirection string           `position:"Query" name:"SortDirection"`
	Type          string           `position:"Query" name:"Type"`
	PageNum       requests.Integer `position:"Query" name:"PageNum"`
	SubType       string           `position:"Query" name:"SubType"`
	Vendor        string           `position:"Query" name:"Vendor"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	Id            string           `position:"Query" name:"Id"`
	ShowLog       string           `position:"Query" name:"ShowLog"`
	GroupId       string           `position:"Query" name:"GroupId"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	Name          string           `position:"Query" name:"Name"`
	SortBy        string           `position:"Query" name:"SortBy"`
}

// DescribePurchasedDevicesResponse is the response struct for api DescribePurchasedDevices
type DescribePurchasedDevicesResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	PageSize   int64    `json:"PageSize" xml:"PageSize"`
	PageNum    int64    `json:"PageNum" xml:"PageNum"`
	PageCount  int64    `json:"PageCount" xml:"PageCount"`
	TotalCount int64    `json:"TotalCount" xml:"TotalCount"`
	Devices    []Device `json:"Devices" xml:"Devices"`
}

// CreateDescribePurchasedDevicesRequest creates a request to invoke DescribePurchasedDevices API
func CreateDescribePurchasedDevicesRequest() (request *DescribePurchasedDevicesRequest) {
	request = &DescribePurchasedDevicesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribePurchasedDevices", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribePurchasedDevicesResponse creates a response to parse from DescribePurchasedDevices response
func CreateDescribePurchasedDevicesResponse() (response *DescribePurchasedDevicesResponse) {
	response = &DescribePurchasedDevicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
