
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: utils_mrl.c 2667 2007-08-22 21:47:14Z mschwerin $
 *
 */
#include "config.h"

#include "heap.h"
#include "utils.h"
#include "utils_mrl.h"


char *
mrl_get_filename (const char *mrl)
{
    const char *filename = NULL;

    if (starts_with (mrl, "dvd://")) {
        filename = (char *) (mrl + 6);
    }
    else if (starts_with (mrl, "vcd://")) {
        filename = (char *) (mrl + 6);
    }
    else if (starts_with (mrl, "cdda://")) {
        filename = (char *) (mrl + 7);
    }
    else if (starts_with (mrl, "http://")) {
        filename = (char *) (mrl + 7);
    }
    else if (starts_with (mrl, "ftp://")) {
        filename = (char *) (mrl + 6);
    }
    else if (starts_with (mrl, "file://")) {
        filename = (char *) (mrl + 7);
    }
    else {
        filename = mrl;
    }

    return ho_strdup (filename);
}


bool
mrl_filename_is_regular (const char *mrl)
{
    return !mrl_filename_is_device (mrl);
}


bool
mrl_filename_is_device (const char *mrl)
{
    char *filename = mrl_get_filename (mrl);
    bool res = starts_with (filename, "/dev/");
    ho_free (filename);
    return res;
}
