/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.completion;

import com.intellij.codeInsight.inline.completion.render.InlineCompletionLineRenderer;
import com.intellij.codeInsight.inline.completion.render.InlineCompletionRenderTextBlock;
import com.intellij.notebooks.ui.visualization.NotebookEditorAppearance;
import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.notebooks.visualization.NotebookCellSelectionModel;
import com.intellij.notebooks.visualization.NotebookCellSelectionModelProviderKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.impl.EditorEmbeddedComponentManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0002J$\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/jupyter/completion/JupyterInlineCompletionLineRenderer;", "Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionLineRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "initialBlocks", "", "Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionRenderTextBlock;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Ljava/util/List;)V", "getCellWidth", "", "beforePaint", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "g", "Ljava/awt/Graphics;", "targetRegion", "Ljava/awt/Rectangle;", "intellij.jupyter.completion"})
@SourceDebugExtension(value={"SMAP\nJupyterInlineCompletionLineRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterInlineCompletionLineRenderer.kt\ncom/intellij/jupyter/completion/JupyterInlineCompletionLineRenderer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,37:1\n1400#2,2:38\n*S KotlinDebug\n*F\n+ 1 JupyterInlineCompletionLineRenderer.kt\ncom/intellij/jupyter/completion/JupyterInlineCompletionLineRenderer\n*L\n20#1:38,2\n*E\n"})
public final class JupyterInlineCompletionLineRenderer
extends InlineCompletionLineRenderer {
    @NotNull
    private final Editor editor;

    public JupyterInlineCompletionLineRenderer(@NotNull Editor editor, @NotNull List<InlineCompletionRenderTextBlock> initialBlocks) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(initialBlocks, (String)"initialBlocks");
        super(editor, initialBlocks);
        this.editor = editor;
    }

    private final int getCellWidth() {
        Object object;
        block1: {
            Component[] componentArray = this.editor.getContentComponent().getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            Object[] $this$firstOrNull$iv = componentArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Component it = (Component)element$iv;
                boolean bl = false;
                if (!(it instanceof EditorEmbeddedComponentManager.FullEditorWidthRenderer)) continue;
                object = element$iv;
                break block1;
            }
            object = null;
        }
        Component component2 = (Component)object;
        return component2 != null ? component2.getWidth() : this.editor.getContentComponent().getWidth();
    }

    protected void beforePaint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
        if (inlay.getPlacement() != Inlay.Placement.BELOW_LINE) {
            return;
        }
        NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)this.editor);
        if (notebookCellSelectionModel == null || (notebookCellSelectionModel = notebookCellSelectionModel.getPrimarySelectedCell()) == null) {
            return;
        }
        NotebookCellSelectionModel selectedCell = notebookCellSelectionModel;
        int caretOffset = this.editor.getCaretModel().getOffset();
        int caretLineNumber = this.editor.getDocument().getLineNumber(caretOffset);
        if (caretLineNumber != selectedCell.getLines().getLast()) {
            return;
        }
        NotebookEditorAppearance appearance = NotebookUtil.INSTANCE.getNotebookAppearance(this.editor);
        g.setColor((Color)appearance.getCodeCellBackgroundColor().get());
        g.fillRect(targetRegion.x, targetRegion.y, this.getCellWidth(), inlay.getHeightInPixels());
    }
}

