/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.documentation;

import com.intellij.lang.javascript.actions.JSShowTypeInfoAction;
import com.intellij.lang.javascript.documentation.JSDocumentationCommentGeneratorBase;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0014\u00a8\u0006\u0018"}, d2={"Lcom/intellij/lang/typescript/documentation/TypeScriptDocumentationCommentGenerator;", "Lcom/intellij/lang/javascript/documentation/JSDocumentationCommentGeneratorBase;", "<init>", "()V", "shouldAddTypeAnnotation", "", "context", "Lcom/intellij/psi/PsiElement;", "appendParameterDoc", "", "parameter", "Lcom/intellij/lang/javascript/psi/JSParameter;", "appendFunctionReturnTypeForInfoDoc", "function", "Lcom/intellij/lang/javascript/psi/JSFunction;", "getDeclarationAccessModifier", "Lcom/intellij/lang/javascript/psi/ecmal4/JSAttributeList$AccessType;", "name", "", "attributeListOwner", "Lcom/intellij/lang/javascript/psi/ecmal4/JSAttributeListOwner;", "getTypeTextForGenerateDoc", "rawType", "Lcom/intellij/lang/javascript/psi/JSType;", "intellij.javascript.backend"})
public final class TypeScriptDocumentationCommentGenerator
extends JSDocumentationCommentGeneratorBase {
    @Override
    protected boolean shouldAddTypeAnnotation(@Nullable PsiElement context2) {
        if (context2 == null) {
            return false;
        }
        TypeScriptCodeStyleSettings settings = TypeScriptCodeStyleSettings.getTypeScriptSettings((PsiElement)context2);
        return settings.JSDOC_INCLUDE_TYPES;
    }

    @Override
    protected void appendParameterDoc(@NotNull JSParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        this.append("* @param");
        TypeScriptCodeStyleSettings settings = TypeScriptCodeStyleSettings.getTypeScriptSettings((PsiElement)((PsiElement)parameter));
        Project project = parameter.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!DumbService.Companion.isDumb(project) && settings.JSDOC_INCLUDE_TYPES) {
            this.appendSlow((Function0<String>)((Function0)() -> TypeScriptDocumentationCommentGenerator.appendParameterDoc$lambda$0(parameter, this)));
        }
        this.append(" " + parameter.getName());
    }

    @Override
    protected void appendFunctionReturnTypeForInfoDoc(@NotNull JSFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (!TypeScriptCodeStyleSettings.getTypeScriptSettings((PsiElement)((PsiElement)function)).JSDOC_INCLUDE_TYPES) {
            return;
        }
        if (function instanceof TypeScriptFunction && ((TypeScriptFunction)function).getReturnTypeElement() != null) {
            this.appendSlow((Function0<String>)((Function0)() -> TypeScriptDocumentationCommentGenerator.appendFunctionReturnTypeForInfoDoc$lambda$0(this, function)));
        } else {
            super.appendFunctionReturnTypeForInfoDoc(function);
        }
    }

    @Override
    @Nullable
    protected JSAttributeList.AccessType getDeclarationAccessModifier(@Nullable String name, @Nullable JSAttributeListOwner attributeListOwner) {
        JSAttributeListOwner jSAttributeListOwner = attributeListOwner;
        return jSAttributeListOwner != null && (jSAttributeListOwner = jSAttributeListOwner.getAttributeList()) != null ? jSAttributeListOwner.getAccessType() : null;
    }

    @Override
    @NotNull
    protected String getTypeTextForGenerateDoc(@NotNull JSType rawType) {
        Intrinsics.checkNotNullParameter((Object)rawType, (String)"rawType");
        JSType jSType = JSTypeUtils.applyCompositeMapping((JSType)rawType, arg_0 -> TypeScriptDocumentationCommentGenerator.getTypeTextForGenerateDoc$lambda$1(TypeScriptDocumentationCommentGenerator::getTypeTextForGenerateDoc$lambda$0, arg_0));
        Intrinsics.checkNotNull((Object)jSType);
        JSType rawType2 = jSType;
        return super.getTypeTextForGenerateDoc(rawType2);
    }

    private static final String appendParameterDoc$lambda$0(JSParameter $parameter, TypeScriptDocumentationCommentGenerator this$0) {
        JSType type2 = JSShowTypeInfoAction.getTypeForDocumentation((PsiElement)$parameter);
        return type2 != null && !(type2 instanceof JSAnyType) ? " {" + this$0.getTypeTextForGenerateDoc(type2) + "}" : "";
    }

    private static final String appendFunctionReturnTypeForInfoDoc$lambda$0(TypeScriptDocumentationCommentGenerator this$0, JSFunction $function) {
        return this$0.getFunctionReturnTypeDoc($function.getReturnType());
    }

    private static final JSType getTypeTextForGenerateDoc$lambda$0(JSType it) {
        return JSCompositeTypeFactory.optimizeTypeIfComposite((JSType)it);
    }

    private static final JSType getTypeTextForGenerateDoc$lambda$1(Function1 $tmp0, Object p0) {
        return (JSType)$tmp0.invoke(p0);
    }
}

