/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.coord;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProviderBase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u0012\u0016\u0010\u0006\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\rH\u0016JP\u0010\u0012\u001a\u00020\u00132\u0016\u0010\u0004\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/coord/FixedRatioCoordProvider;", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProviderBase;", "ratio", "", "xLim", "Lkotlin/Pair;", "yLim", "xReversed", "", "yReversed", "flipped", "(DLkotlin/Pair;Lkotlin/Pair;ZZZ)V", "adjustGeomSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "hDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "vDomain", "geomSize", "with", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "Companion", "plot-builder"})
public class FixedRatioCoordProvider
extends CoordProviderBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double ratio;

    public FixedRatioCoordProvider(double ratio, @NotNull Pair<Double, Double> xLim, @NotNull Pair<Double, Double> yLim, boolean xReversed, boolean yReversed, boolean flipped) {
        Intrinsics.checkNotNullParameter(xLim, (String)"xLim");
        Intrinsics.checkNotNullParameter(yLim, (String)"yLim");
        super(xLim, yLim, xReversed, yReversed, flipped, null, 32, null);
        this.ratio = ratio;
    }

    @Override
    @NotNull
    public CoordProvider with(@NotNull Pair<Double, Double> xLim, @NotNull Pair<Double, Double> yLim, boolean xReversed, boolean yReversed, boolean flipped) {
        Intrinsics.checkNotNullParameter(xLim, (String)"xLim");
        Intrinsics.checkNotNullParameter(yLim, (String)"yLim");
        return new FixedRatioCoordProvider(this.ratio, xLim, yLim, xReversed, yReversed, flipped);
    }

    @Override
    @NotNull
    public DoubleVector adjustGeomSize(@NotNull DoubleSpan hDomain, @NotNull DoubleSpan vDomain, @NotNull DoubleVector geomSize) {
        Intrinsics.checkNotNullParameter((Object)hDomain, (String)"hDomain");
        Intrinsics.checkNotNullParameter((Object)vDomain, (String)"vDomain");
        Intrinsics.checkNotNullParameter((Object)geomSize, (String)"geomSize");
        double domainRatio = hDomain.getLength() / vDomain.getLength();
        double effectiveDomainRatio = domainRatio / this.ratio;
        return Companion.reshapeGeom(geomSize, effectiveDomainRatio);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/coord/FixedRatioCoordProvider$Companion;", "", "()V", "reshapeGeom", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "geomSize", "targetWidthToHeightRatio", "", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DoubleVector reshapeGeom(@NotNull DoubleVector geomSize, double targetWidthToHeightRatio) {
            DoubleVector doubleVector;
            Intrinsics.checkNotNullParameter((Object)geomSize, (String)"geomSize");
            double geomRatio = geomSize.getX() / geomSize.getY();
            if (targetWidthToHeightRatio > geomRatio) {
                double h = geomSize.getX() / targetWidthToHeightRatio;
                doubleVector = new DoubleVector(geomSize.getX(), h);
            } else {
                double w = geomSize.getY() * targetWidthToHeightRatio;
                doubleVector = new DoubleVector(w, geomSize.getY());
            }
            DoubleVector newSize = doubleVector;
            return newSize;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

