/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.intellij.database.dialects.base.generator.AbstractCodeGenerator;
import com.intellij.database.dialects.base.generator.Operation;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.script.generator.ScriptLocus;
import com.intellij.database.script.generator.ScriptingAlterTask;
import com.intellij.database.script.generator.ScriptingInternalTask;
import com.intellij.database.script.generator.ScriptingNativeDefinitionTask;
import com.intellij.database.script.generator.ScriptingOrder;
import com.intellij.database.script.generator.ScriptingSingleModelTask;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0010\u00a2\u0006\u0002\b\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0018H\u0016J\b\u0010\u001c\u001a\u00020\u0018H\u0014J\b\u0010\u001d\u001a\u00020\u0018H\u0014J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\bH\u0004J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\bH\u0002J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\bH$J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\bH\u0014J)\u0010#\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\b2\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020&0%\"\u00020&H\u0014\u00a2\u0006\u0002\u0010'R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006("}, d2={"Lcom/intellij/database/dialects/base/generator/AbstractTransitionCodeGenerator;", "Lcom/intellij/database/dialects/base/generator/AbstractCodeGenerator;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "<init>", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;)V", "deck", "Ljava/util/Deque;", "Lcom/intellij/database/model/basic/BasicElement;", "getDeck", "()Ljava/util/Deque;", "postponed", "Lcom/intellij/util/containers/MultiMap;", "generated", "", "getGenerated", "()Ljava/util/Set;", "preparedOperations", "", "Lcom/intellij/database/dialects/base/generator/Operation;", "preparedOperations$intellij_database_dialects_base", "isNewCodeGen", "", "setElementsToGenerate", "", "elements", "", "generate", "generateHeading", "generateFooting", "process", "element", "processElement", "generateElement", "finishElement", "processInnerElements", "kinds", "", "Lcom/intellij/database/model/ObjectKind;", "(Lcom/intellij/database/model/basic/BasicElement;[Lcom/intellij/database/model/ObjectKind;)V", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nAbstractTransitionCodeGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractTransitionCodeGenerator.kt\ncom/intellij/database/dialects/base/generator/AbstractTransitionCodeGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1#2:114\n*E\n"})
public abstract class AbstractTransitionCodeGenerator
extends AbstractCodeGenerator {
    @NotNull
    private final Deque<BasicElement> deck;
    @NotNull
    private final MultiMap<BasicElement, BasicElement> postponed;
    @NotNull
    private final Set<BasicElement> generated;

    /*
     * WARNING - void declaration
     */
    public AbstractTransitionCodeGenerator(@NotNull ScriptingContext context) {
        Collection collection;
        void it;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, null, 2, null);
        this.deck = new ArrayDeque();
        this.postponed = new MultiMap();
        this.generated = new HashSet();
        ScriptingTask scriptingTask = context.getTask();
        AbstractTransitionCodeGenerator abstractTransitionCodeGenerator = this;
        boolean bl = false;
        void var4_5 = it;
        if (var4_5 instanceof ScriptingSingleModelTask) {
            collection = ((ScriptingSingleModelTask)it).getElements();
        } else if (var4_5 instanceof ScriptingNativeDefinitionTask) {
            collection = ((ScriptingNativeDefinitionTask)it).getElements();
        } else if (var4_5 instanceof ScriptingAlterTask) {
            collection = CollectionsKt.emptyList();
        } else if (var4_5 instanceof ScriptingInternalTask) {
            collection = CollectionsKt.emptyList();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        abstractTransitionCodeGenerator.setElementsToGenerate(collection);
    }

    @NotNull
    protected final Deque<BasicElement> getDeck() {
        return this.deck;
    }

    @NotNull
    protected final Set<BasicElement> getGenerated() {
        return this.generated;
    }

    @Override
    @NotNull
    public List<Operation> preparedOperations$intellij_database_dialects_base() {
        List<Operation> list = Collections.emptyList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
        return list;
    }

    @Override
    protected boolean isNewCodeGen() {
        return false;
    }

    private final void setElementsToGenerate(Iterable<? extends BasicElement> elements) {
        MultiMap sorted = new MultiMap((Map)new TreeMap());
        for (BasicElement basicElement : elements) {
            sorted.putValue((Object)this.getContext().getHelper().getObjectPreliminaryOrder(basicElement), (Object)basicElement);
        }
        for (BasicElement basicElement : sorted.values()) {
            this.deck.offer(basicElement);
        }
    }

    public void generate() {
        this.generateHeading();
        while (true) {
            BasicElement basicElement = this.getContext().getTask().getCategory().getOrder() == ScriptingOrder.REVERS_ORDER ? this.deck.pollLast() : this.deck.poll();
            if (basicElement == null) break;
            BasicElement element = basicElement;
            if (element.isAutoCreated()) continue;
            this.process(element);
        }
        this.generateFooting();
    }

    protected void generateHeading() {
    }

    protected void generateFooting() {
    }

    protected final void process(@NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!this.generated.contains(element)) {
            if (this.getContext().getTask().getCategory().getOrder() == ScriptingOrder.NORMAL_ORDER && !this.isNewCodeGen()) {
                Iterable iterable = element.getPredecessors();
                Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getPredecessors(...)");
                Iterable predecessors = iterable;
                boolean postpone = false;
                for (BasicElement predecessor : predecessors) {
                    if (this.generated.contains(predecessor) || !this.deck.contains(predecessor)) continue;
                    this.postponed.putValue((Object)predecessor, (Object)element);
                    postpone = true;
                }
                if (postpone) {
                    return;
                }
            }
            this.processElement(element);
            if (!this.generated.contains(element)) {
                return;
            }
        }
        if (this.getContext().getLocus() == ScriptLocus.IN_SCHEMA || this.getContext().getLocus() == ScriptLocus.OUTSIDE) {
            boolean bl;
            Collection collection = this.postponed.get((Object)element);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
            Iterable pendingElements = collection;
            boolean bl2 = bl = !this.isNewCodeGen() || this.postponed.isEmpty();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            for (BasicElement pendingElement : pendingElements) {
                this.process(pendingElement);
            }
        }
    }

    private final void processElement(BasicElement element) {
        this.generateElement(element);
        this.finishElement(element);
    }

    protected abstract void generateElement(@NotNull BasicElement var1);

    protected void finishElement(@NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.generated.add(element);
    }

    protected void processInnerElements(@NotNull BasicElement element, ObjectKind ... kinds) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)kinds, (String)"kinds");
        ArrayList innerElements = new ArrayList();
        for (ObjectKind kind : kinds) {
            Family f = element.familyOf(kind);
            if (f == null) continue;
            CollectionsKt.addAll((Collection)innerElements, (Iterable)((Iterable)f));
        }
        int n = innerElements.size();
        if (n == 0) {
            return;
        }
        if (n >= 2 && this.getContext().getTask().getCategory().getOrder() == ScriptingOrder.REVERS_ORDER) {
            Collections.reverse(innerElements);
        }
        Iterator iterator = innerElements.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            BasicElement innerElement = (BasicElement)e;
            this.process(innerElement);
        }
    }
}

