/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector;

import com.intellij.database.dialects.base.introspector.AffectedObjectAnalyzer;
import com.intellij.database.introspection.AffectedObjectMention;
import com.intellij.database.introspection.AffectedObjectScriptedMention;
import com.intellij.database.introspection.BelongingAreaKind;
import com.intellij.database.introspection.ObjectEffectType;
import com.intellij.database.introspection.ScriptedName;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicAuxiliaryDetail;
import com.intellij.database.model.basic.BasicAuxiliaryObject;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicMateDatabase;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.meta.BasicMetaFunKt;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.util.Casing;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b\u0016\u0018\u00002\u00020\u0001:\u000289B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001aH\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00112\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001dH\u0014J4\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00122\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+H\u0014J\u0013\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020-H\u0082\u0010J6\u0010/\u001a\u0004\u0018\u00010)2\u0006\u00100\u001a\u00020 2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u00122\b\u00101\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+H\u0014J\u001a\u00102\u001a\u0004\u0018\u00010)2\u0006\u00100\u001a\u00020 2\u0006\u00103\u001a\u00020\u0012H\u0004J\u0018\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u00122\u0006\u00107\u001a\u00020\u0012H\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014\u00a8\u0006:\u00b2\u0006\u0010\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<X\u008a\u0084\u0002"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseAffectedObjectAnalyzer;", "Lcom/intellij/database/dialects/base/introspector/AffectedObjectAnalyzer;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "<init>", "(Lcom/intellij/database/model/basic/BasicModel;Lcom/intellij/openapi/diagnostic/Logger;)V", "getModel", "()Lcom/intellij/database/model/basic/BasicModel;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "root", "Lcom/intellij/database/model/basic/BasicRoot;", "getRoot", "()Lcom/intellij/database/model/basic/BasicRoot;", "schemaMinor", "", "Lcom/intellij/database/model/ObjectKind;", "getSchemaMinor", "()Ljava/util/Set;", "databaseAuxiliaryDetailKinds", "getDatabaseAuxiliaryDetailKinds", "serverAuxiliaryDetailKinds", "getServerAuxiliaryDetailKinds", "analyze", "", "Lcom/intellij/database/introspection/AffectedObjectMention;", "scriptedMentions", "Lcom/intellij/database/introspection/AffectedObjectScriptedMention;", "scriptedMention", "resolveNamespaces", "Lcom/intellij/database/dialects/base/introspector/BaseAffectedObjectAnalyzer$Namespaces;", "sm", "adjustObject", "Lcom/intellij/database/dialects/base/introspector/BaseAffectedObjectAnalyzer$ObjectAdjustment;", "namespaces", "objectName", "", "objectKind", "belongingAreaKind", "Lcom/intellij/database/introspection/BelongingAreaKind;", "effectType", "Lcom/intellij/database/introspection/ObjectEffectType;", "getEnclosingFragmentObject", "Lcom/intellij/database/model/basic/BasicElement;", "element", "determineAffectionArea", "ns", "givenArea", "determineAreaOfKind", "theKind", "parentCanHaveChild", "", "parentKind", "childKind", "Namespaces", "ObjectAdjustment", "intellij.database.dialects.base", "indexedObjects", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/model/DasObject;"})
@SourceDebugExtension(value={"SMAP\nAffectedObjectAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AffectedObjectAnalyzer.kt\ncom/intellij/database/dialects/base/introspector/BaseAffectedObjectAnalyzer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,297:1\n1#2:298\n*E\n"})
public class BaseAffectedObjectAnalyzer
implements AffectedObjectAnalyzer {
    @NotNull
    private final BasicModel model;
    @Nullable
    private final Logger log;
    @NotNull
    private final BasicRoot root;
    @NotNull
    private final Set<ObjectKind> schemaMinor;
    @NotNull
    private final Set<ObjectKind> databaseAuxiliaryDetailKinds;
    @NotNull
    private final Set<ObjectKind> serverAuxiliaryDetailKinds;

    public BaseAffectedObjectAnalyzer(@NotNull BasicModel model, @Nullable Logger log) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.model = model;
        this.log = log;
        BasicRoot basicRoot = this.model.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)basicRoot, (String)"getRoot(...)");
        this.root = basicRoot;
        Object[] objectArray = new ObjectKind[]{ObjectKind.COLUMN, ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.CHECK, ObjectKind.RULE, ObjectKind.TRIGGER};
        this.schemaMinor = SetsKt.setOf((Object[])objectArray);
        this.databaseAuxiliaryDetailKinds = SetsKt.emptySet();
        this.serverAuxiliaryDetailKinds = SetsKt.emptySet();
    }

    public /* synthetic */ BaseAffectedObjectAnalyzer(BasicModel basicModel, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            logger = null;
        }
        this(basicModel, logger);
    }

    @NotNull
    public final BasicModel getModel() {
        return this.model;
    }

    @Nullable
    public final Logger getLog() {
        return this.log;
    }

    @NotNull
    protected final BasicRoot getRoot() {
        return this.root;
    }

    @NotNull
    protected Set<ObjectKind> getSchemaMinor() {
        return this.schemaMinor;
    }

    @NotNull
    protected Set<ObjectKind> getDatabaseAuxiliaryDetailKinds() {
        return this.databaseAuxiliaryDetailKinds;
    }

    @NotNull
    protected Set<ObjectKind> getServerAuxiliaryDetailKinds() {
        return this.serverAuxiliaryDetailKinds;
    }

    @Override
    @NotNull
    public Collection<AffectedObjectMention> analyze(@NotNull Collection<AffectedObjectScriptedMention> scriptedMentions) {
        Intrinsics.checkNotNullParameter(scriptedMentions, (String)"scriptedMentions");
        ArrayList mentions = new ArrayList(scriptedMentions.size());
        for (AffectedObjectScriptedMention scriptedMention : scriptedMentions) {
            Set<AffectedObjectMention> thisMentions = this.analyze(scriptedMention);
            CollectionsKt.addAll((Collection)mentions, (Iterable)thisMentions);
        }
        return mentions;
    }

    @Override
    @NotNull
    public Set<AffectedObjectMention> analyze(@NotNull AffectedObjectScriptedMention scriptedMention) {
        AffectedObjectMention affectedObjectMention;
        AffectedObjectMention affectedObjectMention2;
        String it;
        ObjectAdjustment adjustment;
        ScriptedName scriptedName;
        Intrinsics.checkNotNullParameter((Object)scriptedMention, (String)"scriptedMention");
        ObjectKind originalObjectKind = scriptedMention.objectKind;
        Namespaces namespaces = this.resolveNamespaces(scriptedMention);
        if (namespaces.database == null && !Intrinsics.areEqual((Object)originalObjectKind, (Object)ObjectKind.DATABASE) || namespaces.schema == null && !Intrinsics.areEqual((Object)originalObjectKind, (Object)ObjectKind.SCHEMA)) {
            return SetsKt.emptySet();
        }
        BasicSchema basicSchema = namespaces.schema;
        if (basicSchema == null && (basicSchema = namespaces.database) == null) {
            basicSchema = this.root;
        }
        BasicSchema objectCasingProvider = basicSchema;
        Casing casing = ((CasingProvider)objectCasingProvider).getCasing(originalObjectKind, (DasObject)objectCasingProvider);
        Intrinsics.checkNotNullExpressionValue((Object)casing, (String)"getCasing(...)");
        Casing objectCasing = casing;
        ScriptedName p0 = scriptedName = scriptedMention.objectOldName;
        boolean bl = false;
        Object object = p0.isSpecified() ? scriptedName : null;
        String objectOldName = object != null ? object.toCatalogName(objectCasing) : null;
        ScriptedName p02 = p0 = scriptedMention.objectNewName;
        boolean bl2 = false;
        Object object2 = p02.isSpecified() ? p0 : null;
        String objectNewName = object2 != null ? object2.toCatalogName(objectCasing) : null;
        ObjectKind objectKind = null;
        objectKind = originalObjectKind;
        BelongingAreaKind belongingAreaKind = null;
        belongingAreaKind = scriptedMention.belongingAreaKind;
        if (objectOldName != null && (adjustment = this.adjustObject(namespaces, objectOldName, objectKind, belongingAreaKind, scriptedMention.effectType)) != null) {
            objectOldName = adjustment.name;
            objectKind = adjustment.kind;
            belongingAreaKind = adjustment.area;
        }
        if (belongingAreaKind == null && (belongingAreaKind = this.determineAffectionArea(namespaces, objectOldName, objectKind, scriptedMention.belongingAreaKind, scriptedMention.effectType)) == null) {
            Logger logger = this.log;
            if (logger != null) {
                logger.debug("We cannot find the area for an affected objects with the following info: namespaces=(" + namespaces + "), object=(" + objectKind + ":" + objectOldName + "), effectType=" + scriptedMention.effectType.getCode());
            }
            return SetsKt.emptySet();
        }
        String string = objectOldName;
        if (string != null) {
            it = string;
            boolean bl3 = false;
            affectedObjectMention2 = new AffectedObjectMention(namespaces.databaseName, namespaces.database, namespaces.schemaName, namespaces.schema, it, objectKind, belongingAreaKind, scriptedMention.effectType == ObjectEffectType.WAS_DROPPED);
        } else {
            affectedObjectMention2 = null;
        }
        AffectedObjectMention m1 = affectedObjectMention2;
        String string2 = objectNewName;
        if (string2 != null) {
            it = string2;
            boolean bl4 = false;
            affectedObjectMention = new AffectedObjectMention(namespaces.databaseName, namespaces.database, namespaces.schemaName, namespaces.schema, it, objectKind, belongingAreaKind, false);
        } else {
            affectedObjectMention = null;
        }
        AffectedObjectMention m2 = affectedObjectMention;
        Object[] objectArray = new AffectedObjectMention[]{m1, m2};
        return SetsKt.setOfNotNull((Object[])objectArray);
    }

    @NotNull
    protected Namespaces resolveNamespaces(@NotNull AffectedObjectScriptedMention sm) {
        Intrinsics.checkNotNullParameter((Object)sm, (String)"sm");
        String databaseName = null;
        BasicDatabase database = null;
        Object schemaName = null;
        BasicSchema schema = null;
        Casing casing = this.root.getCasing(ObjectKind.DATABASE, (DasObject)this.root);
        Intrinsics.checkNotNullExpressionValue((Object)casing, (String)"getCasing(...)");
        Casing rootCasing = casing;
        BasicRoot basicRoot = this.root;
        if (basicRoot instanceof BasicMultiDatabaseRoot) {
            Object object;
            if (sm.databaseName.isCurrent()) {
                v1 = (BasicDatabase)((BasicMultiDatabaseRoot)this.root).getCurrentDatabase();
            } else {
                NamingFamily namingFamily = ((BasicMultiDatabaseRoot)this.root).getDatabases();
                Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getDatabases(...)");
                v1 = database = (BasicDatabase)ModelFun.findByScriptName((Family)((Family)namingFamily), (ScriptedName)sm.databaseName);
            }
            if ((object = (BasicMateDatabase)database) == null || (object = object.getName()) == null) {
                object = sm.databaseName.toCatalogName(rootCasing);
            }
            databaseName = object;
        } else if (basicRoot instanceof BasicDatabase) {
            database = (BasicDatabase)this.root;
            databaseName = "@";
        } else {
            database = null;
            databaseName = sm.databaseName.toCatalogName(rootCasing);
        }
        if (database != null) {
            Object object;
            BasicSchema basicSchema;
            if (sm.schemaName.isCurrent()) {
                basicSchema = ModelFun.getCurrentSchema((BasicDatabase)database);
            } else {
                NamingFamily namingFamily = database.getSchemas();
                Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getSchemas(...)");
                basicSchema = (BasicSchema)ModelFun.findByScriptName((Family)((Family)namingFamily), (ScriptedName)sm.schemaName);
            }
            if ((object = (schema = basicSchema)) == null || (object = object.getName()) == null) {
                ScriptedName scriptedName = sm.schemaName;
                Casing casing2 = database.getCasing(ObjectKind.SCHEMA, (DasObject)database);
                Intrinsics.checkNotNullExpressionValue((Object)casing2, (String)"getCasing(...)");
                object = scriptedName.toCatalogName(casing2);
            }
            schemaName = object;
        } else {
            schema = null;
            ScriptedName scriptedName = sm.schemaName;
            Casing casing3 = this.root.getCasing(ObjectKind.SCHEMA, (DasObject)this.root);
            Intrinsics.checkNotNullExpressionValue((Object)casing3, (String)"getCasing(...)");
            schemaName = scriptedName.toCatalogName(casing3);
        }
        return new Namespaces(databaseName, database, (String)schemaName, schema);
    }

    @Nullable
    protected ObjectAdjustment adjustObject(@NotNull Namespaces namespaces, @NotNull String objectName, @NotNull ObjectKind objectKind, @Nullable BelongingAreaKind belongingAreaKind, @NotNull ObjectEffectType effectType) {
        BasicElement candidate2;
        BasicElement candidate3;
        Intrinsics.checkNotNullParameter((Object)namespaces, (String)"namespaces");
        Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
        Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
        Intrinsics.checkNotNullParameter((Object)effectType, (String)"effectType");
        if (effectType == ObjectEffectType.WAS_CREATED) {
            return null;
        }
        Ref.ObjectRef kind = new Ref.ObjectRef();
        kind.element = objectKind;
        BelongingAreaKind areaKind = belongingAreaKind;
        Lazy indexedObjects$delegate = LazyKt.lazy(() -> BaseAffectedObjectAnalyzer.adjustObject$lambda$0(this, objectName));
        if (Intrinsics.areEqual((Object)kind.element, (Object)ObjectKind.SCHEMA_OBJECT) && (candidate3 = (BasicElement)BaseAffectedObjectAnalyzer.adjustObject$lambda$1((Lazy<? extends JBIterable<DasObject>>)indexedObjects$delegate).filter(BasicElement.class).filter(arg_0 -> BaseAffectedObjectAnalyzer.adjustObject$lambda$3(arg_0 -> BaseAffectedObjectAnalyzer.adjustObject$lambda$2(namespaces, arg_0), arg_0)).sort((arg_0, arg_1) -> BaseAffectedObjectAnalyzer.adjustObject$lambda$5(BaseAffectedObjectAnalyzer::adjustObject$lambda$4, arg_0, arg_1)).first()) != null) {
            ObjectKind objectKind2 = candidate3.getKind();
            Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"getKind(...)");
            kind.element = objectKind2;
            areaKind = this.determineAreaOfKind(namespaces, (ObjectKind)kind.element);
        }
        BasicSchema schema = namespaces.schema;
        if (this.getSchemaMinor().contains(kind.element) && schema != null && (candidate2 = (BasicElement)BaseAffectedObjectAnalyzer.adjustObject$lambda$1((Lazy<? extends JBIterable<DasObject>>)indexedObjects$delegate).filter(BasicElement.class).filter(arg_0 -> BaseAffectedObjectAnalyzer.adjustObject$lambda$7(arg_0 -> BaseAffectedObjectAnalyzer.adjustObject$lambda$6(kind, arg_0), arg_0)).filterMap(arg_0 -> BaseAffectedObjectAnalyzer.adjustObject$lambda$8((Function1)new Function1<BasicElement, BasicElement>((Object)this){

            public final BasicElement invoke(BasicElement p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return BaseAffectedObjectAnalyzer.access$getEnclosingFragmentObject((BaseAffectedObjectAnalyzer)this.receiver, p0);
            }
        }, arg_0)).filter(arg_0 -> BaseAffectedObjectAnalyzer.adjustObject$lambda$10(arg_0 -> BaseAffectedObjectAnalyzer.adjustObject$lambda$9(schema, arg_0), arg_0)).first()) != null) {
            String string = candidate2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            ObjectKind objectKind3 = candidate2.getKind();
            Intrinsics.checkNotNullExpressionValue((Object)objectKind3, (String)"getKind(...)");
            return new ObjectAdjustment(string, objectKind3, BelongingAreaKind.A_SCHEMA);
        }
        if (!this.getDatabaseAuxiliaryDetailKinds().contains(kind.element) || namespaces.database != null) {
            // empty if block
        }
        if (this.getServerAuxiliaryDetailKinds().contains(kind.element) && (candidate2 = (BasicElement)BaseAffectedObjectAnalyzer.adjustObject$lambda$1((Lazy<? extends JBIterable<DasObject>>)indexedObjects$delegate).filter(BasicElement.class).filter(arg_0 -> BaseAffectedObjectAnalyzer.adjustObject$lambda$12(arg_0 -> BaseAffectedObjectAnalyzer.adjustObject$lambda$11(kind, arg_0), arg_0)).filterMap(arg_0 -> BaseAffectedObjectAnalyzer.adjustObject$lambda$13((Function1)new Function1<BasicElement, BasicElement>((Object)this){

            public final BasicElement invoke(BasicElement p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return BaseAffectedObjectAnalyzer.access$getEnclosingFragmentObject((BaseAffectedObjectAnalyzer)this.receiver, p0);
            }
        }, arg_0)).filter(arg_0 -> BaseAffectedObjectAnalyzer.adjustObject$lambda$15(arg_0 -> BaseAffectedObjectAnalyzer.adjustObject$lambda$14(this, arg_0), arg_0)).first()) != null) {
            String string = candidate2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            ObjectKind objectKind4 = candidate2.getKind();
            Intrinsics.checkNotNullExpressionValue((Object)objectKind4, (String)"getKind(...)");
            return new ObjectAdjustment(string, objectKind4, BelongingAreaKind.A_ROOT);
        }
        if (!Intrinsics.areEqual((Object)kind.element, (Object)objectKind) || areaKind != belongingAreaKind) {
            BelongingAreaKind belongingAreaKind2 = areaKind;
            if (belongingAreaKind2 == null && (belongingAreaKind2 = this.determineAreaOfKind(namespaces, (ObjectKind)kind.element)) == null) {
                return null;
            }
            areaKind = belongingAreaKind2;
            return new ObjectAdjustment(objectName, (ObjectKind)kind.element, areaKind);
        }
        return null;
    }

    private final BasicElement getEnclosingFragmentObject(BasicElement element) {
        BasicElement basicElement;
        block5: {
            block6: {
                BaseAffectedObjectAnalyzer baseAffectedObjectAnalyzer = this;
                while (true) {
                    BasicElement basicElement2;
                    Object object;
                    BasicElement basicElement3;
                    if ((basicElement3 = element) instanceof BasicMajorObject) {
                        basicElement = element;
                        break block5;
                    }
                    if (basicElement3 instanceof BasicMinorObject) {
                        basicElement = (BasicElement)((BasicMinorObject)element).getMajorObject();
                        break block5;
                    }
                    if (basicElement3 instanceof BasicSchemaObject) {
                        object = ((BasicSchemaObject)element).getParent();
                        basicElement = (BasicElement)(object instanceof BasicMajorObject ? (BasicMajorObject)object : null);
                        break block5;
                    }
                    if (basicElement3 instanceof BasicAuxiliaryObject) {
                        basicElement = element;
                        break block5;
                    }
                    if (!(basicElement3 instanceof BasicAuxiliaryDetail)) break block6;
                    if (((BasicAuxiliaryDetail)element).getParent() == null) break;
                    object = baseAffectedObjectAnalyzer;
                    Intrinsics.checkNotNull((Object)((BasicAuxiliaryDetail)element).getParent());
                    baseAffectedObjectAnalyzer = object;
                    element = basicElement2;
                }
                basicElement = null;
                break block5;
            }
            basicElement = null;
        }
        return basicElement;
    }

    @Nullable
    protected BelongingAreaKind determineAffectionArea(@NotNull Namespaces ns, @Nullable String objectName, @NotNull ObjectKind objectKind, @Nullable BelongingAreaKind givenArea, @NotNull ObjectEffectType effectType) {
        Intrinsics.checkNotNullParameter((Object)ns, (String)"ns");
        Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
        Intrinsics.checkNotNullParameter((Object)effectType, (String)"effectType");
        BelongingAreaKind area = this.determineAreaOfKind(ns, objectKind);
        return area;
    }

    @Nullable
    protected final BelongingAreaKind determineAreaOfKind(@NotNull Namespaces ns, @NotNull ObjectKind theKind) {
        Intrinsics.checkNotNullParameter((Object)ns, (String)"ns");
        Intrinsics.checkNotNullParameter((Object)theKind, (String)"theKind");
        BelongingAreaKind area = null;
        ObjectKind objectKind = theKind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SCHEMA) || Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SCHEMA_OBJECT)) {
            area = BelongingAreaKind.A_SCHEMA;
        } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.DATABASE)) {
            area = BelongingAreaKind.A_DATABASE;
        }
        if (area == null) {
            BasicSchema schema = ns.schema;
            if (schema != null) {
                if (schema.familyOf(theKind) != null) {
                    area = BelongingAreaKind.A_SCHEMA;
                }
            } else {
                ObjectKind objectKind2 = ObjectKind.SCHEMA;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"SCHEMA");
                if (this.parentCanHaveChild(objectKind2, theKind)) {
                    area = BelongingAreaKind.A_SCHEMA;
                }
            }
        }
        if (area == null && this.root instanceof BasicMultiDatabaseRoot) {
            BasicDatabase database = ns.database;
            if (database != null) {
                if (database.familyOf(theKind) != null) {
                    area = BelongingAreaKind.A_DATABASE;
                }
            } else {
                ObjectKind objectKind3 = ObjectKind.DATABASE;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind3, (String)"DATABASE");
                if (this.parentCanHaveChild(objectKind3, theKind)) {
                    area = BelongingAreaKind.A_DATABASE;
                }
            }
        }
        if (area == null && this.root.familyOf(theKind) != null) {
            area = BelongingAreaKind.A_ROOT;
        }
        return area;
    }

    protected final boolean parentCanHaveChild(@NotNull ObjectKind parentKind, @NotNull ObjectKind childKind) {
        Intrinsics.checkNotNullParameter((Object)parentKind, (String)"parentKind");
        Intrinsics.checkNotNullParameter((Object)childKind, (String)"childKind");
        BasicMetaObject basicMetaObject = (BasicMetaObject)this.model.getMetaModel().findMetaObjects(parentKind).first();
        if (basicMetaObject == null) {
            return false;
        }
        BasicMetaObject metaObject = basicMetaObject;
        return BasicMetaFunKt.findChild((BasicMetaObject)metaObject, (ObjectKind)childKind) != null;
    }

    private static final JBIterable adjustObject$lambda$0(BaseAffectedObjectAnalyzer this$0, String $objectName) {
        return this$0.model.getNameIndex().getObjectsByNameInsensitive($objectName);
    }

    private static final JBIterable<DasObject> adjustObject$lambda$1(Lazy<? extends JBIterable<DasObject>> $indexedObjects$delegate) {
        Lazy<? extends JBIterable<DasObject>> lazy = $indexedObjects$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (JBIterable)object;
    }

    private static final boolean adjustObject$lambda$2(Namespaces $namespaces, BasicElement it) {
        return Intrinsics.areEqual((Object)it.getSchema(), (Object)$namespaces.schema);
    }

    private static final boolean adjustObject$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final int adjustObject$lambda$4(BasicElement o1, BasicElement o2) {
        return o1.getKind().getOrder() - o2.getKind().getOrder();
    }

    private static final int adjustObject$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final boolean adjustObject$lambda$6(Ref.ObjectRef $kind, BasicElement it) {
        return Intrinsics.areEqual((Object)it.getKind(), (Object)$kind.element);
    }

    private static final boolean adjustObject$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final BasicElement adjustObject$lambda$8(Function1 $tmp0, Object p0) {
        return (BasicElement)$tmp0.invoke(p0);
    }

    private static final boolean adjustObject$lambda$9(BasicSchema $schema, BasicElement it) {
        BasicElement basicElement = it;
        Intrinsics.checkNotNull((Object)basicElement);
        return Intrinsics.areEqual((Object)basicElement.getParent(), (Object)$schema);
    }

    private static final boolean adjustObject$lambda$10(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean adjustObject$lambda$11(Ref.ObjectRef $kind, BasicElement it) {
        return Intrinsics.areEqual((Object)it.getKind(), (Object)$kind.element);
    }

    private static final boolean adjustObject$lambda$12(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final BasicElement adjustObject$lambda$13(Function1 $tmp0, Object p0) {
        return (BasicElement)$tmp0.invoke(p0);
    }

    private static final boolean adjustObject$lambda$14(BaseAffectedObjectAnalyzer this$0, BasicElement it) {
        BasicElement basicElement = it;
        Intrinsics.checkNotNull((Object)basicElement);
        return Intrinsics.areEqual((Object)basicElement.getParent(), (Object)this$0.root);
    }

    private static final boolean adjustObject$lambda$15(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ BasicElement access$getEnclosingFragmentObject(BaseAffectedObjectAnalyzer $this, BasicElement element) {
        return $this.getEnclosingFragmentObject(element);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0084\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\u0003H\u0016J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\bH\u00c6\u0003J5\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseAffectedObjectAnalyzer$Namespaces;", "", "databaseName", "", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "schemaName", "schema", "Lcom/intellij/database/model/basic/BasicSchema;", "<init>", "(Ljava/lang/String;Lcom/intellij/database/model/basic/BasicDatabase;Ljava/lang/String;Lcom/intellij/database/model/basic/BasicSchema;)V", "toString", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "intellij.database.dialects.base"})
    protected static final class Namespaces {
        @JvmField
        @NotNull
        public final String databaseName;
        @JvmField
        @Nullable
        public final BasicDatabase database;
        @JvmField
        @NotNull
        public final String schemaName;
        @JvmField
        @Nullable
        public final BasicSchema schema;

        public Namespaces(@NotNull String databaseName, @Nullable BasicDatabase database, @NotNull String schemaName, @Nullable BasicSchema schema) {
            Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
            Intrinsics.checkNotNullParameter((Object)schemaName, (String)"schemaName");
            this.databaseName = databaseName;
            this.database = database;
            this.schemaName = schemaName;
            this.schema = schema;
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder;
            StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$toString_u24lambda_u240.append(this.databaseName);
            $this$toString_u24lambda_u240.append(this.database != null ? (char)'!' : '?');
            $this$toString_u24lambda_u240.append('/');
            $this$toString_u24lambda_u240.append(this.schemaName);
            $this$toString_u24lambda_u240.append(this.schema != null ? (char)'!' : '?');
            return stringBuilder.toString();
        }

        @NotNull
        public final String component1() {
            return this.databaseName;
        }

        @Nullable
        public final BasicDatabase component2() {
            return this.database;
        }

        @NotNull
        public final String component3() {
            return this.schemaName;
        }

        @Nullable
        public final BasicSchema component4() {
            return this.schema;
        }

        @NotNull
        public final Namespaces copy(@NotNull String databaseName, @Nullable BasicDatabase database, @NotNull String schemaName, @Nullable BasicSchema schema) {
            Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
            Intrinsics.checkNotNullParameter((Object)schemaName, (String)"schemaName");
            return new Namespaces(databaseName, database, schemaName, schema);
        }

        public static /* synthetic */ Namespaces copy$default(Namespaces namespaces, String string, BasicDatabase basicDatabase, String string2, BasicSchema basicSchema, int n, Object object) {
            if ((n & 1) != 0) {
                string = namespaces.databaseName;
            }
            if ((n & 2) != 0) {
                basicDatabase = namespaces.database;
            }
            if ((n & 4) != 0) {
                string2 = namespaces.schemaName;
            }
            if ((n & 8) != 0) {
                basicSchema = namespaces.schema;
            }
            return namespaces.copy(string, basicDatabase, string2, basicSchema);
        }

        public int hashCode() {
            int result = this.databaseName.hashCode();
            result = result * 31 + (this.database == null ? 0 : this.database.hashCode());
            result = result * 31 + this.schemaName.hashCode();
            result = result * 31 + (this.schema == null ? 0 : this.schema.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Namespaces)) {
                return false;
            }
            Namespaces namespaces = (Namespaces)other;
            if (!Intrinsics.areEqual((Object)this.databaseName, (Object)namespaces.databaseName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.database, (Object)namespaces.database)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.schemaName, (Object)namespaces.schemaName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.schema, (Object)namespaces.schema);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0084\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0007H\u00c6\u0003J'\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseAffectedObjectAnalyzer$ObjectAdjustment;", "", "name", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "area", "Lcom/intellij/database/introspection/BelongingAreaKind;", "<init>", "(Ljava/lang/String;Lcom/intellij/database/model/ObjectKind;Lcom/intellij/database/introspection/BelongingAreaKind;)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.database.dialects.base"})
    protected static final class ObjectAdjustment {
        @JvmField
        @NotNull
        public final String name;
        @JvmField
        @NotNull
        public final ObjectKind kind;
        @JvmField
        @NotNull
        public final BelongingAreaKind area;

        public ObjectAdjustment(@NotNull String name, @NotNull ObjectKind kind, @NotNull BelongingAreaKind area) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)area, (String)"area");
            this.name = name;
            this.kind = kind;
            this.area = area;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final ObjectKind component2() {
            return this.kind;
        }

        @NotNull
        public final BelongingAreaKind component3() {
            return this.area;
        }

        @NotNull
        public final ObjectAdjustment copy(@NotNull String name, @NotNull ObjectKind kind, @NotNull BelongingAreaKind area) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)area, (String)"area");
            return new ObjectAdjustment(name, kind, area);
        }

        public static /* synthetic */ ObjectAdjustment copy$default(ObjectAdjustment objectAdjustment, String string, ObjectKind objectKind, BelongingAreaKind belongingAreaKind, int n, Object object) {
            if ((n & 1) != 0) {
                string = objectAdjustment.name;
            }
            if ((n & 2) != 0) {
                objectKind = objectAdjustment.kind;
            }
            if ((n & 4) != 0) {
                belongingAreaKind = objectAdjustment.area;
            }
            return objectAdjustment.copy(string, objectKind, belongingAreaKind);
        }

        @NotNull
        public String toString() {
            return "ObjectAdjustment(name=" + this.name + ", kind=" + this.kind + ", area=" + this.area + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.kind.hashCode();
            result = result * 31 + this.area.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ObjectAdjustment)) {
                return false;
            }
            ObjectAdjustment objectAdjustment = (ObjectAdjustment)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)objectAdjustment.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.kind, (Object)objectAdjustment.kind)) {
                return false;
            }
            return this.area == objectAdjustment.area;
        }
    }
}

