/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.ed.annotation.attr;

import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.AbstractDynamicAttributeAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaAttributeAnnotation;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.AnnotationModel;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.AnnotationModelBuilder;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.ArrayParameter;
import com.intellij.jpa.jpb.model.model.AttributeOverride;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.Strings;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class AttributeOverridesAnnotation
extends AbstractDynamicAttributeAnnotation {
    public AttributeOverridesAnnotation() {
        super(JpaAttributeAnnotation.AttributeOverrides);
    }

    public static AnnotationModel generateAttributeOverrideModel(String name, String column, Project project, Module module) {
        return AnnotationModel.builder(JpaAttributeAnnotation.AttributeOverride.getFqn(project, module)).add("name", name).add("column", AnnotationModel.builder(JpaAttributeAnnotation.Column.getFqn(project, module)).add("name", column).build()).build();
    }

    public static AnnotationModel generateAttributeOverrideModel(AttributeOverride attributeOverride, Project project, Module module) {
        AnnotationModelBuilder annotationModelBuilder = AnnotationModel.builder(JpaAttributeAnnotation.Column.getFqn(project, module)).add("name", attributeOverride.getColumn());
        if (!attributeOverride.isNullable()) {
            annotationModelBuilder = annotationModelBuilder.add("nullable", String.valueOf(false), false);
        }
        if (attributeOverride.isUnique()) {
            annotationModelBuilder = annotationModelBuilder.add("unique", String.valueOf(true), false);
        }
        if (attributeOverride.getLengthString() != null && attributeOverride.getLength() != 255) {
            annotationModelBuilder = annotationModelBuilder.add("length", attributeOverride.getLengthString(), false);
        }
        if (attributeOverride.getPrecision() != 0) {
            annotationModelBuilder = annotationModelBuilder.add("precision", String.valueOf(attributeOverride.getPrecision()), false);
        }
        if (attributeOverride.getScale() != 0) {
            annotationModelBuilder = annotationModelBuilder.add("scale", String.valueOf(attributeOverride.getScale()), false);
        }
        if (Strings.isNotEmpty((String)attributeOverride.getColumnDefinition())) {
            annotationModelBuilder = annotationModelBuilder.add("columnDefinition", attributeOverride.getColumnDefinition());
        }
        return AnnotationModel.builder(JpaAttributeAnnotation.AttributeOverride.getFqn(project)).add("name", attributeOverride.getName()).add("column", annotationModelBuilder.build()).build();
    }

    @Override
    public boolean isInsert(@NotNull EntityAttribute attribute, @NotNull Entity entity) {
        if (attribute == null) {
            AttributeOverridesAnnotation.$$$reportNull$$$0(0);
        }
        if (entity == null) {
            AttributeOverridesAnnotation.$$$reportNull$$$0(1);
        }
        return (attribute.isEmbedded() || attribute.isElementCollection()) && !attribute.getAttributeOverrides(false).isEmpty();
    }

    @Override
    public boolean isModify() {
        return false;
    }

    @Override
    public AnnotationModel generateModel(EntityAttribute attr, Entity entity, Project project) {
        AnnotationModelBuilder builder = AnnotationModel.builder(this.getFqn(project, entity.getModule()));
        ArrayList<AnnotationModel> attrOverrides = new ArrayList<AnnotationModel>();
        for (AttributeOverride entry : attr.getAttributeOverrides(false)) {
            attrOverrides.add(AttributeOverridesAnnotation.generateAttributeOverrideModel(entry.getName(), entry.getColumn(), project, entity.getModule()));
        }
        builder.add("value", new ArrayParameter(attrOverrides).multiline());
        return builder.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "attribute";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "entity";
                break;
            }
        }
        objectArray[1] = "com/intellij/jpa/jpb/model/backend/ed/annotation/attr/AttributeOverridesAnnotation";
        objectArray[2] = "isInsert";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

