/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.ed.indexing;

import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.HibernateEnversAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaEntityAnnotation;
import com.intellij.jpa.jpb.model.core.CacheKeyStore;
import com.intellij.jpa.jpb.model.liquibase.ns.PhysicalNamingStrategy;
import com.intellij.jpa.jpb.model.model.DbIdentifierHelper;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityPsi;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.jpa.jpb.model.util.QueryUtil;
import com.intellij.jpa.jpb.model.util.StudioAnnotationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.EmptyQuery;
import com.intellij.util.FilteredQuery;
import com.intellij.util.MergeQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EntitySearch {
    private static final Logger LOGGER = Logger.getInstance(EntitySearch.class);
    private final Project project;

    public EntitySearch(Project project) {
        this.project = project;
    }

    public static EntitySearch getInstance(Project project) {
        return (EntitySearch)project.getService(EntitySearch.class);
    }

    public abstract void walkEntityClasses(GlobalSearchScope var1, Processor<PsiClass> var2);

    public abstract Collection<PsiClass> getChildEntities(String var1, SearchScope var2, boolean var3);

    public abstract Collection<PsiClass> getProjectEntities();

    public abstract Collection<PsiClass> getBaseEntities();

    public abstract Collection<PsiClass> getEntities(GlobalSearchScope var1);

    public abstract void walkProjectEntityClasses(Processor<PsiClass> var1);

    public abstract void walkEntityClasses(GlobalSearchScope var1, Processor<PsiClass> var2, @Nullable String var3);

    @Nullable
    public abstract PsiClass find(@Nullable String var1, @Nullable String var2);

    @Nullable
    public abstract PsiClass findByQualifiedName(String var1);

    @Nullable
    public abstract PsiClass findByQualifiedName(String var1, GlobalSearchScope var2);

    @Nullable
    public abstract PsiClass findByName(String var1);

    @Nullable
    public abstract PsiClass findByName(String var1, GlobalSearchScope var2);

    @Nullable
    public abstract PsiClass getPropertyReferenceClass(PsiClass var1, String var2);

    @Nullable
    public abstract PsiClass findByClassName(String var1, GlobalSearchScope var2);

    public Collection<PsiClass> getChildProjectEntities(String baseEntityFqn, boolean checkDeep) {
        return this.getChildEntities(baseEntityFqn, SearchScope.PROJECT_PRODUCTION, checkDeep);
    }

    @NotNull
    public Query<PsiClass> getEntitiesQuery(GlobalSearchScope scope, @Nullable String baseEntityFqn) {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.project);
        if (StringUtil.isEmpty((String)baseEntityFqn)) {
            Query query = StreamEx.of(this.getEntityAnnotations(globalSearchScope)).map(annotationClass -> AnnotatedElementsSearch.searchElements((PsiClass)annotationClass, (com.intellij.psi.search.SearchScope)scope, (Class[])new Class[]{PsiClass.class})).reduce(MergeQuery::new).map(QueryUtil::uniqueByFqn).orElse(EmptyQuery.getEmptyQuery());
            if (query == null) {
                EntitySearch.$$$reportNull$$$0(0);
            }
            return query;
        }
        PsiClass baseEntityClass = JavaPsiFacade.getInstance((Project)this.project).findClass(baseEntityFqn, globalSearchScope);
        if (baseEntityClass == null) {
            LOGGER.warn("Base entity interface not found");
            Query query = EmptyQuery.getEmptyQuery();
            if (query == null) {
                EntitySearch.$$$reportNull$$$0(1);
            }
            return query;
        }
        Query baseQuery = ClassInheritorsSearch.search((PsiClass)baseEntityClass, (com.intellij.psi.search.SearchScope)scope, (boolean)true, (boolean)true, (boolean)false);
        return new FilteredQuery(QueryUtil.uniqueByFqn((Query<PsiClass>)baseQuery), EntityUtil::isEntity);
    }

    protected Collection<PsiClass> getEntityAnnotations(GlobalSearchScope searchScope) {
        return StreamEx.of((Object[])new Set[]{JpaEntityAnnotation.Entity.getAllFqns(this.project), JpaEntityAnnotation.MappedSuperclass.getAllFqns(this.project), JpaEntityAnnotation.Embeddable.getAllFqns(this.project)}).flatMap(Collection::stream).map(s -> JavaPsiFacade.getInstance((Project)this.project).findClass(s, searchScope)).nonNull().toList();
    }

    @Nullable
    public PsiClass findEntityPsiClass(@Nullable Entity entity) {
        if (entity == null) {
            return null;
        }
        if (entity instanceof EntityPsi) {
            return ((EntityPsi)entity).getPsiClass();
        }
        String entityName = entity.getFqn();
        return StringUtils.isBlank((CharSequence)entityName) ? null : this.findByQualifiedName(entityName);
    }

    @Nullable
    public Entity findEntityByQualifiedName(@Nullable String fqn) {
        PsiClass entityClass = fqn == null ? null : this.findByQualifiedName(fqn);
        return entityClass == null ? null : EntityPsi.getInstance(entityClass);
    }

    @Nullable
    public Entity findEntityByClassName(@Nullable String className, GlobalSearchScope searchScope) {
        PsiClass entityClass = className == null ? null : this.findByClassName(className, searchScope);
        return entityClass == null ? null : EntityPsi.getInstance(entityClass);
    }

    public List<Entity> getProjectWrapEntities() {
        return ContainerUtil.map(this.getProjectEntities(), EntityPsi::getInstance);
    }

    public List<Entity> getAllWrapEntities() {
        return ContainerUtil.map(this.getEntities(GlobalSearchScope.allScope((Project)this.project)), EntityPsi::getInstance);
    }

    public List<Entity> getModuleEntities(Module module) {
        if (module == null) {
            return new ArrayList<Entity>();
        }
        return ContainerUtil.map(this.getEntities(GlobalSearchScope.moduleScope((Module)module)), EntityPsi::getInstance);
    }

    @Nullable
    public PsiClass findByTableName(@NotNull String tableName, @NotNull SearchScope searchScope) {
        if (tableName == null) {
            EntitySearch.$$$reportNull$$$0(2);
        }
        if (searchScope == null) {
            EntitySearch.$$$reportNull$$$0(3);
        }
        String keyValue = "EntitySearch#findByTableName:" + tableName + ":" + searchScope.name();
        Key key = CacheKeyStore.getInstance(this.project).getKey(keyValue);
        return (PsiClass)CachedValuesManager.getManager((Project)this.project).getCachedValue((UserDataHolder)this.project, key, () -> {
            GlobalSearchScope globalSearchScope = EntitySearch.getGlobalSearchScope(this.project, searchScope);
            PsiClass result = this.findByTableName(this.getEntities(globalSearchScope), tableName);
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }, false);
    }

    public PsiClass findByTableName(Collection<PsiClass> scopeEntities, @NotNull String tableName) {
        if (tableName == null) {
            EntitySearch.$$$reportNull$$$0(4);
        }
        return (PsiClass)EntityUtil.ra(() -> {
            try {
                PhysicalNamingStrategy namingStrategy = PhysicalNamingStrategy.getInstance(this.project);
                List theSameTableEntities = ((StreamEx)StreamEx.of((Collection)scopeEntities).filter(entityClass -> {
                    String table = namingStrategy.toTableName(EntityUtil.getTable(entityClass, false));
                    return DbIdentifierHelper.compareIdentifier(tableName, table);
                })).toList();
                if (theSameTableEntities.isEmpty()) {
                    return null;
                }
                PsiClass firstEntity = (PsiClass)theSameTableEntities.iterator().next();
                if (theSameTableEntities.size() == 1) {
                    return firstEntity;
                }
                return StreamEx.of((Collection)theSameTableEntities).findFirst(rootEntity -> theSameTableEntities.stream().filter(psiClass -> psiClass != rootEntity).allMatch(childEntity -> childEntity.isInheritor(rootEntity, true))).orElse(firstEntity);
            }
            catch (IndexNotReadyException e) {
                LOGGER.warn("Index not ready exception during entity search", (Throwable)e);
                return null;
            }
        });
    }

    @Nullable
    public PsiClass findByAuditTableName(@NotNull String auditTableName) {
        if (auditTableName == null) {
            EntitySearch.$$$reportNull$$$0(5);
        }
        return (PsiClass)EntityUtil.ra(() -> {
            try {
                String annotationFqn = HibernateEnversAnnotation.AuditTable.getFqn(this.project, null);
                PsiClass annotationClass = JavaPsiFacade.getInstance((Project)this.project).findClass(annotationFqn, GlobalSearchScope.allScope((Project)this.project));
                if (annotationClass == null) {
                    return null;
                }
                PhysicalNamingStrategy namingStrategy = PhysicalNamingStrategy.getInstance(this.project);
                return (PsiClass)AnnotatedElementsSearch.searchElements((PsiClass)annotationClass, (com.intellij.psi.search.SearchScope)GlobalSearchScopesCore.projectProductionScope((Project)this.project), (Class[])new Class[]{PsiClass.class}).filtering(entityClass -> {
                    String auditTableLogicalName = StudioAnnotationUtil.getStringAttributeValue((PsiModifierListOwner)entityClass, annotationFqn, "value");
                    return namingStrategy.compareLogicalWithPhysicalTableNames(auditTableLogicalName, auditTableName);
                }).findFirst();
            }
            catch (IndexNotReadyException e) {
                LOGGER.warn("Index not ready exception during entity search", (Throwable)e);
                return null;
            }
        });
    }

    public static GlobalSearchScope getGlobalSearchScope(Project project, SearchScope searchScope) {
        if (searchScope == SearchScope.PROJECT_PRODUCTION) {
            return GlobalSearchScopesCore.projectProductionScope((Project)project);
        }
        return GlobalSearchScope.allScope((Project)project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/backend/ed/indexing/EntitySearch";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "auditTableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntitiesQuery";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/backend/ed/indexing/EntitySearch";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findByTableName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findByAuditTableName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }

    public static enum SearchScope {
        PROJECT_PRODUCTION,
        ALL;

    }
}

