/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.coverage;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.javascript.karma.coverage.KarmaCoverageResultPaths;
import com.intellij.javascript.karma.coverage.KarmaCoverageSession;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.karma.server.StreamEventHandler;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaCoveragePeer {
    private final Path myCoverageTempDir = Files.createTempDirectory("karma-intellij-coverage-", new FileAttribute[0]);
    private volatile KarmaCoverageSession myActiveCoverageSession;

    @NotNull
    public Path getCoverageTempDir() {
        Path path = this.myCoverageTempDir;
        if (path == null) {
            KarmaCoveragePeer.$$$reportNull$$$0(0);
        }
        return path;
    }

    public void startCoverageSession(@NotNull KarmaCoverageSession coverageSession) {
        if (coverageSession == null) {
            KarmaCoveragePeer.$$$reportNull$$$0(1);
        }
        if (Files.isDirectory(this.myCoverageTempDir, new LinkOption[0])) {
            try {
                List children = NioFiles.list((Path)this.myCoverageTempDir);
                for (Path child : children) {
                    NioFiles.deleteRecursively((Path)child);
                }
            }
            catch (IOException e) {
                Logger.getInstance(KarmaCoveragePeer.class).warn("Failed to delete content of " + String.valueOf(this.myCoverageTempDir));
            }
        } else {
            try {
                Files.createDirectory(this.myCoverageTempDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                Logger.getInstance(KarmaCoveragePeer.class).warn("Failed to create " + String.valueOf(this.myCoverageTempDir));
            }
        }
        this.myActiveCoverageSession = coverageSession;
    }

    public void registerEventHandlers(final @NotNull KarmaServer server) {
        if (server == null) {
            KarmaCoveragePeer.$$$reportNull$$$0(2);
        }
        server.registerStreamEventHandler(new StreamEventHandler(){

            @Override
            @NotNull
            public String getEventType() {
                return "coverageFinished";
            }

            @Override
            public void handle(@NotNull JsonElement eventBody) {
                if (eventBody == null) {
                    1.$$$reportNull$$$0(0);
                }
                KarmaCoverageSession coverageSession = KarmaCoveragePeer.this.myActiveCoverageSession;
                KarmaCoveragePeer.this.myActiveCoverageSession = null;
                if (coverageSession != null) {
                    JsonObject coverageData = (JsonObject)ObjectUtils.tryCast((Object)eventBody, JsonObject.class);
                    String lcovFilePath = JsonUtil.getChildAsString((JsonObject)coverageData, (String)"lcovFilePath");
                    String projectRoot = JsonUtil.getChildAsString((JsonObject)coverageData, (String)"projectRoot");
                    KarmaCoverageResultPaths coverageResultPaths = null;
                    if (StringUtil.isNotEmpty((String)lcovFilePath) && StringUtil.isNotEmpty((String)projectRoot)) {
                        Path localLcovFilePath = KarmaCoveragePeer.convertTargetPathToLocal(server.getTargetRun(), lcovFilePath, "lcovFilePath");
                        Path localProjectRoot = KarmaCoveragePeer.convertTargetPathToLocal(server.getTargetRun(), projectRoot, "projectRoot");
                        if (localLcovFilePath != null && localProjectRoot != null) {
                            coverageResultPaths = new KarmaCoverageResultPaths(localLcovFilePath, localProjectRoot);
                        }
                    }
                    coverageSession.onCoverageSessionFinished(coverageResultPaths);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventBody", "com/intellij/javascript/karma/coverage/KarmaCoveragePeer$1", "handle"));
            }
        });
    }

    @Nullable
    private static Path convertTargetPathToLocal(@NotNull NodeTargetRun targetRun, @NotNull String targetFilePath, @NotNull String pathName) {
        Path path;
        String localPath;
        if (targetRun == null) {
            KarmaCoveragePeer.$$$reportNull$$$0(3);
        }
        if (targetFilePath == null) {
            KarmaCoveragePeer.$$$reportNull$$$0(4);
        }
        if (pathName == null) {
            KarmaCoveragePeer.$$$reportNull$$$0(5);
        }
        try {
            localPath = targetRun.convertTargetPathToLocalPath(targetFilePath);
        }
        catch (IllegalArgumentException e) {
            Logger.getInstance(KarmaCoveragePeer.class).warn("Cannot convert " + pathName, (Throwable)e);
            return null;
        }
        try {
            path = Path.of(localPath, new String[0]);
        }
        catch (InvalidPathException e) {
            Logger.getInstance(KarmaCoveragePeer.class).warn("Cannot find path for " + localPath + " (" + pathName + ")", (Throwable)e);
            return null;
        }
        if (!Files.exists(path, new LinkOption[0])) {
            Logger.getInstance(KarmaCoveragePeer.class).warn("File " + String.valueOf(path) + " doesn't exists (" + pathName + ")");
            return null;
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/coverage/KarmaCoveragePeer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageSession";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRun";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFilePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageTempDir";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/coverage/KarmaCoveragePeer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startCoverageSession";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerEventHandlers";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertTargetPathToLocal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

