/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile;

import com.intellij.docker.composeFile.ComposeFileUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PathUtilRt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/docker/composeFile/ComposeGeneratedFilesFilter;", "Lcom/intellij/openapi/roots/GeneratedSourcesFilter;", "<init>", "()V", "isGeneratedSource", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "removeExtension", "", "fileName", "intellij.clouds.docker.compose"})
public final class ComposeGeneratedFilesFilter
extends GeneratedSourcesFilter {
    public boolean isGeneratedSource(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (file.isDirectory() || !file.isValid()) {
            return false;
        }
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.endsWith$default((String)this.removeExtension(string), (String)"generated.override", (boolean)false, (int)2, null)) {
            return false;
        }
        Object object = ReadAction.compute(() -> ComposeGeneratedFilesFilter.isGeneratedSource$lambda$0(project, file));
        YAMLFile yAMLFile = object instanceof YAMLFile ? (YAMLFile)object : null;
        if (yAMLFile == null) {
            return false;
        }
        YAMLFile psiFile = yAMLFile;
        return ComposeFileUtil.isDockerComposeYamlFile(psiFile);
    }

    private final String removeExtension(String fileName) {
        String string;
        String extension = PathUtilRt.getFileExtension((String)fileName);
        if (extension != null) {
            String string2 = fileName.substring(0, fileName.length() - (extension.length() + 1));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = fileName;
        }
        return string;
    }

    private static final PsiFile isGeneratedSource$lambda$0(Project $project, VirtualFile $file) {
        return PsiManager.getInstance((Project)$project).findFile($file);
    }
}

