/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.ql.psi.impl;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.jpa.ql.model.QlElement;
import com.intellij.jpa.ql.model.QlEntity;
import com.intellij.jpa.ql.model.QlModel;
import com.intellij.jpa.ql.psi.QlAliasDefinition;
import com.intellij.jpa.ql.psi.QlColumnExpression;
import com.intellij.jpa.ql.psi.QlConstructorArgumentsList;
import com.intellij.jpa.ql.psi.QlConstructorExpression;
import com.intellij.jpa.ql.psi.QlExpression;
import com.intellij.jpa.ql.psi.QlIdentifier;
import com.intellij.jpa.ql.psi.QlInVariableExpression;
import com.intellij.jpa.ql.psi.QlJoinExpression;
import com.intellij.jpa.ql.psi.QlReferenceExpression;
import com.intellij.jpa.ql.psi.QlStringLiteral;
import com.intellij.jpa.ql.psi.QlTableExpression;
import com.intellij.jpa.ql.psi.impl.QlExpressionBaseImpl;
import com.intellij.jpa.ql.psi.impl.QlReferenceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QlPsiImplUtil {
    private static final PsiPrimitiveType VOID_TYPE = PsiTypes.voidType();
    public static final PsiArrayType PACKAGE_TYPE = new PsiArrayType((PsiType)VOID_TYPE);

    private QlPsiImplUtil() {
    }

    @NotNull
    public static PsiPolyVariantReference getReference(QlReferenceExpression o) {
        return new QlReferenceImpl(o);
    }

    @Nullable
    public static QlExpression getQualifier(QlReferenceExpression o) {
        return (QlExpression)PsiTreeUtil.findChildOfType((PsiElement)o, QlExpression.class);
    }

    @Nullable
    public static Object resolve(QlReferenceExpression o) {
        ResolveResult result;
        ResolveResult[] results = o.getReference().multiResolve(false);
        ResolveResult resolveResult = result = results.length > 0 ? results[0] : null;
        if (result == null) {
            return null;
        }
        if (result instanceof QlReferenceImpl.QlResolveResult) {
            return ((QlReferenceImpl.QlResolveResult)result).getPersistentElement();
        }
        return result.getElement();
    }

    @Nullable
    public static PsiType getPsiType(QlReferenceExpression o) {
        Object target = o.resolve();
        if (target == null) {
            return null;
        }
        if (target instanceof QlAliasDefinition) {
            Object o1;
            QlExpression expression = ((QlAliasDefinition)target).getExpression();
            if (expression instanceof QlReferenceExpression && (o1 = ((QlReferenceExpression)expression).resolve()) instanceof QlElement) {
                PsiType componentType;
                PsiType psiType = ((QlElement)o1).getPsiType();
                if (QlPsiImplUtil.isReferenceToJoinArgumentExpression((QlAliasDefinition)target, expression) && (componentType = QlPsiImplUtil.getComponentType(psiType)) != null) {
                    return componentType;
                }
                return psiType;
            }
            return null;
        }
        if (target instanceof QlElement) {
            return ((QlElement)target).getPsiType();
        }
        if (target instanceof QlInVariableExpression) {
            QlReferenceExpression referenceExpression = ((QlInVariableExpression)target).getReferenceExpression();
            return referenceExpression == null ? null : referenceExpression.getPsiType();
        }
        if (target instanceof PsiField) {
            return ((PsiField)target).getType();
        }
        if (target instanceof QlReferenceExpression) {
            return target.equals(o) && ((QlReferenceExpression)target).getText().equals("size") ? JavaPsiFacade.getInstance((Project)o.getProject()).getElementFactory().createTypeFromText("java.lang.Integer", (PsiElement)o) : null;
        }
        if (target instanceof PsiPackage) {
            return PACKAGE_TYPE;
        }
        if (target instanceof PsiClass) {
            return PsiElementFactory.getInstance((Project)o.getProject()).createType((PsiClass)target);
        }
        return null;
    }

    @Nullable
    private static PsiType getComponentType(PsiType psiType) {
        if (psiType instanceof PsiArrayType) {
            return ((PsiArrayType)psiType).getComponentType();
        }
        return PsiUtil.extractIterableTypeParameter((PsiType)psiType, (boolean)false);
    }

    private static boolean isReferenceToJoinArgumentExpression(QlAliasDefinition o, QlExpression expression) {
        QlJoinExpression joinExpression = (QlJoinExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, QlJoinExpression.class);
        return joinExpression != null && o.equals(joinExpression.getJoinArgument());
    }

    @NotNull
    public static PsiElement getNavigationElement(QlReferenceExpression o) {
        QlIdentifier qlIdentifier = o.getIdentifier();
        if (qlIdentifier == null) {
            QlPsiImplUtil.$$$reportNull$$$0(0);
        }
        return qlIdentifier;
    }

    @Nullable
    public static PsiReference getReference(QlConstructorExpression o) {
        QlReferenceExpression expression = o.getReferenceExpression();
        if (expression == null) {
            return null;
        }
        return new PsiReferenceBase<QlConstructorExpression>(o, TextRange.from((int)expression.getStartOffsetInParent(), (int)expression.getTextLength())){

            public PsiElement resolve() {
                return QlPsiImplUtil.resolveConstructor((QlConstructorExpression)this.getElement());
            }
        };
    }

    @Nullable
    public static PsiPolyVariantReference getReference(final QlStringLiteral o) {
        QlReferenceExpression ref;
        PsiElement parent = o.getParent();
        final QlModel model = QlReferenceImpl.getPersistenceModel(o);
        final String unquote = StringUtil.unquoteString((String)o.getText());
        if (parent instanceof QlTableExpression) {
            return new PsiPolyVariantReferenceBase<QlStringLiteral>(o, TextRange.create((int)1, (int)(o.getTextLength() - 1))){

                public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
                    final LinkedHashSet result = new LinkedHashSet();
                    model.processInDbSchema(new PsiScopeProcessor(){

                        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                            if (element == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (state == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            if (element instanceof PsiNamedElement && Comparing.equal((String)unquote, (String)((PsiNamedElement)element).getName(), (boolean)true)) {
                                result.add(new PsiElementResolveResult(element));
                            }
                            return true;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "element";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "state";
                                    break;
                                }
                            }
                            objectArray[1] = "com/intellij/jpa/ql/psi/impl/QlPsiImplUtil$2$1";
                            objectArray[2] = "execute";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    }, ResolveState.initial());
                    ResolveResult[] resolveResultArray = result.toArray(ResolveResult.EMPTY_ARRAY);
                    if (resolveResultArray == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return resolveResultArray;
                }

                public Object @NotNull [] getVariants() {
                    final LinkedHashSet result = new LinkedHashSet();
                    model.processInDbSchema(new PsiScopeProcessor(){

                        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                            if (element == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            if (state == null) {
                                2.$$$reportNull$$$0(1);
                            }
                            if (element instanceof PsiNamedElement) {
                                result.add(LookupElementBuilder.create((PsiNamedElement)((PsiNamedElement)element)).withIcon(QlReferenceImpl.getIcon(element)));
                            }
                            return true;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "element";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "state";
                                    break;
                                }
                            }
                            objectArray[1] = "com/intellij/jpa/ql/psi/impl/QlPsiImplUtil$2$2";
                            objectArray[2] = "execute";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    }, ResolveState.initial());
                    Object[] objectArray = ArrayUtil.toObjectArray(result);
                    if (objectArray == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return objectArray;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/jpa/ql/psi/impl/QlPsiImplUtil$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "multiResolve";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getVariants";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
        }
        if (parent instanceof QlColumnExpression && (ref = (QlReferenceExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)o, QlReferenceExpression.class)) != null) {
            return new PsiPolyVariantReferenceBase<QlStringLiteral>(o, TextRange.create((int)1, (int)(o.getTextLength() - 1))){

                public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
                    LinkedHashSet result = new LinkedHashSet();
                    QlReferenceImpl.HintedPsiScopeProcessor processor = QlReferenceImpl.createResolveProcessor(model, unquote, result, false);
                    QlReferenceImpl.processQualifierExpression(o.getProject(), ref, processor, ResolveState.initial(), o);
                    ResolveResult[] resolveResultArray = result.toArray(ResolveResult.EMPTY_ARRAY);
                    if (resolveResultArray == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return resolveResultArray;
                }

                public Object @NotNull [] getVariants() {
                    LinkedHashSet result = new LinkedHashSet();
                    PsiScopeProcessor processor = QlReferenceImpl.getCompletionProcessor(result);
                    QlReferenceImpl.processQualifierExpression(o.getProject(), ref, processor, ResolveState.initial(), o);
                    Object[] objectArray = ArrayUtil.toObjectArray(result);
                    if (objectArray == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    return objectArray;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/jpa/ql/psi/impl/QlPsiImplUtil$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "multiResolve";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getVariants";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
        }
        return null;
    }

    @NotNull
    public static List<QlExpression> getParameters(QlConstructorExpression o) {
        QlConstructorArgumentsList list = o.getConstructorArgumentsList();
        if (list == null) {
            List<QlExpression> list2 = Collections.emptyList();
            if (list2 == null) {
                QlPsiImplUtil.$$$reportNull$$$0(1);
            }
            return list2;
        }
        List<QlExpression> list3 = list.getExpressionList();
        if (list3 == null) {
            QlPsiImplUtil.$$$reportNull$$$0(2);
        }
        return list3;
    }

    @NotNull
    public static List<PsiType> getParameterTypes(QlConstructorExpression o) {
        List<QlExpression> parameters = QlPsiImplUtil.getParameters(o);
        SmartList types = new SmartList();
        for (QlExpression parameter : parameters) {
            types.add(QlExpressionBaseImpl.getPsiType(parameter));
        }
        SmartList smartList = types;
        if (smartList == null) {
            QlPsiImplUtil.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    @Nullable
    public static PsiMethod resolveConstructor(@NotNull QlConstructorExpression o) {
        if (o == null) {
            QlPsiImplUtil.$$$reportNull$$$0(4);
        }
        return QlPsiImplUtil.resolveConstructor(o.getProject(), o.getPsiClass(), QlPsiImplUtil.getParameterTypes(o));
    }

    @Nullable
    public static PsiMethod resolveConstructor(@NotNull Project project, @Nullable PsiClass psiClass, @NotNull List<PsiType> typeList) {
        if (project == null) {
            QlPsiImplUtil.$$$reportNull$$$0(5);
        }
        if (typeList == null) {
            QlPsiImplUtil.$$$reportNull$$$0(6);
        }
        if (psiClass == null) {
            return null;
        }
        PsiType[] types = typeList.toArray(PsiType.createArray((int)typeList.size()));
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)project).getResolveHelper();
        block0: for (PsiMethod constructor : psiClass.getConstructors()) {
            if (constructor.getParameterList().getParametersCount() != types.length) continue;
            MethodSignature emptySignature = constructor.getSignature(PsiSubstitutor.EMPTY);
            PsiType[] parameterTypes = emptySignature.getParameterTypes();
            PsiTypeParameter[] typeParameters = (PsiTypeParameter[])ArrayUtil.mergeArrays((Object[])psiClass.getTypeParameters(), (Object[])constructor.getTypeParameters(), (ArrayFactory)PsiTypeParameter.ARRAY_FACTORY);
            MethodSignature targetSignature = typeParameters.length == 0 ? emptySignature : constructor.getSignature(helper.inferTypeArguments(typeParameters, parameterTypes, types, PsiUtil.getLanguageLevel((PsiElement)psiClass)));
            PsiType[] targetTypes = targetSignature.getParameterTypes();
            for (int i = 0; i < types.length; ++i) {
                if (types[i] != null && !targetTypes[i].isAssignableFrom(types[i])) continue block0;
            }
            return constructor;
        }
        return null;
    }

    @Nullable
    public static PsiClass getPsiClass(@NotNull QlConstructorExpression o) {
        QlReferenceExpression refExpression;
        if (o == null) {
            QlPsiImplUtil.$$$reportNull$$$0(7);
        }
        Object target = (refExpression = o.getReferenceExpression()) == null ? null : refExpression.resolve();
        return QlPsiImplUtil.getPsiClassInner(target);
    }

    @Nullable
    public static PsiClass getPsiClassInner(@Nullable Object target) {
        if (target instanceof PsiClass) {
            return (PsiClass)target;
        }
        if (target instanceof QlEntity) {
            return PsiTypesUtil.getPsiClass((PsiType)((QlEntity)target).getPsiType());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/ql/psi/impl/QlPsiImplUtil";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterTypes";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/ql/psi/impl/QlPsiImplUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveConstructor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPsiClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

