/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.spatial;

import androidx.collection.IntObjectMap;
import androidx.collection.IntObjectMapKt;
import androidx.collection.MutableObjectList;
import androidx.collection.ObjectList;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.Actual_jvmKt;
import androidx.compose.ui.Actuals_skikoKt;
import androidx.compose.ui.ComposeUiFlags;
import androidx.compose.ui.geometry.MutableRect;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.graphics.MatrixKt;
import androidx.compose.ui.node.DelegatableNode;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.MeasurePassDelegate;
import androidx.compose.ui.node.NodeCoordinator;
import androidx.compose.ui.node.OwnedLayer;
import androidx.compose.ui.spatial.RectList;
import androidx.compose.ui.spatial.RectManagerKt;
import androidx.compose.ui.spatial.RelativeLayoutBounds;
import androidx.compose.ui.spatial.ThrottledCallbacks;
import androidx.compose.ui.spatial.ThrottledCallbacksKt;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntOffsetKt;
import androidx.compose.ui.unit.IntSize;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u000bJ8\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u001dH\u0002J*\u0010(\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010)\u001a\u00020*2\u0006\u0010#\u001a\u00020\u000fH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b+\u0010,J\u0010\u0010-\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u0004H\u0002J\u0006\u0010.\u001a\u00020\u000bJ\u000e\u0010/\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u0004J\u001d\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u001d2\u0006\u00102\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b3J\u000e\u00104\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u0004J(\u00105\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010)\u001a\u00020*2\u0006\u0010#\u001a\u00020\u000f\u00f8\u0001\u0000\u00a2\u0006\u0004\b6\u0010,J\u0016\u00107\u001a\u0004\u0018\u00010\u00012\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ:\u00109\u001a\u00020:2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010;\u001a\u00020\u00172\u0006\u0010<\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u000b0=J:\u0010>\u001a\u00020:2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010;\u001a\u00020\u00172\u0006\u0010<\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u000b0=J\u000e\u0010?\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u0004J\u000e\u0010@\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020\u000fJ\u0010\u0010B\u001a\u00020\u000b2\b\u0010C\u001a\u0004\u0018\u00010\u0001J(\u0010D\u001a\u00020\u000b2\u0006\u0010E\u001a\u00020*2\u0006\u0010F\u001a\u00020*2\u0006\u0010G\u001a\u00020H\u00f8\u0001\u0000\u00a2\u0006\u0004\bI\u0010JJ\u0014\u0010K\u001a\u00020\u000b*\u00020L2\u0006\u0010M\u001a\u00020\u0007H\u0002J\u0019\u0010N\u001a\u00020**\u00020\u0004H\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\bO\u0010PJ\u0019\u0010Q\u001a\u00020**\u00020LH\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\bR\u0010SR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006T"}, d2={"Landroidx/compose/ui/spatial/RectManager;", "", "layoutNodes", "Landroidx/collection/IntObjectMap;", "Landroidx/compose/ui/node/LayoutNode;", "(Landroidx/collection/IntObjectMap;)V", "cachedRect", "Landroidx/compose/ui/geometry/MutableRect;", "callbacks", "Landroidx/collection/MutableObjectList;", "Lkotlin/Function0;", "", "dispatchLambda", "dispatchToken", "isDirty", "", "isFragmented", "isScreenOrWindowDirty", "rects", "Landroidx/compose/ui/spatial/RectList;", "getRects", "()Landroidx/compose/ui/spatial/RectList;", "scheduledDispatchDeadline", "", "throttledCallbacks", "Landroidx/compose/ui/spatial/ThrottledCallbacks;", "currentRectInfo", "Landroidx/compose/ui/spatial/RelativeLayoutBounds;", "id", "", "node", "Landroidx/compose/ui/node/DelegatableNode;", "dispatchCallbacks", "insertOrUpdate", "layoutNode", "firstPlacement", "l", "t", "r", "b", "insertOrUpdateTransformedNode", "position", "Landroidx/compose/ui/unit/IntOffset;", "insertOrUpdateTransformedNode-70tqf50", "(Landroidx/compose/ui/node/LayoutNode;JZ)V", "insertOrUpdateTransformedNodeSubhierarchy", "invalidate", "invalidateCallbacksFor", "isTargetDrawnFirst", "targetId", "otherId", "isTargetDrawnFirst$ui", "onLayoutLayerPositionalPropertiesChanged", "onLayoutPositionChanged", "onLayoutPositionChanged-70tqf50", "registerOnChangedCallback", "callback", "registerOnGlobalLayoutCallback", "Landroidx/compose/ui/node/DelegatableNode$RegistrationHandle;", "throttleMillis", "debounceMillis", "Lkotlin/Function1;", "registerOnRectChangedCallback", "remove", "scheduleDebounceCallback", "ensureSomethingScheduled", "unregisterOnChangedCallback", "token", "updateOffsets", "screenOffset", "windowOffset", "viewToWindowMatrix", "Landroidx/compose/ui/graphics/Matrix;", "updateOffsets-ucfNpQE", "(JJ[F)V", "boundingRectInRoot", "Landroidx/compose/ui/node/NodeCoordinator;", "rect", "outerToInnerOffset", "outerToInnerOffset-Bjo55l4", "(Landroidx/compose/ui/node/LayoutNode;)J", "positionInRoot", "positionInRoot-Bjo55l4", "(Landroidx/compose/ui/node/NodeCoordinator;)J", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nRectManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RectManager.kt\nandroidx/compose/ui/spatial/RectManager\n+ 2 ObjectList.kt\nandroidx/collection/ObjectListKt\n+ 3 RectManager.kt\nandroidx/compose/ui/spatial/RectManagerKt\n+ 4 ObjectList.kt\nandroidx/collection/ObjectList\n+ 5 RectList.kt\nandroidx/compose/ui/spatial/RectList\n+ 6 RectList.kt\nandroidx/compose/ui/spatial/RectListKt\n+ 7 LayoutNode.kt\nandroidx/compose/ui/node/LayoutNode\n+ 8 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 9 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n+ 10 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 11 IntSize.kt\nandroidx/compose/ui/unit/IntSizeKt\n+ 12 IntOffset.kt\nandroidx/compose/ui/unit/IntOffsetKt\n+ 13 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n*L\n1#1,547:1\n1516#2:548\n544#3:549\n540#3:607\n544#3:608\n287#4,6:550\n725#5,7:556\n732#5,4:564\n736#5,7:569\n835#6:563\n810#6:568\n207#7:576\n207#7:592\n423#8,9:577\n423#8,9:593\n54#9:586\n59#9:588\n85#10:587\n90#10:589\n80#10:591\n53#10,3:604\n30#11:590\n159#12:602\n30#13:603\n*S KotlinDebug\n*F\n+ 1 RectManager.kt\nandroidx/compose/ui/spatial/RectManager\n*L\n50#1:548\n75#1:549\n425#1:607\n426#1:608\n90#1:550,6\n91#1:556,7\n91#1:564,4\n91#1:569,7\n91#1:563\n91#1:568\n213#1:576\n303#1:592\n213#1:577,9\n303#1:593,9\n249#1:586\n250#1:588\n249#1:587\n250#1:589\n288#1:591\n402#1:604,3\n288#1:590\n402#1:602\n402#1:603\n*E\n"})
public final class RectManager {
    @NotNull
    private final IntObjectMap<LayoutNode> layoutNodes;
    @NotNull
    private final RectList rects;
    @NotNull
    private final ThrottledCallbacks throttledCallbacks;
    @NotNull
    private final MutableObjectList<Function0<Unit>> callbacks;
    private boolean isDirty;
    private boolean isScreenOrWindowDirty;
    private boolean isFragmented;
    @Nullable
    private Object dispatchToken;
    private long scheduledDispatchDeadline;
    @NotNull
    private final Function0<Unit> dispatchLambda;
    @NotNull
    private final MutableRect cachedRect;
    public static final int $stable = 8;

    public RectManager(@NotNull IntObjectMap<LayoutNode> layoutNodes) {
        Intrinsics.checkNotNullParameter(layoutNodes, (String)"layoutNodes");
        this.layoutNodes = layoutNodes;
        this.rects = new RectList();
        this.throttledCallbacks = new ThrottledCallbacks();
        boolean $i$f$mutableObjectListOf = false;
        this.callbacks = new MutableObjectList(0, 1, null);
        this.scheduledDispatchDeadline = -1L;
        this.dispatchLambda = (Function0)new Function0<Unit>(this){
            final /* synthetic */ RectManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                RectManager.access$setDispatchToken$p(this.this$0, null);
                String string = "OnPositionedDispatch";
                RectManager rectManager = this.this$0;
                boolean $i$f$trace = false;
                boolean bl = false;
                rectManager.dispatchCallbacks();
            }
        };
        this.cachedRect = new MutableRect(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public /* synthetic */ RectManager(IntObjectMap intObjectMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            intObjectMap = IntObjectMapKt.intObjectMapOf();
        }
        this(intObjectMap);
    }

    @NotNull
    public final RectList getRects() {
        return this.rects;
    }

    public final void invalidate() {
        this.isDirty = true;
    }

    public final void updateOffsets-ucfNpQE(long screenOffset, long windowOffset, @NotNull float[] viewToWindowMatrix) {
        int analysis;
        Intrinsics.checkNotNullParameter((Object)viewToWindowMatrix, (String)"viewToWindowMatrix");
        int $this$hasNonTranslationComponents$iv = analysis = RectManagerKt.access$analyzeComponents-58bKbWc(viewToWindowMatrix);
        boolean $i$f$getHasNonTranslationComponents = false;
        this.isScreenOrWindowDirty = this.throttledCallbacks.updateOffsets-bT0EZQs(screenOffset, windowOffset, (float[])(($this$hasNonTranslationComponents$iv & 2) == 0 ? viewToWindowMatrix : null)) || this.isScreenOrWindowDirty;
    }

    /*
     * WARNING - void declaration
     */
    public final void dispatchCallbacks() {
        boolean isDispatchGlobalCallbacks;
        long currentTime = Actual_jvmKt.currentTimeMillis();
        boolean bl = isDispatchGlobalCallbacks = this.isDirty || this.isScreenOrWindowDirty;
        if (this.isDirty) {
            this.isDirty = false;
            Object this_$iv = this.callbacks;
            boolean $i$f$forEach = false;
            Object[] content$iv = ((ObjectList)this_$iv).content;
            int n = ((ObjectList)this_$iv)._size;
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                Function0 it = (Function0)content$iv[i$iv];
                boolean bl2 = false;
                it.invoke();
            }
            this_$iv = this.rects;
            boolean $i$f$forEachUpdatedRect = false;
            long[] items$iv = ((RectList)this_$iv).items;
            int size$iv = ((RectList)this_$iv).itemsSize;
            for (int i$iv = 0; i$iv < items$iv.length - 2 && i$iv < size$iv; i$iv += 3) {
                void bottomRight;
                void topLeft;
                long meta$iv = items$iv[i$iv + 2];
                boolean $i$f$unpackMetaUpdated = false;
                if (((int)(meta$iv >> 61) & 1) == 0) continue;
                long topLeft$iv = items$iv[i$iv + 0];
                long bottomRight$iv = items$iv[i$iv + 1];
                boolean $i$f$unpackMetaValue = false;
                long l = bottomRight$iv;
                long l2 = topLeft$iv;
                int id = (int)meta$iv & 0x3FFFFFF;
                boolean bl3 = false;
                this.throttledCallbacks.fireOnUpdatedRect(id, (long)topLeft, (long)bottomRight, currentTime);
            }
            this.rects.clearUpdated();
        }
        if (this.isScreenOrWindowDirty) {
            this.isScreenOrWindowDirty = false;
            this.throttledCallbacks.fireOnRectChangedEntries(currentTime);
        }
        if (isDispatchGlobalCallbacks) {
            this.throttledCallbacks.fireGlobalChangeEntries(currentTime);
        }
        if (this.isFragmented) {
            this.isFragmented = false;
            this.rects.defragment();
        }
        this.throttledCallbacks.triggerDebounced(currentTime);
    }

    public final void scheduleDebounceCallback(boolean ensureSomethingScheduled) {
        long deadline;
        boolean canExitEarly = !ensureSomethingScheduled || this.dispatchToken != null;
        long nextDeadline = this.throttledCallbacks.getMinDebounceDeadline();
        if (nextDeadline < 0L && canExitEarly) {
            return;
        }
        long currentScheduledDeadline = this.scheduledDispatchDeadline;
        if (currentScheduledDeadline == nextDeadline && canExitEarly) {
            return;
        }
        if (this.dispatchToken != null) {
            Actuals_skikoKt.removePost(this.dispatchToken);
        }
        long currentTime = Actual_jvmKt.currentTimeMillis();
        long nextFrameIsh = currentTime + (long)16;
        this.scheduledDispatchDeadline = deadline = Math.max(nextDeadline, nextFrameIsh);
        long delay = deadline - currentTime;
        this.dispatchToken = Actuals_skikoKt.postDelayed(delay, this.dispatchLambda);
    }

    @Nullable
    public final RelativeLayoutBounds currentRectInfo(int id, @NotNull DelegatableNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        this.rects.withRect(id, (Function4<? super Integer, ? super Integer, ? super Integer, ? super Integer, Unit>)((Function4)new Function4<Integer, Integer, Integer, Integer, Unit>((Ref.ObjectRef<RelativeLayoutBounds>)result2, node2, this){
            final /* synthetic */ Ref.ObjectRef<RelativeLayoutBounds> $result;
            final /* synthetic */ DelegatableNode $node;
            final /* synthetic */ RectManager this$0;
            {
                this.$result = $result;
                this.$node = $node;
                this.this$0 = $receiver;
                super(4);
            }

            public final void invoke(int l, int t, int r, int b) {
                boolean $i$f$packXY = false;
                $i$f$packXY = false;
                this.$result.element = ThrottledCallbacksKt.rectInfoFor-Q-MZNJw(this.$node, (long)l << 32 | (long)t & 0xFFFFFFFFL, (long)r << 32 | (long)b & 0xFFFFFFFFL, RectManager.access$getThrottledCallbacks$p(this.this$0).getWindowOffset-nOcc-ac(), RectManager.access$getThrottledCallbacks$p(this.this$0).getScreenOffset-nOcc-ac(), RectManager.access$getThrottledCallbacks$p(this.this$0).getViewToWindowMatrix-3i98HWw());
            }
        }));
        return (RelativeLayoutBounds)result2.element;
    }

    @Nullable
    public final Object registerOnChangedCallback(@NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.callbacks.add(callback);
        return callback;
    }

    @NotNull
    public final DelegatableNode.RegistrationHandle registerOnRectChangedCallback(int id, long throttleMillis, long debounceMillis, @NotNull DelegatableNode node2, @NotNull Function1<? super RelativeLayoutBounds, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        return this.throttledCallbacks.registerOnRectChanged(id, throttleMillis, debounceMillis, node2, callback);
    }

    @NotNull
    public final DelegatableNode.RegistrationHandle registerOnGlobalLayoutCallback(int id, long throttleMillis, long debounceMillis, @NotNull DelegatableNode node2, @NotNull Function1<? super RelativeLayoutBounds, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        return this.throttledCallbacks.registerOnGlobalChange(id, throttleMillis, debounceMillis, node2, callback);
    }

    public final void unregisterOnChangedCallback(@Nullable Object token) {
        if ((TypeIntrinsics.isFunctionOfArity((Object)token, (int)0) ? (Function0)token : null) == null) {
            return;
        }
        this.callbacks.remove((Function0<Unit>)token);
    }

    public final void invalidateCallbacksFor(@NotNull LayoutNode layoutNode2) {
        Intrinsics.checkNotNullParameter((Object)layoutNode2, (String)"layoutNode");
        this.isDirty = true;
        this.rects.markUpdated(layoutNode2.getSemanticsId());
        this.scheduleDebounceCallback(true);
    }

    public final void onLayoutLayerPositionalPropertiesChanged(@NotNull LayoutNode layoutNode2) {
        Intrinsics.checkNotNullParameter((Object)layoutNode2, (String)"layoutNode");
        if (!ComposeUiFlags.isRectTrackingEnabled) {
            return;
        }
        long outerToInnerOffset = this.outerToInnerOffset-Bjo55l4(layoutNode2);
        if (RectManagerKt.access$isSet--gyyYBs(outerToInnerOffset)) {
            layoutNode2.setOuterToInnerOffset--gyyYBs$ui(outerToInnerOffset);
            layoutNode2.setOuterToInnerOffsetDirty$ui(false);
            LayoutNode this_$iv = layoutNode2;
            boolean $i$f$forEachChild = false;
            MutableVector<LayoutNode> this_$iv$iv = this_$iv.get_children$ui();
            boolean $i$f$forEach = false;
            T[] content$iv$iv = this_$iv$iv.content;
            int size$iv$iv = this_$iv$iv.getSize();
            for (int i$iv$iv = 0; i$iv$iv < size$iv$iv; ++i$iv$iv) {
                LayoutNode it = (LayoutNode)content$iv$iv[i$iv$iv];
                boolean bl = false;
                this.onLayoutPositionChanged-70tqf50(it, it.getOuterCoordinator$ui().getPosition-nOcc-ac(), false);
            }
            this.invalidateCallbacksFor(layoutNode2);
        } else {
            this.insertOrUpdateTransformedNodeSubhierarchy(layoutNode2);
        }
    }

    public final void onLayoutPositionChanged-70tqf50(@NotNull LayoutNode layoutNode2, long position, boolean firstPlacement) {
        Intrinsics.checkNotNullParameter((Object)layoutNode2, (String)"layoutNode");
        if (!ComposeUiFlags.isRectTrackingEnabled) {
            return;
        }
        MeasurePassDelegate delegate = layoutNode2.getMeasurePassDelegate$ui();
        int width2 = delegate.getMeasuredWidth();
        int height2 = delegate.getMeasuredHeight();
        LayoutNode parent = layoutNode2.getParent$ui();
        long offset2 = 0L;
        long lastOffset = layoutNode2.getOffsetFromRoot-nOcc-ac$ui();
        long lastSize = layoutNode2.getLastSize-YbymL2g$ui();
        boolean bl = false;
        long value$iv$iv = lastSize;
        boolean $i$f$unpackInt1 = false;
        int lastWidth = (int)(value$iv$iv >> 32);
        boolean bl2 = false;
        long value$iv$iv2 = lastSize;
        boolean $i$f$unpackInt2 = false;
        int lastHeight = (int)(value$iv$iv2 & 0xFFFFFFFFL);
        boolean hasNonTranslationTransformations = false;
        if (parent != null) {
            long l;
            boolean parentOffsetDirty = parent.getOuterToInnerOffsetDirty$ui();
            long parentOffset = parent.getOffsetFromRoot-nOcc-ac$ui();
            long prevOuterToInnerOffset = parent.getOuterToInnerOffset-nOcc-ac$ui();
            if (RectManagerKt.access$isSet--gyyYBs(parentOffset)) {
                long l2;
                if (parentOffsetDirty) {
                    long it = this.outerToInnerOffset-Bjo55l4(parent);
                    parent.setOuterToInnerOffset--gyyYBs$ui(it);
                    parent.setOuterToInnerOffsetDirty$ui(false);
                    l2 = it;
                } else {
                    l2 = prevOuterToInnerOffset;
                }
                long parentOuterInnerOffset = l2;
                hasNonTranslationTransformations = !RectManagerKt.access$isSet--gyyYBs(parentOuterInnerOffset);
                l = IntOffset.plus-qkQi6aY(IntOffset.plus-qkQi6aY(parentOffset, parentOuterInnerOffset), position);
            } else {
                l = this.positionInRoot-Bjo55l4(layoutNode2.getOuterCoordinator$ui());
            }
            offset2 = l;
        } else {
            offset2 = position;
        }
        if (hasNonTranslationTransformations || !RectManagerKt.access$isSet--gyyYBs(offset2)) {
            this.insertOrUpdateTransformedNode-70tqf50(layoutNode2, position, firstPlacement);
            return;
        }
        layoutNode2.setOffsetFromRoot--gyyYBs$ui(offset2);
        boolean $i$f$IntSize = false;
        boolean $i$f$packInts = false;
        layoutNode2.setLastSize-ozmzZPI$ui(IntSize.constructor-impl((long)width2 << 32 | (long)height2 & 0xFFFFFFFFL));
        int l = IntOffset.getX-impl(offset2);
        int t = IntOffset.getY-impl(offset2);
        int r = l + width2;
        int b = t + height2;
        if (!firstPlacement && IntOffset.equals-impl0(offset2, lastOffset) && lastWidth == width2 && lastHeight == height2) {
            return;
        }
        this.insertOrUpdate(layoutNode2, firstPlacement, l, t, r, b);
    }

    private final void insertOrUpdateTransformedNodeSubhierarchy(LayoutNode layoutNode2) {
        LayoutNode this_$iv = layoutNode2;
        boolean $i$f$forEachChild = false;
        MutableVector<LayoutNode> this_$iv$iv = this_$iv.get_children$ui();
        boolean $i$f$forEach = false;
        T[] content$iv$iv = this_$iv$iv.content;
        int size$iv$iv = this_$iv$iv.getSize();
        for (int i$iv$iv = 0; i$iv$iv < size$iv$iv; ++i$iv$iv) {
            LayoutNode it = (LayoutNode)content$iv$iv[i$iv$iv];
            boolean bl = false;
            this.insertOrUpdateTransformedNode-70tqf50(it, it.getOuterCoordinator$ui().getPosition-nOcc-ac(), false);
            this.insertOrUpdateTransformedNodeSubhierarchy(it);
        }
    }

    private final void insertOrUpdateTransformedNode-70tqf50(LayoutNode layoutNode2, long position, boolean firstPlacement) {
        NodeCoordinator coord = layoutNode2.getOuterCoordinator$ui();
        MeasurePassDelegate delegate = layoutNode2.getMeasurePassDelegate$ui();
        int width2 = delegate.getMeasuredWidth();
        int height2 = delegate.getMeasuredHeight();
        MutableRect rect = this.cachedRect;
        rect.set(IntOffset.getX-impl(position), IntOffset.getY-impl(position), IntOffset.getX-impl(position) + width2, IntOffset.getY-impl(position) + height2);
        this.boundingRectInRoot(coord, rect);
        int l = (int)rect.getLeft();
        int t = (int)rect.getTop();
        int r = (int)rect.getRight();
        int b = (int)rect.getBottom();
        int id = layoutNode2.getSemanticsId();
        if (firstPlacement || !this.rects.update(id, l, t, r, b)) {
            LayoutNode layoutNode3 = layoutNode2.getParent$ui();
            int parentId = layoutNode3 != null ? layoutNode3.getSemanticsId() : -1;
            RectList.insert$default(this.rects, id, l, t, r, b, parentId, false, false, 192, null);
        }
        this.invalidate();
    }

    private final void insertOrUpdate(LayoutNode layoutNode2, boolean firstPlacement, int l, int t, int r, int b) {
        int id = layoutNode2.getSemanticsId();
        if (firstPlacement || !this.rects.move(id, l, t, r, b)) {
            LayoutNode layoutNode3 = layoutNode2.getParent$ui();
            int parentId = layoutNode3 != null ? layoutNode3.getSemanticsId() : -1;
            RectList.insert$default(this.rects, id, l, t, r, b, parentId, false, false, 192, null);
        }
        this.invalidate();
    }

    private final long positionInRoot-Bjo55l4(NodeCoordinator $this$positionInRoot_u2dBjo55l4) {
        long position = Offset.Companion.getZero-F1C5BW0();
        for (NodeCoordinator coordinator = $this$positionInRoot_u2dBjo55l4; coordinator != null; coordinator = coordinator.getWrappedBy$ui()) {
            boolean hasNonTranslationComponents;
            float[] matrix;
            int analysis;
            OwnedLayer layer = coordinator.getLayer();
            position = IntOffsetKt.plus-Nv-tHpc(position, coordinator.getPosition-nOcc-ac());
            if (layer == null || (analysis = RectManagerKt.access$analyzeComponents-58bKbWc(matrix = layer.getUnderlyingMatrix-sQKQjiQ())) == 3) continue;
            boolean bl = hasNonTranslationComponents = (analysis & 2) == 0;
            if (hasNonTranslationComponents) {
                return IntOffset.Companion.getMax-nOcc-ac();
            }
            position = Matrix.map-MK-Hz9U(matrix, position);
        }
        return IntOffsetKt.round-k-4lQ0M(position);
    }

    /*
     * WARNING - void declaration
     */
    private final void boundingRectInRoot(NodeCoordinator $this$boundingRectInRoot, MutableRect rect) {
        for (NodeCoordinator coordinator = $this$boundingRectInRoot; coordinator != null; coordinator = coordinator.getWrappedBy$ui()) {
            float[] matrix;
            void x$iv$iv;
            OwnedLayer layer = coordinator.getLayer();
            long $this$toOffset_u2d_u2dgyyYBs$iv = coordinator.getPosition-nOcc-ac();
            boolean bl = false;
            float f = IntOffset.getX-impl($this$toOffset_u2d_u2dgyyYBs$iv);
            float y$iv$iv = IntOffset.getY-impl($this$toOffset_u2d_u2dgyyYBs$iv);
            boolean $i$f$Offset = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv$iv = Float.floatToRawIntBits((float)x$iv$iv);
            long v2$iv$iv$iv = Float.floatToRawIntBits(y$iv$iv);
            rect.translate-k-4lQ0M(Offset.constructor-impl(v1$iv$iv$iv << 32 | v2$iv$iv$iv & 0xFFFFFFFFL));
            if (layer == null || MatrixKt.isIdentity-58bKbWc(matrix = layer.getUnderlyingMatrix-sQKQjiQ())) continue;
            Matrix.map-impl(matrix, rect);
        }
    }

    private final long outerToInnerOffset-Bjo55l4(LayoutNode $this$outerToInnerOffset_u2dBjo55l4) {
        NodeCoordinator terminator = $this$outerToInnerOffset_u2dBjo55l4.getOuterCoordinator$ui();
        long position = Offset.Companion.getZero-F1C5BW0();
        for (NodeCoordinator coordinator = $this$outerToInnerOffset_u2dBjo55l4.getInnerCoordinator$ui(); coordinator != null && coordinator != terminator; coordinator = coordinator.getWrappedBy$ui()) {
            int analysis;
            OwnedLayer layer = coordinator.getLayer();
            position = IntOffsetKt.plus-Nv-tHpc(position, coordinator.getPosition-nOcc-ac());
            if (layer == null) continue;
            float[] matrix = layer.getUnderlyingMatrix-sQKQjiQ();
            int $this$isIdentity$iv = analysis = RectManagerKt.access$analyzeComponents-58bKbWc(matrix);
            boolean $i$f$isIdentity = false;
            if ($this$isIdentity$iv == 3) continue;
            int $this$hasNonTranslationComponents$iv = analysis;
            boolean $i$f$getHasNonTranslationComponents = false;
            if (($this$hasNonTranslationComponents$iv & 2) == 0) {
                return IntOffset.Companion.getMax-nOcc-ac();
            }
            position = Matrix.map-MK-Hz9U(matrix, position);
        }
        return IntOffsetKt.round-k-4lQ0M(position);
    }

    public final void remove(@NotNull LayoutNode layoutNode2) {
        Intrinsics.checkNotNullParameter((Object)layoutNode2, (String)"layoutNode");
        this.rects.remove(layoutNode2.getSemanticsId());
        this.invalidate();
        this.isFragmented = true;
    }

    public final boolean isTargetDrawnFirst$ui(int targetId, int otherId) {
        LayoutNode layoutNode2 = this.layoutNodes.get(targetId);
        if (layoutNode2 == null) {
            return false;
        }
        LayoutNode nodeA = layoutNode2;
        LayoutNode layoutNode3 = this.layoutNodes.get(otherId);
        if (layoutNode3 == null) {
            return false;
        }
        LayoutNode nodeB = layoutNode3;
        if (nodeA.getDepth$ui() == 0 || nodeB.getDepth$ui() == 0) {
            return false;
        }
        while (nodeA.getDepth$ui() > nodeB.getDepth$ui()) {
            if (nodeA.getParent$ui() != null) continue;
            return false;
        }
        if (nodeA == nodeB) {
            return false;
        }
        while (nodeB.getDepth$ui() > nodeA.getDepth$ui()) {
            if (nodeB.getParent$ui() != null) continue;
            return false;
        }
        if (nodeA == nodeB) {
            return false;
        }
        LayoutNode lastParentA = nodeA;
        LayoutNode lastParentB = nodeB;
        while (nodeA != nodeB) {
            lastParentA = nodeA;
            lastParentB = nodeB;
            if (nodeA.getParent$ui() == null) {
                return false;
            }
            if (nodeB.getParent$ui() != null) continue;
            return false;
        }
        if (lastParentA.getMeasurePassDelegate$ui().getZIndex$ui() == lastParentB.getMeasurePassDelegate$ui().getZIndex$ui()) {
            return lastParentA.getPlaceOrder$ui() < lastParentB.getPlaceOrder$ui();
        }
        return lastParentA.getMeasurePassDelegate$ui().getZIndex$ui() < lastParentB.getMeasurePassDelegate$ui().getZIndex$ui();
    }

    public RectManager() {
        this(null, 1, null);
    }

    public static final /* synthetic */ ThrottledCallbacks access$getThrottledCallbacks$p(RectManager $this) {
        return $this.throttledCallbacks;
    }

    public static final /* synthetic */ void access$setDispatchToken$p(RectManager $this, Object object) {
        $this.dispatchToken = object;
    }
}

