/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.comms.common.netty.util;

import io.netty.util.concurrent.FastThreadLocalThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/station/comms/common/netty/util/NettyThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "namePrefix", "", "outerCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "<init>", "(Ljava/lang/String;Ljava/util/concurrent/atomic/AtomicInteger;)V", "getNamePrefix", "()Ljava/lang/String;", "innerCounter", "newThread", "Ljava/lang/Thread;", "r", "Ljava/lang/Runnable;", "intellij.station.comms.common"})
public final class NettyThreadFactory
implements ThreadFactory {
    @NotNull
    private final String namePrefix;
    @NotNull
    private final AtomicInteger innerCounter;

    public NettyThreadFactory(@NotNull String namePrefix, @NotNull AtomicInteger outerCounter) {
        Intrinsics.checkNotNullParameter((Object)namePrefix, (String)"namePrefix");
        Intrinsics.checkNotNullParameter((Object)outerCounter, (String)"outerCounter");
        this.namePrefix = namePrefix + " " + outerCounter.incrementAndGet() + "-";
        this.innerCounter = new AtomicInteger();
    }

    @NotNull
    public final String getNamePrefix() {
        return this.namePrefix;
    }

    @Override
    @Nullable
    public Thread newThread(@NotNull Runnable r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return (Thread)new FastThreadLocalThread(r, this.namePrefix + this.innerCounter.incrementAndGet());
    }
}

