/*
* Copyright 2018 - Present Okta, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
 */

// Code generated by okta openapi generator. DO NOT EDIT.

package okta

import (
	"context"
	"fmt"
)

type GroupSchemaResource resource

type GroupSchema struct {
	Schema      string                  `json:"$schema,omitempty"`
	Links       interface{}             `json:"_links,omitempty"`
	Created     string                  `json:"created,omitempty"`
	Definitions *GroupSchemaDefinitions `json:"definitions,omitempty"`
	Description string                  `json:"description,omitempty"`
	Id          string                  `json:"id,omitempty"`
	LastUpdated string                  `json:"lastUpdated,omitempty"`
	Name        string                  `json:"name,omitempty"`
	Properties  *UserSchemaProperties   `json:"properties,omitempty"`
	Title       string                  `json:"title,omitempty"`
	Type        string                  `json:"type,omitempty"`
}

// Fetches the group schema
func (m *GroupSchemaResource) GetGroupSchema(ctx context.Context) (*GroupSchema, *Response, error) {
	url := fmt.Sprintf("/api/v1/meta/schemas/group/default")

	rq := m.client.CloneRequestExecutor()

	req, err := rq.WithAccept("application/json").WithContentType("application/json").NewRequest("GET", url, nil)
	if err != nil {
		return nil, nil, err
	}

	var groupSchema *GroupSchema

	resp, err := rq.Do(ctx, req, &groupSchema)
	if err != nil {
		return nil, resp, err
	}

	return groupSchema, resp, nil
}

// Updates, adds ore removes one or more custom Group Profile properties in the schema
func (m *GroupSchemaResource) UpdateGroupSchema(ctx context.Context, body GroupSchema) (*GroupSchema, *Response, error) {
	url := fmt.Sprintf("/api/v1/meta/schemas/group/default")

	rq := m.client.CloneRequestExecutor()

	req, err := rq.WithAccept("application/json").WithContentType("application/json").NewRequest("POST", url, body)
	if err != nil {
		return nil, nil, err
	}

	var groupSchema *GroupSchema

	resp, err := rq.Do(ctx, req, &groupSchema)
	if err != nil {
		return nil, resp, err
	}

	return groupSchema, resp, nil
}
