package main

import (
	"log"
	"os"

	"github.com/get-woke/woke/cmd"

	"github.com/spf13/cobra/doc"
)

func main() {
	if len(os.Args) < 2 {
		log.Fatalln("Output directory required! run `go run main.go <output_directory>` to output to `<output_directory>/woke.md`")
	}

	rootCmd := cmd.GetRootCmd()
	outputDir := os.Args[1]
	identity := func(s string) string { return s }
	filePrepender := func(_ string) string {
		return "<!-- markdownlint-disable -->\n<!-- This page is autogenerated by cmd/docs/main.go. DO NOT EDIT! -->\n\n"
	}

	if err := doc.GenMarkdownTreeCustom(&rootCmd, outputDir, filePrepender, identity); err != nil {
		log.Fatal(err)
	}
}
