/*
 * Decompiled with CFR 0.152.
 */
package com.pegacat.testprovider;

import com.pegacat.testprovider.TreeEntry;
import java.util.ArrayList;
import java.util.HashMap;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.ldap.LdapName;

public class DataTree
extends HashMap<String, TreeEntry> {
    public TreeEntry get(String key) {
        return (TreeEntry)super.get(key);
    }

    public void addEntry(TreeEntry newEntry) {
        String stringEntryName;
        Name entryName = newEntry.getName();
        Name parentName = null;
        String parentNameS = null;
        if (entryName.size() > 0) {
            parentName = entryName.getPrefix(entryName.size() - 1);
            parentNameS = parentName.toString();
        }
        if (this.containsKey(stringEntryName = entryName.toString())) {
            TreeEntry placeHolder = this.get(stringEntryName);
            newEntry.children = (ArrayList)placeHolder.children.clone();
            TreeEntry parent = this.get(parentNameS);
            if (parent != null) {
                parent.replaceChild(placeHolder, newEntry);
            }
        } else if (parentName != null) {
            if (this.containsKey(parentNameS)) {
                this.get(parentNameS).addChild(newEntry);
            } else {
                TreeEntry placeHolder = new TreeEntry(parentName, new String[]{"objectclass", "placeHolder"});
                placeHolder.addChild(newEntry);
                this.addEntry(placeHolder);
            }
        }
        this.put(entryName.toString(), newEntry);
    }

    public void deleteEntry(String name) {
        TreeEntry deleteMe = this.get(name);
        this.deleteEntry(deleteMe);
    }

    public void deleteEntry(TreeEntry deleteMe) {
        if (deleteMe != null) {
            int size;
            for (int i = size = deleteMe.children.size(); i > 0; --i) {
                this.deleteEntry(deleteMe.children.get(i - 1));
            }
            if (!deleteMe.getName().isEmpty()) {
                TreeEntry parent = this.get(deleteMe.getParent().toString());
                parent.removeChild(deleteMe);
            }
            this.remove(deleteMe.getName().toString());
        }
    }

    public void renameEntry(String oldName, String newName) throws NamingException {
        TreeEntry entry = this.get(oldName);
        entry.setName(new LdapName(newName));
        this.remove(oldName);
        this.put(newName, entry);
    }

    public void dump() {
        this.dumpEntry(this.get(""), 0);
    }

    public void dumpEntry(TreeEntry entry, int indent) {
        for (int i = 0; i < indent * 4; ++i) {
            System.out.print(" ");
        }
        if (entry.getStringName().length() == 0) {
            System.out.println("<root>");
        } else {
            System.out.println(entry.getStringName());
        }
        ++indent;
        for (TreeEntry child : entry.getChildren()) {
            this.dumpEntry(child, indent);
        }
    }
}

