/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.asn1;

import com.ca.commons.security.asn1.ASN1Object;
import com.ca.commons.security.asn1.ASN1Type;
import java.io.Serializable;

public class Sequence
extends ASN1Object
implements Serializable {
    private ASN1Object[] component;
    private int count;
    private static int initSize = 2;

    @Override
    public void init(ASN1Type type) {
        this.asn1Type = type;
        this.byteArray = null;
        this.count = 0;
        this.component = new ASN1Object[initSize];
    }

    @Override
    public void addComponent(ASN1Object comp) {
        this.addComponent(comp, this.count);
    }

    @Override
    public void addComponent(ASN1Object comp, int index) {
        if (index > this.count) {
            throw new IllegalArgumentException("illegal component index");
        }
        if (this.component.length <= this.count) {
            ASN1Object[] oldComponent = this.component;
            this.component = new ASN1Object[this.component.length + 2];
            System.arraycopy(oldComponent, 0, this.component, 0, oldComponent.length);
        }
        if (index < this.count) {
            System.arraycopy(this.component, index, this.component, index + 1, this.count - index);
        }
        this.component[index] = comp;
        ++this.count;
    }

    public void removeComponent(ASN1Object comp, int index) {
    }

    @Override
    public ASN1Object getComponent(int index) {
        if (index > this.count) {
            throw new IllegalArgumentException("illegal component index");
        }
        return this.component[index];
    }

    public void setComponent(ASN1Object comp, int index) {
        if (index > this.count) {
            throw new IllegalArgumentException("illegal component index");
        }
        this.component[index] = comp;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public String toString() {
        String result = super.toString();
        for (int i = 0; i < this.count; ++i) {
            result = result + "\n\t[" + i + "]" + this.component[i].toString();
        }
        return result;
    }
}

