/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.cert.extensions;

import com.ca.commons.security.asn1.ASN1Object;
import com.ca.commons.security.asn1.ASN1Type;
import com.ca.commons.security.cert.extensions.V3Extension;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PrivateKeyUsagePeriod
implements V3Extension {
    String value = null;

    @Override
    public void init(ASN1Object asn1object) throws Exception {
        if (!asn1object.isASN1Type(ASN1Type.SEQUENCE)) {
            throw new Exception("Wrong ASN.1 type for PrivateKeyUsagePeriod");
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        SimpleDateFormat printer = new SimpleDateFormat("MMM d, yyyy    h:mm:ss a");
        Object dateString = null;
        for (int i = 0; i < asn1object.size(); ++i) {
            Date hotdate;
            ASN1Object nextComp = (ASN1Object)asn1object.getComponent(i).getValue();
            if (nextComp.isASN1Type(ASN1Type.OCTET_STRING) && i == 0) {
                String notBefore = new String((byte[])nextComp.getValue());
                try {
                    hotdate = formatter.parse(notBefore);
                    this.value = "Not Before: " + printer.format(hotdate);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.value = "Not Before: invalid date";
                }
                continue;
            }
            if (!nextComp.isASN1Type(ASN1Type.OCTET_STRING) || i != 1) continue;
            String notAfter = new String((byte[])nextComp.getValue());
            try {
                hotdate = formatter.parse(notAfter);
                this.value = this.value + "\nNot After: " + printer.format(hotdate);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.value = this.value + "\nNot After: invalid date";
            }
        }
    }

    public String toString() {
        return this.value;
    }
}

