/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.ASTParser;
import com.github.javaparser.CommentsInserter;
import com.github.javaparser.ParseContext;
import com.github.javaparser.ParseException;
import com.github.javaparser.ParseProblemException;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.Problem;
import com.github.javaparser.Provider;
import com.github.javaparser.Providers;
import com.github.javaparser.Range;
import com.github.javaparser.Token;
import com.github.javaparser.TokenMgrException;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.utils.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public final class JavaParser {
    private final CommentsInserter commentsInserter;
    private ASTParser astParser = null;

    public JavaParser(ParserConfiguration configuration) {
        this.commentsInserter = new CommentsInserter(configuration);
    }

    private ASTParser getParserForProvider(Provider provider) {
        if (this.astParser == null) {
            this.astParser = new ASTParser(provider);
        } else {
            this.astParser.ReInit(provider);
        }
        return this.astParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <N> ParseResult<N> parseStructure(ParseContext<N> context, Provider provider) {
        ASTParser parser = this.getParserForProvider(provider);
        try {
            N resultNode = context.parse(parser);
            ParseResult<N> parseResult = new ParseResult<N>(Optional.of(resultNode), parser.problems, this.astParser.getTokens());
            return parseResult;
        }
        catch (ParseException e) {
            ParseResult parseResult = new ParseResult(Optional.empty(), Collections.singletonList(new Problem(e.getMessage(), ASTParser.tokenRange(e.currentToken))), new LinkedList<Token>());
            return parseResult;
        }
        catch (TokenMgrException e) {
            ParseResult parseResult = new ParseResult(Optional.empty(), Collections.singletonList(new Problem(e.getMessage(), Range.UNKNOWN)), new LinkedList<Token>());
            return parseResult;
        }
        finally {
            try {
                provider.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Loose catch block
     */
    public ParseResult<CompilationUnit> parseFull(Provider provider) {
        try {
            String sourceCode = Utils.providerToString(provider);
            ASTParser parser = this.getParserForProvider(Providers.provider(sourceCode));
            CompilationUnit resultNode = ParseContext.COMPILATION_UNIT.parse(parser);
            this.commentsInserter.insertComments(resultNode, sourceCode);
            ParseResult<CompilationUnit> parseResult = new ParseResult<CompilationUnit>(Optional.of(resultNode), parser.problems, this.astParser.getTokens());
            return parseResult;
        }
        catch (ParseException e) {
            ParseResult<CompilationUnit> parseResult = new ParseResult<CompilationUnit>(Optional.empty(), Collections.singletonList(new Problem(e.getMessage(), ASTParser.tokenRange(e.currentToken))), new LinkedList<Token>());
            return parseResult;
        }
        catch (TokenMgrException e) {
            ParseResult<CompilationUnit> parseResult = new ParseResult<CompilationUnit>(Optional.empty(), Collections.singletonList(new Problem(e.getMessage(), Range.UNKNOWN)), new LinkedList<Token>());
            return parseResult;
        }
        catch (IOException e2) {
            throw new AssertionError((Object)"Unreachable code");
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                provider.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static CompilationUnit parse(InputStream in, Charset encoding) {
        return JavaParser.parse(in, encoding, true);
    }

    public static CompilationUnit parse(InputStream in, Charset encoding, boolean considerComments) {
        return JavaParser.simplifiedParse(Providers.provider(in, encoding), considerComments);
    }

    public static CompilationUnit parse(InputStream in) {
        return JavaParser.parse(in, Providers.UTF8, true);
    }

    public static CompilationUnit parse(File file, Charset encoding) throws FileNotFoundException {
        return JavaParser.simplifiedParse(Providers.provider(file, encoding), true);
    }

    public static CompilationUnit parse(File file, Charset encoding, boolean considerComments) throws FileNotFoundException {
        return JavaParser.simplifiedParse(Providers.provider(file, encoding), considerComments);
    }

    public static CompilationUnit parse(File file) throws FileNotFoundException {
        return JavaParser.simplifiedParse(Providers.provider(file), true);
    }

    public static CompilationUnit parse(Path path, Charset encoding) throws IOException {
        return JavaParser.simplifiedParse(Providers.provider(path, encoding), true);
    }

    public static CompilationUnit parse(Path path, Charset encoding, boolean considerComments) throws IOException {
        return JavaParser.simplifiedParse(Providers.provider(path, encoding), considerComments);
    }

    public static CompilationUnit parse(Path path) throws IOException {
        return JavaParser.simplifiedParse(Providers.provider(path), true);
    }

    public static CompilationUnit parse(Reader reader) {
        return JavaParser.parse(reader, true);
    }

    public static CompilationUnit parse(Reader reader, boolean considerComments) {
        return JavaParser.simplifiedParse(Providers.provider(reader), considerComments);
    }

    public static CompilationUnit parse(String code, boolean considerComments) {
        return JavaParser.simplifiedParse(Providers.provider(code), considerComments);
    }

    public static CompilationUnit parse(String code) {
        return JavaParser.parse(code, true);
    }

    public static BlockStmt parseBlock(String blockStatement) {
        return JavaParser.simplifiedParse(ParseContext.BLOCK, Providers.provider(blockStatement));
    }

    public static Statement parseStatement(String statement) {
        return JavaParser.simplifiedParse(ParseContext.STATEMENT, Providers.provider(statement));
    }

    private static <T> T simplifiedParse(ParseContext<T> context, Provider provider) {
        ParseResult<T> result = new JavaParser(new ParserConfiguration()).parseStructure(context, provider);
        if (result.isSuccessful()) {
            return result.result.get();
        }
        throw new ParseProblemException(result.problems);
    }

    private static CompilationUnit simplifiedParse(Provider provider, boolean considerComments) {
        ParseResult<CompilationUnit> result = considerComments ? new JavaParser(new ParserConfiguration()).parseFull(provider) : new JavaParser(new ParserConfiguration()).parseStructure(ParseContext.COMPILATION_UNIT, provider);
        if (result.isSuccessful()) {
            return (CompilationUnit)result.result.get();
        }
        throw new ParseProblemException(result.problems);
    }

    public static List<Statement> parseStatements(String statements) {
        return JavaParser.simplifiedParse(ParseContext.STATEMENTS, Providers.provider(statements));
    }

    public static ImportDeclaration parseImport(String importDeclaration) {
        return JavaParser.simplifiedParse(ParseContext.IMPORT_DECLARATION, Providers.provider(importDeclaration));
    }

    public static Expression parseExpression(String expression) {
        return JavaParser.simplifiedParse(ParseContext.EXPRESSION, Providers.provider(expression));
    }

    public static AnnotationExpr parseAnnotation(String annotation) {
        return JavaParser.simplifiedParse(ParseContext.ANNOTATION, Providers.provider(annotation));
    }

    public static BodyDeclaration<?> parseAnnotationBodyDeclaration(String body) {
        return JavaParser.simplifiedParse(ParseContext.ANNOTATION_BODY, Providers.provider(body));
    }

    public static BodyDeclaration<?> parseClassBodyDeclaration(String body) {
        return JavaParser.simplifiedParse(ParseContext.CLASS_BODY, Providers.provider(body));
    }

    public static BodyDeclaration parseInterfaceBodyDeclaration(String body) {
        return JavaParser.simplifiedParse(ParseContext.INTERFACE_BODY, Providers.provider(body));
    }
}

