/***************************************************************************
 *                                                                         *
 *                                                                         *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CODONPEDERSEN98_H
#define CODONPEDERSEN98_H

#include "codonyn98.h"

/**
@author Bui Quang Minh
*/
class CodonPedersen98 : public CodonYN98
{
public:
    CodonPedersen98();

	/**
		calculate the rate parameters (not rate matrix)
	*/
	virtual void calcRateParameters();

	/**
		compute negative log likelihood
	*/
	virtual double cmpNegLogLi (double value);
	
	/**
		optimize parameters
	*/
	virtual bool optPam ();	

	/**
		@return Nonsynonymous/Synonymous Ratio
	*/
	double getCpG_Ratio();

	
	/**
		get the rate parameters and frequency vector
	*/	
	//virtual void rtfdata (DMat20 &a, DVec20 &forg, int num_state);
	
    ~CodonPedersen98();

	
	
protected:
	double CpG_Ratio;
	
};

#endif
