/***************************************************************************
 *                                                                         *
 *                  (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


/***************************************************************************
                          librarr.cpp  -  description
                             -------------------
    begin                : Thu Apr 24 2003
    copyright            : (C) 2003 by 
    email                : vinh@cs.uni-duesseldorf.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <iostream>
#include "librarr.h"

//Vec<LiBr> LiBrArr::items_;

//the constructor function
LiBrArr::LiBrArr () {
	maxNBr_ = 0;
	curNBr_ = 0;
}

//--------------------------------------------------------
//all things are inited here
void LiBrArr::init () {}

//--------------------------------------------------------
//return maximum number of branches in this class
int LiBrArr::getMaxNBr () {
	return maxNBr_;
}

//--------------------------------------------------------
//copy all information of brArr into this liBrArr
void LiBrArr:: copyBase (BrArr<double> &brArr) {
	maxNBr_ = brArr.getMaxNBr ();
	curNBr_ = brArr.getCurNBr ();
	items_.set (maxNBr_, maxNBr_);
	for (int count_ = 0; count_ < maxNBr_; count_ ++)
		if (brArr[count_].getId () != -1) {
			items_[count_].setLimit ();
			items_[count_].copyBase (brArr[count_]);
		} else
			items_[count_].setId (-1);
}

//--------------------------------------------------------------------
//return the in nd of number ndNo
LiBr &LiBrArr::operator[] (const int index) {
	if (index < 0) {
		items_.printVecInfo(index, "error in LiBrArr[]");
		Utl::announceError (BAD_MEMORY_ACCESS);
	}
	return items_[index];
}

//--------------------------------------------------------
//return the current number of current liBrs of this array
int LiBrArr::getCurNBr () {
	return curNBr_;
}


//--------------------------------------------------------------------
//release the memory of this class
void LiBrArr::release () {
	int realLimit_ = items_.getLimit ();
	items_.setSize (realLimit_);
	for (int count_ = 0; count_ < realLimit_; count_ ++)
		items_[count_].release ();
	items_.release ();
}

//--------------------------------------------------------
//the destructor function
LiBrArr::~LiBrArr () {
	release ();
	//  std::cout << "this is destructor function of class LiBrArr " << endl;
}
