/***************************************************************************
 *                                                                         *
 *                  (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

// Ptn.cpp: implementation of the Ptn class.
//
//////////////////////////////////////////////////////////////////////
#include <iostream>
#include "constant.h"
#include "ptn.h"


//the constructor function
Ptn::Ptn () {
	clean ();
	is_const = false;
}

//clean all remember flags of this class
void Ptn::clean () {}

//--------------------------------------------------------------------
//set the siteNo for this ptn
void Ptn::setSite (const int siteNo) {
	siteNo_ = siteNo;
}

//--------------------------------------------------------------------
//set limit for this ptn. Thus, set the maximum number of nucleotides or amino acids of this pattern
void Ptn::setLimit (const int limit) {
	items_.setLimit (limit);
}

//--------------------------------------------------------------------
//set the exact number of nucleotides or amino acids of this pattern
void Ptn::setSize (const int limit) {
	items_.set (limit, limit);
}

//--------------------------------------------------------------------
//get the siteNo of this ptn
int Ptn::getSite () {
	return siteNo_;
}

//--------------------------------------------------------------------
//set the content of this ptn
void Ptn::set (Vec<char> &items) {
	items_ = items;
}

//--------------------------------------------------------------------
//set the number of sites which have the same ptn to this one
void Ptn::setWeight (const int weight) {
	weight_ = weight;
}

//--------------------------------------------------------------------
//get the number of sites which have the same ptn to this one
int Ptn::getWeight () {
	return weight_;
}

//--------------------------------------------------------------------
//get the content of this ptn.
Vec<char> &Ptn::getItem () {
	return items_;
}

//--------------------------------------------------------------------
//return items_[index]
char Ptn::getItem (const int index) {
	return items_[index];
}

//--------------------------------------------------------------------
//return items_[index]

char &Ptn::operator [] (const int index) {
	return items_[index];
}

//--------------------------------------------------------------------
//overload == operator
int Ptn::operator == (Ptn &ptn) {
	for (int seqNo_ = 0; seqNo_ < items_.getSize (); seqNo_++)
		if (this->items_[seqNo_] != ptn[seqNo_] )
			return 0;
	return 1;
}

//--------------------------------------------------------------------
//overload += operator, weight = weight + incWeight
void Ptn::operator += (char base) {
	items_ += base;
}

//--------------------------------------------------------------------
//weight_ = weight_ + increment
void Ptn::addWeight (const int incWeight) {
	weight_ += incWeight;
}

//--------------------------------------------------------------------
//overload operator =
void Ptn::operator = (Ptn &ptn) {
	this->siteNo_ = ptn.getSite ();
	this->weight_ = ptn.getWeight ();
	this->items_ = ptn.getItem ();
}

void Ptn::computeConst() {
	int size = items_.getSize();
	char ch = items_[0];
	is_const = true;
	for (int i = 1; i < size; i++)
		if (items_[i] != ch) {
			is_const = false;
			return;
		}
}

//--------------------------------------------------------------------
//release all meory of this class
void Ptn::release () {
	items_.release ();
}

//--------------------------------------------------------------------
//the destructor function
Ptn::~Ptn () {
	release ();
	//  std::cout << "the destructor of Ptn class " << endl;
}
