/***************************************************************************
 *                                                                         *
 *                  (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef TESTMETHOD_H
#define TESTMETHOD_H

#include "constant.h"
#include "interface.h"
#include "codonny98.h"

class TestMethod {
public :
	void test ();
/**
	init all things here before starting testing this method with data
*/
	void init ();
/**
	set all paramaters of this class for Model class, Rate class
	@param params parameters
*/
	void setPam (CommonParameters &params);


/**
	do the quartet puzzling method for all data set from the input file
	@param params parameters
	@return the number of correct predicted tree
*/
	int create (CommonParameters &params, InputParameters &in_pam, time_t &beginTime_);
/**
	after using DNA model for alignment, call this function if it is codon data
*/
	void startCodonAnalysis();

	void startNextBootstrap();
	
};

#endif
