%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM0": ["0x7172737475767778", "0x4142434445464748", "0x7172737475767778", "0x4142434445464748"],
    "XMM1": ["0x6162636465666768", "0x5152535455565758", "0x6162636465666768", "0x5152535455565758"],
    "XMM2": ["0xFFFFFFFFFFFFFFFF", "0x0000000000000000", "0xFFFFFFFFFFFFFFFF", "0x0000000000000000"],
    "XMM3": ["0xFFFFFFFFFFFFFFFF", "0x0000000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM4": ["0xFFFFFFFFFFFFFFFF", "0x0000000000000000", "0xFFFFFFFFFFFFFFFF", "0x0000000000000000"],
    "XMM5": ["0xFFFFFFFFFFFFFFFF", "0x0000000000000000", "0x0000000000000000", "0x0000000000000000"]
  }
}
%endif

lea rdx, [rel .data]

vmovapd ymm0, [rdx + 32 * 0]
vmovapd ymm1, [rdx + 32 * 1]

; Register only
vpcmpgtd ymm2, ymm0, ymm1
vpcmpgtd xmm3, xmm0, xmm1

; Memory operand
vpcmpgtd ymm4, ymm0, [rdx + 32 * 1]
vpcmpgtd xmm5, xmm0, [rdx + 32 * 1]

hlt

align 4096
.data:
dq 0x7172737475767778
dq 0x4142434445464748
dq 0x7172737475767778
dq 0x4142434445464748

dq 0x6162636465666768
dq 0x5152535455565758
dq 0x6162636465666768
dq 0x5152535455565758
