/*
    SPDX-FileCopyrightText: 2007-2009 Friedrich W. H. Kossebau <kossebau@kde.org>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#include "abstractdocument.hpp"
#include "abstractdocument_p.hpp"

// Std
#include <utility>

namespace Kasten {

AbstractDocument::AbstractDocument()
    : AbstractModel(std::make_unique<AbstractDocumentPrivate>(this))
{}

AbstractDocument::~AbstractDocument() = default;

QString AbstractDocument::id() const
{
    Q_D(const AbstractDocument);

    return d->id();
}
AbstractModelSynchronizer* AbstractDocument::synchronizer() const
{
    Q_D(const AbstractDocument);

    return d->synchronizer();
}

void AbstractDocument::setId(const QString& id)
{
    Q_D(AbstractDocument);

    d->setId(id);
}
void AbstractDocument::setSynchronizer(std::unique_ptr<AbstractModelSynchronizer>&& synchronizer)
{
    Q_D(AbstractDocument);

    d->setSynchronizer(std::move(synchronizer));
}

}

#include "moc_abstractdocument.cpp"
