/* $Id: pnm.c,v 1.1.1.1 2003/01/30 12:22:26 hito Exp $ */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "stimg.h"

STIMG *load_pnm(char *filename, int check);

STIMG_ANIMATION *
load_animation_pnm(char *file, int check)
{
  STIMG_ANIMATION *animation;
  STIMG *image;

  image = load_pnm(file, check);
  if (image == NULL)
    return NULL;

  animation = stimg_animation_new();
  if (animation == NULL) {
    stimg_delete(image);
    return NULL;
  }

  stimg_animation_add_frame(animation, image, 0, 0, 0, 0);
  return animation;
}

STIMG *
load_pnm(char *filename, int check)
{
   char p = ' ', numbers = 3, count = 0;
   int w = 0, h = 0, v = 255, c = 0, i, j, x, y;
   char buf[256], buf2[256];
   unsigned char *data = NULL, *ptr = NULL, *ptr2 = NULL;
   int *idata = NULL, *iptr;
   FILE *f = NULL;
   STIMG *image;

   if (filename == NULL)
      return NULL;

   f = fopen(filename, "rb");
   if (!f)
      return NULL;

   /* can't use fgets(), because there might be
    * binary data after the header and there
    * needn't be a newline before the data, so
    * no chance to distinguish between end of buffer
    * and a binary 0.
    */

   /* read the header info */

   c = fgetc(f);
   if (c != 'P')
   {
      fclose(f);
      return NULL;
   }

   p = fgetc(f);
   if (p == '1' || p == '4')
      numbers = 2;      /* bitimages don't have max value */

   if ((p < '1') || (p > '8'))
     {
	fclose(f);
	return NULL;	
     }
   count = 0;
   while (count < numbers)
   {
      c = fgetc(f);

      if (c == EOF)
      {
         fclose(f);
         return NULL;
      }

      /* eat whitespace */
      while (isspace(c))
         c = fgetc(f);
      /* if comment, eat that */
      if (c == '#')
      {
         do
            c = fgetc(f);
         while (c != '\n' && c != EOF);
      }
      /* no comment -> proceed */
      else
      {
         int i = 0;

         /* read numbers */
         while (c != EOF && !isspace(c))
         {
            buf[i++] = c;
            c = fgetc(f);
         }
         if (i)
         {
            buf[i] = 0;
            count++;
            switch (count)
            {
                 /* width */
              case 1:
		 w = atoi(buf);
                 break;
                 /* height */
              case 2:
		 h = atoi(buf);
                 break;
                 /* max value, only for color and greyscale */
              case 3:
                 v = atoi(buf);
                 break;
            }
         }
      }
   }
   if ((w <= 0) || (w > 8192) || (h <= 0) || (h > 8192) || (v < 0) || (v > 255)) {
     fclose(f);
     return NULL;
   }

   image = stimg_new(w, h, p == 8);
   if (image == NULL || check) {
         fclose(f);
         return image;
   }

   ptr2 = stimg_get_data(image);

      /* must set the im->data member before callign progress function */
      /* start reading the data */
      switch (p)
      {
        case '1':      /* ASCII monochrome */
           buf[0] = 0;
           i = 0;
           for (y = 0; y < h; y++)
           {
              x = 0;
              while (x < w)
              {
                 if (!buf[i])	/* fill buffer */
                 {
                    if (!fgets(buf, 255, f))
                    {
                       fclose(f);
		       stimg_delete(image);
                       return NULL;
                    }
                    i = 0;
                 }
                 while (buf[i] && isspace(buf[i]))
                    i++;
                 if (buf[i])
                 {
		   if (buf[i] == '1') {
		     *ptr2++ = 0;
		     *ptr2++ = 0;
		     *ptr2++ = 0;
		   } else if (buf[i] == '0') {
		     *ptr2++ = 0xff;
		     *ptr2++ = 0xff;
		     *ptr2++ = 0xff;
                   } else {
		     fclose(f);
		       stimg_delete(image);
                       return NULL;
		   }
		   i++;
                 }
              }
           }
           break;
        case '2':      /* ASCII greyscale */
           idata = malloc(sizeof(int) * w);

           if (!idata)
           {
              fclose(f);
	      stimg_delete(image);
	      return NULL;
           }
           buf[0] = 0;
           i = 0;
           j = 0;
           for (y = 0; y < h; y++)
           {
              iptr = idata;
              x = 0;
              while (x < w)
              {
                 if (!buf[i])	/* fill buffer */
                 {
                    if (!fgets(buf, 255, f))
                    {
                       free(idata);
                       fclose(f);
		       stimg_delete(image);
                       return NULL;
                    }
                    i = 0;
                 }
                 while (buf[i] && isspace(buf[i]))
                    i++;
                 while (buf[i] && !isspace(buf[i]))
                    buf2[j++] = buf[i++];
                 if (j)
                 {
                    buf2[j] = 0;
                    *(iptr++) = atoi(buf2);
                    j = 0;
                    x++;
                 }
              }
              iptr = idata;
              if (v == 255)
              {
                 for (x = 0; x < w; x++)
                 {
		   *ptr2++ = iptr[0];
		   *ptr2++ = iptr[0];
		   *ptr2++ = iptr[0];
		   iptr++;
                 }
              }
              else
              {
		for (x = 0; x < w; x++)
		  {
		    *ptr2++ = (iptr[0] * 255) / v;
		    *ptr2++ = (iptr[0] * 255) / v;
		    *ptr2++ = (iptr[0] * 255) / v;
                    iptr++;
                 }
              }
           }
           break;
        case '3':      /* ASCII RGB */
           idata = malloc(3 * sizeof(int) * w);

           if (!idata)
           {
              fclose(f);
	      stimg_delete(image);
              return NULL;
           }
           buf[0] = 0;
           i = 0;
           j = 0;
           for (y = 0; y < h; y++)
           {
              int w3 = 3 * w;

              iptr = idata;
              x = 0;
              while (x < w3)
              {
                 if (!buf[i])	/* fill buffer */
                 {
                    if (!fgets(buf, 255, f))
                    {
                       free(idata);
                       fclose(f);
		       stimg_delete(image);
                       return NULL;
                    }
                    i = 0;
                 }
                 while (buf[i] && isspace(buf[i]))
                    i++;
                 while (buf[i] && !isspace(buf[i]))
                    buf2[j++] = buf[i++];
                 if (j)
                 {
                    buf2[j] = 0;
                    *(iptr++) = atoi(buf2);
                    j = 0;
                    x++;
                 }
              }
              iptr = idata;
              if (v == 255)
              {
                 for (x = 0; x < w; x++)
                 {
		   *ptr2++ = iptr[0];
		   *ptr2++ = iptr[1];
		   *ptr2++ = iptr[2];
		   iptr += 3;
                 }
              }
              else
              {
                 for (x = 0; x < w; x++)
                 {
		   *ptr2++ = ptr[0] * 255;
		   *ptr2++ = ptr[1] * 255;
		   *ptr2++ = ptr[2] * 255;
		   iptr += 3;
                 }
              }
           }
           break;
        case '4':      /* binary 1bit monochrome */
           data = malloc(1);
           if (!data)
           {
              fclose(f);
	      stimg_delete(image);
              return NULL;
           }
           j = 0;
           while ((fread(data, 1, 1, f)) && (j < (w * h)))
           {
              for (i = 7; i >= 0; i--)
              {
                 if (j < (w * h))
                 {
		   if (data[0] & (1 << i)) {
		     *ptr2++ = 0;
		     *ptr2++ = 0;
		     *ptr2++ = 0;
		   } else {
		     *ptr2 = 0xff;
		     *ptr2 = 0xff;
		     *ptr2 = 0xff;
                 }
                 j++;
              }
           }
           break;
        case '5':      /* binary 8bit grayscale GGGGGGGG */
           data = malloc(w);
           if (!data)
           {
              fclose(f);
	      stimg_delete(image);
              return NULL;
           }
           for (y = 0; y < h; y++)
           {
              if (!fread(data, w * 1, 1, f))
              {
                 free(data);
                 fclose(f);
                 return image;
              }
              ptr = data;
              if (v == 255)
              {
                 for (x = 0; x < w; x++)
                 {
		   *ptr2++ = ptr[0];
		   *ptr2++ = ptr[0];
		   *ptr2++ = ptr[0];
                    ptr++;
                 }
              }
              else
              {
                 for (x = 0; x < w; x++)
                 {
		   *ptr2++ = (ptr[0] * 255) / v;
		   *ptr2++ = (ptr[0] * 255) / v;
		   *ptr2++ = (ptr[0] * 255) / v;
		   ptr++;
                 }
              }
           }
           break;
        case '6':      /* 24bit binary RGBRGBRGB */
           data = malloc(3 * w);
           if (!data)
           {
              fclose(f);
	      stimg_delete(image);
              return NULL;
           }
           for (y = 0; y < h; y++)
	   {
              if (!fread(data, w * 3, 1, f))
	      {
                 free(data);
                 fclose(f);
                 return image;
              }
              ptr = data;
              if (v == 255)
              {
                 for (x = 0; x < w; x++)
                 {
		   *ptr2++ = ptr[0];
		   *ptr2++ = ptr[1];
		   *ptr2++ = ptr[2];
                    ptr += 3;
                 }
              }
              else
              {
                 for (x = 0; x < w; x++)
                 {
		   *ptr2++ = (ptr[0] * 255) / v;
		   *ptr2++ = (ptr[1] * 255) / v;
		   *ptr2++ = (ptr[2] * 255) / v;
                    ptr += 3;
                 }
              }
           }
           break;
        case '7':      /* XV's 8bit 332 format */
           data = malloc(w);
           if (!data)
           {
              fclose(f);
	      stimg_delete(image);
              return NULL;
           }
           for (y = 0; y < h; y++)
           {
              if (!fread(data, w * 1, 1, f))
              {
                 free(data);
                 fclose(f);
                 return image;
              }
              ptr = data;
              for (x = 0; x < w; x++)
              {
                 int r, g, b;

                 r = (*ptr >> 5) & 0x7;
                 g = (*ptr >> 2) & 0x7;
                 b = (*ptr) & 0x3;
                 *ptr2++ = (((r << 6) | (r << 3) | (r << 0)) & 0xff);
		 *ptr2++ = (((g << 6) | (g << 3) | (g << 7)) & 0xff);
		 *ptr2++ = ((b << 6) | (b << 4) | (b << 2) | (b << 0));
                 ptr++;
              }
           }
           break;
        case '8':      /* 24bit binary RGBARGBARGBA */
           data = malloc(4 * w);
           if (!data)
           {
              fclose(f);
	      stimg_delete(image);
              return NULL;
           }
           for (y = 0; y < h; y++)
           {
              if (!fread(data, w * 4, 1, f))
              {
                 free(data);
                 fclose(f);
                 return image;
              }
              ptr = data;
              if (v == 255)
              {
                 for (x = 0; x < w; x++)
                 {
                    *ptr2++ = ptr[0];
                    *ptr2++ = ptr[1];
                    *ptr2++ = ptr[2];
                    *ptr2++ = ptr[3];
                    ptr += 4;
                 }
              }
              else
              {
                 for (x = 0; x < w; x++)
                 {
		   *ptr2++ = (ptr[0] * 255) / v;
		   *ptr2++ = (ptr[1] * 255) / v;
		   *ptr2++ = (ptr[2] * 255) / v;
		   *ptr2++ = (ptr[3] * 255) / v;
                    ptr += 4;
                 }
              }
           }
           break;
        default:
           fclose(f);
           return NULL;
           break;
      }
      if (idata)
         free(idata);
      if (data)
         free(data);
   }
   fclose(f);
   return image;
}
