package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOperateInfo invokes the aegis.DescribeOperateInfo API synchronously
// api document: https://help.aliyun.com/api/aegis/describeoperateinfo.html
func (client *Client) DescribeOperateInfo(request *DescribeOperateInfoRequest) (response *DescribeOperateInfoResponse, err error) {
	response = CreateDescribeOperateInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOperateInfoWithChan invokes the aegis.DescribeOperateInfo API asynchronously
// api document: https://help.aliyun.com/api/aegis/describeoperateinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeOperateInfoWithChan(request *DescribeOperateInfoRequest) (<-chan *DescribeOperateInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeOperateInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOperateInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOperateInfoWithCallback invokes the aegis.DescribeOperateInfo API asynchronously
// api document: https://help.aliyun.com/api/aegis/describeoperateinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeOperateInfoWithCallback(request *DescribeOperateInfoRequest, callback func(response *DescribeOperateInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOperateInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeOperateInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOperateInfoRequest is the request struct for api DescribeOperateInfo
type DescribeOperateInfoRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Lang     string `position:"Query" name:"Lang"`
}

// DescribeOperateInfoResponse is the response struct for api DescribeOperateInfo
type DescribeOperateInfoResponse struct {
	*responses.BaseResponse
	RequestId                      string   `json:"RequestId" xml:"RequestId"`
	HealthCheckDealedCount         int      `json:"HealthCheckDealedCount" xml:"HealthCheckDealedCount"`
	SecurityEventDealedCount       int      `json:"SecurityEventDealedCount" xml:"SecurityEventDealedCount"`
	VulnerabilityDealedCount       int      `json:"VulnerabilityDealedCount" xml:"VulnerabilityDealedCount"`
	Success                        bool     `json:"Success" xml:"Success"`
	SuspEventValueArray            []string `json:"SuspEventValueArray" xml:"SuspEventValueArray"`
	SuspEventAaggregatValueArray   []string `json:"SuspEventAaggregatValueArray" xml:"SuspEventAaggregatValueArray"`
	VulValueArray                  []string `json:"VulValueArray" xml:"VulValueArray"`
	VulAaggregatValueArray         []string `json:"VulAaggregatValueArray" xml:"VulAaggregatValueArray"`
	DateArray                      []string `json:"DateArray" xml:"DateArray"`
	HealthCheckValueArray          []string `json:"HealthCheckValueArray" xml:"HealthCheckValueArray"`
	HealthCheckAaggregatValueArray []string `json:"HealthCheckAaggregatValueArray" xml:"HealthCheckAaggregatValueArray"`
}

// CreateDescribeOperateInfoRequest creates a request to invoke DescribeOperateInfo API
func CreateDescribeOperateInfoRequest() (request *DescribeOperateInfoRequest) {
	request = &DescribeOperateInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeOperateInfo", "vipaegis", "openAPI")
	return
}

// CreateDescribeOperateInfoResponse creates a response to parse from DescribeOperateInfo response
func CreateDescribeOperateInfoResponse() (response *DescribeOperateInfoResponse) {
	response = &DescribeOperateInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
