package vcs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubscribeDeviceEvent invokes the vcs.SubscribeDeviceEvent API synchronously
func (client *Client) SubscribeDeviceEvent(request *SubscribeDeviceEventRequest) (response *SubscribeDeviceEventResponse, err error) {
	response = CreateSubscribeDeviceEventResponse()
	err = client.DoAction(request, response)
	return
}

// SubscribeDeviceEventWithChan invokes the vcs.SubscribeDeviceEvent API asynchronously
func (client *Client) SubscribeDeviceEventWithChan(request *SubscribeDeviceEventRequest) (<-chan *SubscribeDeviceEventResponse, <-chan error) {
	responseChan := make(chan *SubscribeDeviceEventResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubscribeDeviceEvent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubscribeDeviceEventWithCallback invokes the vcs.SubscribeDeviceEvent API asynchronously
func (client *Client) SubscribeDeviceEventWithCallback(request *SubscribeDeviceEventRequest, callback func(response *SubscribeDeviceEventResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubscribeDeviceEventResponse
		var err error
		defer close(result)
		response, err = client.SubscribeDeviceEvent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubscribeDeviceEventRequest is the request struct for api SubscribeDeviceEvent
type SubscribeDeviceEventRequest struct {
	*requests.RpcRequest
	PushConfig string `position:"Query" name:"PushConfig"`
	DeviceId   string `position:"Query" name:"DeviceId"`
}

// SubscribeDeviceEventResponse is the response struct for api SubscribeDeviceEvent
type SubscribeDeviceEventResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateSubscribeDeviceEventRequest creates a request to invoke SubscribeDeviceEvent API
func CreateSubscribeDeviceEventRequest() (request *SubscribeDeviceEventRequest) {
	request = &SubscribeDeviceEventRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vcs", "2020-05-15", "SubscribeDeviceEvent", "", "")
	request.Method = requests.POST
	return
}

// CreateSubscribeDeviceEventResponse creates a response to parse from SubscribeDeviceEvent response
func CreateSubscribeDeviceEventResponse() (response *SubscribeDeviceEventResponse) {
	response = &SubscribeDeviceEventResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
