/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import com.google.common.annotations.VisibleForTesting;
import com.sun.tools.javac.api.ClientCodeWrapper;
import com.sun.tools.javac.api.DiagnosticFormatter;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.problems.ProblemSpec;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblemReporter;
import org.gradle.api.problems.internal.Problem;

@ClientCodeWrapper.Trusted
public class DiagnosticToProblemListener
implements DiagnosticListener<JavaFileObject> {
    public static final String FORMATTER_FALLBACK_MESSAGE = "Failed to format diagnostic message, falling back to default message formatting";
    private static final Logger LOGGER = Logging.getLogger(DiagnosticToProblemListener.class);
    private final Context context;
    private final InternalProblemReporter problemReporter;
    private final List<Problem> problemsReported = new ArrayList<Problem>();
    private int errorCount = 0;
    private int warningCount = 0;

    public DiagnosticToProblemListener(InternalProblemReporter problemReporter, Context context) {
        this.problemReporter = problemReporter;
        this.context = context;
    }

    @Override
    public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
        switch (diagnostic.getKind()) {
            case ERROR: {
                ++this.errorCount;
                break;
            }
            case WARNING: 
            case MANDATORY_WARNING: {
                ++this.warningCount;
                break;
            }
        }
        Problem reportedProblem = this.problemReporter.create(spec -> this.buildProblem(diagnostic, (ProblemSpec)spec));
        this.problemsReported.add(reportedProblem);
    }

    String diagnosticCounts() {
        Log logger = Log.instance(new Context());
        Optional<String> error = DiagnosticToProblemListener.diagnosticCount(logger, "error", this.errorCount);
        Optional<String> warning = DiagnosticToProblemListener.diagnosticCount(logger, "warn", this.warningCount);
        return Stream.of(error, warning).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining(System.lineSeparator()));
    }

    private static Optional<String> diagnosticCount(Log logger, String kind, int number) {
        if (!"error".equals(kind) && !"warn".equals(kind)) {
            throw new IllegalArgumentException("kind must be either 'error' or 'warn'");
        }
        if (number == 0) {
            return Optional.empty();
        }
        StringBuilder keyBuilder = new StringBuilder("count.");
        keyBuilder.append(kind);
        if (number > 1) {
            keyBuilder.append(".plural");
        }
        return Optional.of(logger.localize(keyBuilder.toString(), number));
    }

    @VisibleForTesting
    void buildProblem(Diagnostic<? extends JavaFileObject> diagnostic, ProblemSpec spec) {
        Severity severity = DiagnosticToProblemListener.mapKindToSeverity(diagnostic.getKind());
        spec.severity(severity);
        DiagnosticToProblemListener.addId(spec, diagnostic);
        this.addFormattedMessage(spec, diagnostic);
        DiagnosticToProblemListener.addDetails(spec, diagnostic);
        DiagnosticToProblemListener.addLocations(spec, diagnostic);
        if (severity == Severity.ERROR) {
            spec.solution("Check your code and dependencies to fix the compilation error(s)");
        }
    }

    private static void addId(ProblemSpec spec, Diagnostic<? extends JavaFileObject> diagnostic) {
        String idName = diagnostic.getCode().replace('.', '-');
        spec.id(idName, DiagnosticToProblemListener.mapKindToDisplayName(diagnostic.getKind()), GradleCoreProblemGroup.compilation().java());
    }

    private void addFormattedMessage(ProblemSpec spec, Diagnostic<? extends JavaFileObject> diagnostic) {
        String formatted = this.toFormattedMessage(diagnostic);
        System.err.println(formatted);
        spec.details(formatted);
    }

    private static void addDetails(ProblemSpec spec, Diagnostic<? extends JavaFileObject> diagnostic) {
        String message = diagnostic.getMessage(Locale.getDefault());
        String[] messageLines = message.split("\n");
        spec.contextualLabel(messageLines[0]);
    }

    private static void addLocations(ProblemSpec spec, Diagnostic<? extends JavaFileObject> diagnostic) {
        String resourceName = diagnostic.getSource() != null ? DiagnosticToProblemListener.getPath(diagnostic.getSource()) : null;
        int line = DiagnosticToProblemListener.clampLocation(diagnostic.getLineNumber());
        int column = DiagnosticToProblemListener.clampLocation(diagnostic.getColumnNumber());
        int position = DiagnosticToProblemListener.clampLocation(diagnostic.getPosition());
        int end = DiagnosticToProblemListener.clampLocation(diagnostic.getEndPosition());
        if (resourceName != null) {
            if (-1L != (long)line) {
                if (-1L != (long)column) {
                    if (-1L != (long)position) {
                        spec.lineInFileLocation(resourceName, line, column, end - position);
                    } else {
                        spec.lineInFileLocation(resourceName, line, column);
                    }
                } else {
                    spec.lineInFileLocation(resourceName, line);
                }
            } else if (-1L != (long)position && end > position) {
                spec.offsetInFileLocation(resourceName, position, end - position);
            } else {
                spec.fileLocation(resourceName);
            }
        }
    }

    private String toFormattedMessage(Diagnostic<? extends JavaFileObject> diagnostic) {
        try {
            DiagnosticFormatter<JCDiagnostic> formatter = Log.instance(this.context).getDiagnosticFormatter();
            return formatter.format((JCDiagnostic)diagnostic, JavacMessages.instance(this.context).getCurrentLocale());
        }
        catch (Exception ex) {
            LOGGER.info(FORMATTER_FALLBACK_MESSAGE);
            return diagnostic.getMessage(Locale.getDefault());
        }
    }

    private static int clampLocation(long value) {
        if (value > Integer.MAX_VALUE) {
            return Math.toIntExact(-1L);
        }
        return (int)value;
    }

    private static String getPath(JavaFileObject fileObject) {
        return fileObject.getName();
    }

    private static String mapKindToDisplayName(Diagnostic.Kind kind) {
        switch (kind) {
            case ERROR: {
                return "Java compilation error";
            }
            case WARNING: 
            case MANDATORY_WARNING: {
                return "Java compilation warning";
            }
            case NOTE: {
                return "Java compilation note";
            }
            case OTHER: {
                return "Java compilation problem";
            }
        }
        return "Unknown java compilation problem";
    }

    private static Severity mapKindToSeverity(Diagnostic.Kind kind) {
        switch (kind) {
            case ERROR: {
                return Severity.ERROR;
            }
            case WARNING: 
            case MANDATORY_WARNING: {
                return Severity.WARNING;
            }
        }
        return Severity.ADVICE;
    }

    public List<Problem> getReportedProblems() {
        return Collections.unmodifiableList(this.problemsReported);
    }
}

