// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package server

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// AddRuntimeServerCreatedCode is the HTTP code returned for type AddRuntimeServerCreated
const AddRuntimeServerCreatedCode int = 201

/*
AddRuntimeServerCreated Server added

swagger:response addRuntimeServerCreated
*/
type AddRuntimeServerCreated struct {

	/*
	  In: Body
	*/
	Payload *models.RuntimeAddServer `json:"body,omitempty"`
}

// NewAddRuntimeServerCreated creates AddRuntimeServerCreated with default headers values
func NewAddRuntimeServerCreated() *AddRuntimeServerCreated {

	return &AddRuntimeServerCreated{}
}

// WithPayload adds the payload to the add runtime server created response
func (o *AddRuntimeServerCreated) WithPayload(payload *models.RuntimeAddServer) *AddRuntimeServerCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the add runtime server created response
func (o *AddRuntimeServerCreated) SetPayload(payload *models.RuntimeAddServer) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AddRuntimeServerCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AddRuntimeServerBadRequestCode is the HTTP code returned for type AddRuntimeServerBadRequest
const AddRuntimeServerBadRequestCode int = 400

/*
AddRuntimeServerBadRequest Bad request

swagger:response addRuntimeServerBadRequest
*/
type AddRuntimeServerBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewAddRuntimeServerBadRequest creates AddRuntimeServerBadRequest with default headers values
func NewAddRuntimeServerBadRequest() *AddRuntimeServerBadRequest {

	return &AddRuntimeServerBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the add runtime server bad request response
func (o *AddRuntimeServerBadRequest) WithConfigurationVersion(configurationVersion string) *AddRuntimeServerBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the add runtime server bad request response
func (o *AddRuntimeServerBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the add runtime server bad request response
func (o *AddRuntimeServerBadRequest) WithPayload(payload *models.Error) *AddRuntimeServerBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the add runtime server bad request response
func (o *AddRuntimeServerBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AddRuntimeServerBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AddRuntimeServerNotFoundCode is the HTTP code returned for type AddRuntimeServerNotFound
const AddRuntimeServerNotFoundCode int = 404

/*
AddRuntimeServerNotFound The specified resource was not found

swagger:response addRuntimeServerNotFound
*/
type AddRuntimeServerNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewAddRuntimeServerNotFound creates AddRuntimeServerNotFound with default headers values
func NewAddRuntimeServerNotFound() *AddRuntimeServerNotFound {

	return &AddRuntimeServerNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the add runtime server not found response
func (o *AddRuntimeServerNotFound) WithConfigurationVersion(configurationVersion string) *AddRuntimeServerNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the add runtime server not found response
func (o *AddRuntimeServerNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the add runtime server not found response
func (o *AddRuntimeServerNotFound) WithPayload(payload *models.Error) *AddRuntimeServerNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the add runtime server not found response
func (o *AddRuntimeServerNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AddRuntimeServerNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AddRuntimeServerConflictCode is the HTTP code returned for type AddRuntimeServerConflict
const AddRuntimeServerConflictCode int = 409

/*
AddRuntimeServerConflict The specified resource already exists

swagger:response addRuntimeServerConflict
*/
type AddRuntimeServerConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewAddRuntimeServerConflict creates AddRuntimeServerConflict with default headers values
func NewAddRuntimeServerConflict() *AddRuntimeServerConflict {

	return &AddRuntimeServerConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the add runtime server conflict response
func (o *AddRuntimeServerConflict) WithConfigurationVersion(configurationVersion string) *AddRuntimeServerConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the add runtime server conflict response
func (o *AddRuntimeServerConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the add runtime server conflict response
func (o *AddRuntimeServerConflict) WithPayload(payload *models.Error) *AddRuntimeServerConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the add runtime server conflict response
func (o *AddRuntimeServerConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AddRuntimeServerConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
AddRuntimeServerDefault General Error

swagger:response addRuntimeServerDefault
*/
type AddRuntimeServerDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewAddRuntimeServerDefault creates AddRuntimeServerDefault with default headers values
func NewAddRuntimeServerDefault(code int) *AddRuntimeServerDefault {
	if code <= 0 {
		code = 500
	}

	return &AddRuntimeServerDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the add runtime server default response
func (o *AddRuntimeServerDefault) WithStatusCode(code int) *AddRuntimeServerDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the add runtime server default response
func (o *AddRuntimeServerDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the add runtime server default response
func (o *AddRuntimeServerDefault) WithConfigurationVersion(configurationVersion string) *AddRuntimeServerDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the add runtime server default response
func (o *AddRuntimeServerDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the add runtime server default response
func (o *AddRuntimeServerDefault) WithPayload(payload *models.Error) *AddRuntimeServerDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the add runtime server default response
func (o *AddRuntimeServerDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AddRuntimeServerDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
