
CMAKE
-----

Unix and Win32 binaries (both 32- and 64-bit) can be built using CMake.
CMake is an open-source tool like automake - it generates makefiles.

CMake v3.14.5 is able to generate:
  Borland Makefiles
  MSYS Makefiles
  MinGW Makefiles
  NMake Makefiles
  Unix Makefiles
  Visual Studio 16 2019
  Visual Studio 15 2017
  Visual Studio 14 2015
  Visual Studio 12 2013
  Visual Studio 11 2012
  Visual Studio 10 2010
  Visual Studio 9 2008
  Watcom WMake


BUILD PROCESS
-------------

 . install cmake (cmake.org)
 . add directory containing cmake.exe to %PATH%
 . run cmake from the gc root directory, passing the target with -G:
   e.g.,
      > cmake -G "Visual Studio 9 2008" .
   use the gc.sln file generated by cmake to build gc
 . specify -Denable_cplusplus=ON option to build gccpp (GC C++ support)
 . specify -Dbuild_tests=ON option to the tests (and run them by "ctest -V")
 . you can also run cmake from a build directory to build outside of
   the source tree. Just specify the path to the source tree:
   e.g.,
      > mkdir out
      > cd out
      > cmake -G "Visual Studio 9 2008" ..
      > cmake --build . --config Release
      > ctest --build-config Release -V


INPUT
-----

The main input to cmake is CMakeLists.txt file in the GC root directory.  For
help, go to cmake.org.


HOW TO IMPORT BDWGC
-------------------

Another project could add bdwgc as one of its dependencies with something like
this in their CMakeLists.txt:

find_package(BDWgc 8.2.0 REQUIRED)
add_executable(Foo foo.c)
target_link_libraries(Foo BDWgc::gc)

Other exported libraries are: cord, gccpp, gctba.
