/*
 * Decompiled with CFR 0.152.
 */
package com.github.jhoenicke.javacup.anttask;

import com.github.jhoenicke.javacup.Main;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class CUPTask
extends Task {
    private String srcfile = null;
    private String parser = null;
    private String _package = null;
    private String symbols = null;
    private String destdir = null;
    private boolean java15 = false;
    private boolean _interface = false;
    private boolean nonterms = false;
    private String expect = null;
    private boolean compact_red = false;
    private boolean nowarn = false;
    private boolean nosummary = false;
    private boolean progress = false;
    private boolean dump_grammar = false;
    private boolean dump_states = false;
    private boolean dump_tables = false;
    private boolean dump = false;
    private boolean time = false;
    private boolean debug = false;
    private boolean nopositions = false;
    private boolean noscanner = false;
    private boolean force = false;
    private boolean quiet = false;

    public void execute() throws BuildException {
        String[] stringArray;
        File file;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.parser != null) {
            arrayList.add("-parser");
            arrayList.add(this.parser);
        } else {
            this.parser = "parser";
        }
        if (this._package != null) {
            arrayList.add("-package");
            arrayList.add(this._package);
        }
        if (this.symbols != null) {
            arrayList.add("-symbols");
            arrayList.add(this.symbols);
        } else {
            this.symbols = "sym";
        }
        if (this.expect != null) {
            arrayList.add("-expect");
            arrayList.add(this.expect);
        }
        if (this.java15) {
            arrayList.add("-java15");
        }
        if (this._interface) {
            arrayList.add("-interface");
        }
        if (this.nonterms) {
            arrayList.add("-nonterms");
        }
        if (this.compact_red) {
            arrayList.add("-compact_red");
        }
        if (this.nowarn) {
            arrayList.add("-nowarn");
        }
        if (this.nosummary) {
            arrayList.add("-nosummary");
        }
        if (this.progress) {
            arrayList.add("-progress");
        }
        if (this.dump_grammar) {
            arrayList.add("-dump_grammar");
        }
        if (this.dump_states) {
            arrayList.add("-dump_states");
        }
        if (this.dump_tables) {
            arrayList.add("-dump_tables");
        }
        if (this.dump) {
            arrayList.add("-dump");
        }
        if (this.time) {
            arrayList.add("-time");
        }
        if (this.debug) {
            arrayList.add("-debug");
        }
        if (this.nopositions) {
            arrayList.add("-nopositions");
        }
        if (this.noscanner) {
            arrayList.add("-noscanner");
        }
        if (!this.quiet) {
            this.log("This is jh-javacup-1.2 20210807");
        }
        if (!this.quiet) {
            this.log("Authors : Scott E. Hudson, Frank Flannery, Andrea Flexeder, Michael Petter, C. Scott Ananian and Jochen Hoenicke");
        }
        if (!this.quiet) {
            this.log("Bugreports to petter@cs.tum.edu");
        }
        String string = this.inspect(this.srcfile);
        if (this.destdir == null) {
            this.destdir = System.getProperty("user.dir");
            if (!this.quiet) {
                this.log("No destination directory specified; using working directory: " + this.destdir);
            }
        }
        if (!(file = new File(this.destdir + string)).exists()) {
            if (!this.quiet) {
                this.log("Destination directory didn't exist; creating new one: " + this.destdir + string);
            }
            file.mkdirs();
            this.force = true;
        } else {
            if (this.force && !this.quiet) {
                this.log("anyway, this generation will be processed because of option force set to \"true\"");
            } else if (!this.quiet) {
                this.log("checking, whether this run is necessary");
            }
            stringArray = new File(this.destdir + string, this.parser + ".java");
            File file2 = new File(this.destdir + string, this.symbols + ".java");
            File file3 = new File(this.srcfile);
            if (!stringArray.exists() || !file2.exists()) {
                if (!this.quiet) {
                    this.log("Either Parserfile or Symbolfile didn't exist");
                }
                this.force = true;
            } else if (!this.quiet) {
                this.log("Parserfile and symbolfile are existing");
            }
            if (stringArray.lastModified() <= file3.lastModified()) {
                if (!this.quiet) {
                    this.log("Parserfile " + stringArray + " isn't actual");
                }
                this.force = true;
            } else if (!this.quiet) {
                this.log("Parserfile " + stringArray + " is actual");
            }
            if (file2.lastModified() <= file3.lastModified()) {
                if (!this.quiet) {
                    this.log("Symbolfile " + file2 + " isn't actual");
                }
                this.force = true;
            } else if (!this.quiet) {
                this.log("Symbolfile" + file2 + " is actual");
            }
            if (!this.force) {
                if (!this.quiet) {
                    this.log("skipping generation of " + this.srcfile);
                }
                if (!this.quiet) {
                    this.log("use option force=\"true\" to override");
                }
                return;
            }
        }
        arrayList.add("-destdir");
        arrayList.add(file.getAbsolutePath());
        if (this.srcfile == null) {
            throw new BuildException("Input file needed: Specify <cup srcfile=\"myfile.cup\"> ");
        }
        if (!new File(this.srcfile).exists()) {
            throw new BuildException("Input file not found: srcfile=\"" + this.srcfile + "\" ");
        }
        arrayList.add(this.srcfile);
        stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        try {
            Main.main(stringArray);
        }
        catch (Exception exception) {
            this.log("CUP error occured int CUP task: " + exception);
        }
    }

    protected String inspect(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while (bufferedReader.ready()) {
                String string2 = bufferedReader.readLine();
                if (!string2.startsWith("package") || string2.indexOf(";") == -1) continue;
                String string3 = string2.substring(8, string2.indexOf(";"));
                string3 = string3.replace('.', System.getProperty("file.separator").charAt(0));
                return System.getProperty("file.separator") + string3;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }

    public boolean getQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean bl) {
        this.quiet = bl;
    }

    public boolean getForce() {
        return this.force;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public String getPackage() {
        return this._package;
    }

    public void setPackage(String string) {
        this._package = string;
    }

    public String getDestdir() {
        return this.destdir;
    }

    public void setDestdir(String string) {
        this.destdir = string;
    }

    public boolean isJava15() {
        return this.java15;
    }

    public void setJava15(boolean bl) {
        this.java15 = bl;
    }

    public boolean isInterface() {
        return this._interface;
    }

    public void setInterface(boolean bl) {
        this._interface = bl;
    }

    public String getSrcfile() {
        return this.srcfile;
    }

    public void setSrcfile(String string) {
        this.srcfile = string;
    }

    public String getParser() {
        return this.parser;
    }

    public void setParser(String string) {
        this.parser = string;
    }

    public String getSymbols() {
        return this.symbols;
    }

    public void setSymbols(String string) {
        this.symbols = string;
    }

    public boolean isNonterms() {
        return this.nonterms;
    }

    public void setNonterms(boolean bl) {
        this.nonterms = bl;
    }

    public String getExpect() {
        return this.expect;
    }

    public void setExpect(String string) {
        this.expect = string;
    }

    public boolean isCompact_red() {
        return this.compact_red;
    }

    public void setCompact_red(boolean bl) {
        this.compact_red = bl;
    }

    public boolean isNowarn() {
        return this.nowarn;
    }

    public void setNowarn(boolean bl) {
        this.nowarn = bl;
    }

    public boolean isNosummary() {
        return this.nosummary;
    }

    public void setNosummary(boolean bl) {
        this.nosummary = bl;
    }

    public boolean isProgress() {
        return this.progress;
    }

    public void setProgress(boolean bl) {
        this.progress = bl;
    }

    public boolean isDump_grammar() {
        return this.dump_grammar;
    }

    public void setDump_grammar(boolean bl) {
        this.dump_grammar = bl;
    }

    public boolean isDump_states() {
        return this.dump_states;
    }

    public void setDump_states(boolean bl) {
        this.dump_states = bl;
    }

    public boolean isDump_tables() {
        return this.dump_tables;
    }

    public void setDump_tables(boolean bl) {
        this.dump_tables = bl;
    }

    public boolean isDump() {
        return this.dump;
    }

    public void setDump(boolean bl) {
        this.dump = bl;
    }

    public boolean isTime() {
        return this.time;
    }

    public void setTime(boolean bl) {
        this.time = bl;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean isNopositions() {
        return this.nopositions;
    }

    public void setNopositions(boolean bl) {
        this.nopositions = bl;
    }

    public boolean isNoscanner() {
        return this.noscanner;
    }

    public void setNoscanner(boolean bl) {
        this.noscanner = bl;
    }
}

