/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.resolver.internal.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.maven.resolver.internal.ant.AetherUtils;
import org.apache.maven.resolver.internal.ant.AntLogger;
import org.apache.maven.resolver.internal.ant.AntModelResolver;
import org.apache.maven.resolver.internal.ant.AntRepositoryListener;
import org.apache.maven.resolver.internal.ant.AntServiceLocatorErrorHandler;
import org.apache.maven.resolver.internal.ant.AntSettingsDecryptorFactory;
import org.apache.maven.resolver.internal.ant.AntTransferListener;
import org.apache.maven.resolver.internal.ant.ConverterUtils;
import org.apache.maven.resolver.internal.ant.ProjectWorkspaceReader;
import org.apache.maven.resolver.internal.ant.SettingsUtils;
import org.apache.maven.resolver.internal.ant.org.apache.maven.model.Dependency;
import org.apache.maven.resolver.internal.ant.org.apache.maven.model.Exclusion;
import org.apache.maven.resolver.internal.ant.org.apache.maven.model.Model;
import org.apache.maven.resolver.internal.ant.org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.resolver.internal.ant.org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.resolver.internal.ant.org.apache.maven.model.building.FileModelSource;
import org.apache.maven.resolver.internal.ant.org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.resolver.internal.ant.org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.resolver.internal.ant.org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.resolver.internal.ant.org.apache.maven.settings.Profile;
import org.apache.maven.resolver.internal.ant.org.apache.maven.settings.Proxy;
import org.apache.maven.resolver.internal.ant.org.apache.maven.settings.Repository;
import org.apache.maven.resolver.internal.ant.org.apache.maven.settings.RepositoryPolicy;
import org.apache.maven.resolver.internal.ant.org.apache.maven.settings.Server;
import org.apache.maven.resolver.internal.ant.org.apache.maven.settings.Settings;
import org.apache.maven.resolver.internal.ant.org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.resolver.internal.ant.org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.resolver.internal.ant.org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.resolver.internal.ant.org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.resolver.internal.ant.org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.resolver.internal.ant.org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.resolver.internal.ant.org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.apache.maven.resolver.internal.ant.org.codehaus.plexus.util.xml.Xpp3Dom;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.DefaultRepositoryCache;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.DefaultRepositorySystemSession;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.RepositorySystem;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.RepositorySystemSession;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.artifact.DefaultArtifact;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.collection.CollectRequest;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.collection.CollectResult;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.collection.DependencyCollectionException;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.deployment.DeployRequest;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.deployment.DeploymentException;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.impl.DefaultServiceLocator;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.impl.RemoteRepositoryManager;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.installation.InstallRequest;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.installation.InstallationException;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.repository.Authentication;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.repository.AuthenticationSelector;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.repository.LocalRepository;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.repository.LocalRepositoryManager;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.repository.MirrorSelector;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.repository.ProxySelector;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.repository.RemoteRepository;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.spi.log.Logger;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.transport.classpath.ClasspathTransporterFactory;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.transport.file.FileTransporterFactory;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.util.repository.ConservativeAuthenticationSelector;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.util.repository.DefaultProxySelector;
import org.apache.maven.resolver.internal.ant.types.Artifact;
import org.apache.maven.resolver.internal.ant.types.Artifacts;
import org.apache.maven.resolver.internal.ant.types.Dependencies;
import org.apache.maven.resolver.internal.ant.types.DependencyContainer;
import org.apache.maven.resolver.internal.ant.types.Mirror;
import org.apache.maven.resolver.internal.ant.types.Pom;
import org.apache.maven.resolver.internal.ant.types.RemoteRepositories;
import org.apache.maven.resolver.internal.ant.types.RemoteRepository;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Reference;

public class AntRepoSys {
    private static final boolean OS_WINDOWS = Os.isFamily((String)"windows");
    private static final ModelBuilder MODEL_BUILDER = new DefaultModelBuilderFactory().newInstance();
    private static final SettingsBuilder SETTINGS_BUILDER = new DefaultSettingsBuilderFactory().newInstance();
    private static final SettingsDecrypter SETTINGS_DECRYPTER = new AntSettingsDecryptorFactory().newInstance();
    private final Project project;
    private final DefaultServiceLocator locator;
    private RepositorySystem repoSys;
    private RemoteRepositoryManager remoteRepoMan;
    private File userSettings;
    private File globalSettings;
    private Settings settings;
    private final List<Mirror> mirrors = new CopyOnWriteArrayList<Mirror>();
    private final List<org.apache.maven.resolver.internal.ant.types.Proxy> proxies = new CopyOnWriteArrayList<org.apache.maven.resolver.internal.ant.types.Proxy>();
    private final List<org.apache.maven.resolver.internal.ant.types.Authentication> authentications = new CopyOnWriteArrayList<org.apache.maven.resolver.internal.ant.types.Authentication>();
    private org.apache.maven.resolver.internal.ant.types.LocalRepository localRepository;
    private Pom defaultPom;

    private static <T> boolean eq(T o1, T o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static synchronized AntRepoSys getInstance(Project project) {
        Object obj = project.getReference("resolver");
        if (obj instanceof AntRepoSys) {
            return (AntRepoSys)obj;
        }
        AntRepoSys instance = new AntRepoSys(project);
        project.addReference("resolver", (Object)instance);
        instance.initDefaults();
        return instance;
    }

    private AntRepoSys(Project project) {
        this.project = project;
        this.locator = MavenRepositorySystemUtils.newServiceLocator();
        this.locator.setErrorHandler(new AntServiceLocatorErrorHandler(project));
        this.locator.setServices(Logger.class, new AntLogger(project));
        this.locator.setServices(ModelBuilder.class, MODEL_BUILDER);
        this.locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        this.locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        this.locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        this.locator.addService(TransporterFactory.class, ClasspathTransporterFactory.class);
    }

    private void initDefaults() {
        org.apache.maven.resolver.internal.ant.types.RemoteRepository repo = new org.apache.maven.resolver.internal.ant.types.RemoteRepository();
        repo.setProject(this.project);
        repo.setId("central");
        repo.setUrl("https://repo1.maven.org/maven2/");
        this.project.addReference("central", (Object)repo);
        repo = new org.apache.maven.resolver.internal.ant.types.RemoteRepository();
        repo.setProject(this.project);
        repo.setRefid(new Reference(this.project, "central"));
        RemoteRepositories repos = new RemoteRepositories();
        repos.setProject(this.project);
        repos.addRemoterepo(repo);
        this.project.addReference("resolver.repositories", (Object)repos);
    }

    public synchronized RepositorySystem getSystem() {
        if (this.repoSys == null) {
            this.repoSys = this.locator.getService(RepositorySystem.class);
            if (this.repoSys == null) {
                throw new BuildException("The repository system could not be initialized");
            }
        }
        return this.repoSys;
    }

    private synchronized RemoteRepositoryManager getRemoteRepoMan() {
        if (this.remoteRepoMan == null) {
            this.remoteRepoMan = this.locator.getService(RemoteRepositoryManager.class);
            if (this.remoteRepoMan == null) {
                throw new BuildException("The repository system could not be initialized");
            }
        }
        return this.remoteRepoMan;
    }

    public RepositorySystemSession getSession(Task task, org.apache.maven.resolver.internal.ant.types.LocalRepository localRepo) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LinkedHashMap<Object, Object> configProps = new LinkedHashMap<Object, Object>();
        configProps.put("aether.connector.userAgent", this.getUserAgent());
        configProps.putAll(this.project.getProperties());
        this.processServerConfiguration(configProps);
        session.setConfigProperties(configProps);
        session.setOffline(this.isOffline());
        session.setUserProperties(this.project.getUserProperties());
        session.setProxySelector(this.getProxySelector());
        session.setMirrorSelector(this.getMirrorSelector());
        session.setAuthenticationSelector(this.getAuthSelector());
        session.setCache(new DefaultRepositoryCache());
        session.setRepositoryListener(new AntRepositoryListener(task));
        session.setTransferListener(new AntTransferListener(task));
        session.setLocalRepositoryManager(this.getLocalRepoMan(session, localRepo));
        session.setWorkspaceReader(ProjectWorkspaceReader.getInstance());
        return session;
    }

    private String getUserAgent() {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("Apache-Ant/").append(this.project.getProperty("ant.version"));
        buffer.append(" (");
        buffer.append("Java ").append(System.getProperty("java.version"));
        buffer.append("; ");
        buffer.append(System.getProperty("os.name")).append(" ").append(System.getProperty("os.version"));
        buffer.append(")");
        buffer.append(" Aether");
        return buffer.toString();
    }

    private boolean isOffline() {
        String prop = this.project.getProperty("resolver.offline");
        if (prop != null) {
            return Boolean.parseBoolean(prop);
        }
        return this.getSettings().isOffline();
    }

    private void processServerConfiguration(Map<Object, Object> configProps) {
        Settings settings = this.getSettings();
        for (Server server : settings.getServers()) {
            if (server.getConfiguration() != null) {
                Xpp3Dom dom = (Xpp3Dom)server.getConfiguration();
                for (int i = dom.getChildCount() - 1; i >= 0; --i) {
                    Xpp3Dom child = dom.getChild(i);
                    if ("wagonProvider".equals(child.getName())) {
                        dom.removeChild(i);
                        continue;
                    }
                    if (!"httpHeaders".equals(child.getName())) continue;
                    configProps.put("aether.connector.http.headers." + server.getId(), this.getHttpHeaders(child));
                }
                configProps.put("aether.connector.wagon.config." + server.getId(), dom);
            }
            configProps.put("aether.connector.perms.fileMode." + server.getId(), server.getFilePermissions());
            configProps.put("aether.connector.perms.dirMode." + server.getId(), server.getDirectoryPermissions());
        }
    }

    private Map<String, String> getHttpHeaders(Xpp3Dom dom) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (int i = 0; i < dom.getChildCount(); ++i) {
            Xpp3Dom child = dom.getChild(i);
            Xpp3Dom name = child.getChild("name");
            Xpp3Dom value = child.getChild("value");
            if (name == null || name.getValue() == null) continue;
            headers.put(name.getValue(), value != null ? value.getValue() : null);
        }
        return Collections.unmodifiableMap(headers);
    }

    private File getDefaultLocalRepoDir() {
        String dir = this.project.getProperty("maven.repo.local");
        if (dir != null) {
            return this.project.resolveFile(dir);
        }
        Settings settings = this.getSettings();
        if (settings.getLocalRepository() != null) {
            return new File(settings.getLocalRepository());
        }
        return new File(new File(this.project.getProperty("user.home"), ".m2"), "repository");
    }

    private LocalRepositoryManager getLocalRepoMan(RepositorySystemSession session, org.apache.maven.resolver.internal.ant.types.LocalRepository localRepo) {
        if (localRepo == null) {
            localRepo = this.localRepository;
        }
        File repoDir = localRepo != null && localRepo.getDir() != null ? localRepo.getDir() : this.getDefaultLocalRepoDir();
        LocalRepository repo = new LocalRepository(repoDir);
        return this.getSystem().newLocalRepositoryManager(session, repo);
    }

    private synchronized Settings getSettings() {
        if (this.settings == null) {
            DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
            request.setUserSettingsFile(this.getUserSettings());
            request.setGlobalSettingsFile(this.getGlobalSettings());
            request.setSystemProperties(this.getSystemProperties());
            request.setUserProperties(this.getUserProperties());
            try {
                this.settings = SETTINGS_BUILDER.build(request).getEffectiveSettings();
            }
            catch (SettingsBuildingException e) {
                this.project.log("Could not process settings.xml: " + e.getMessage(), (Throwable)e, 1);
            }
            SettingsDecryptionResult result = SETTINGS_DECRYPTER.decrypt(new DefaultSettingsDecryptionRequest(this.settings));
            this.settings.setServers(result.getServers());
            this.settings.setProxies(result.getProxies());
        }
        return this.settings;
    }

    private ProxySelector getProxySelector() {
        DefaultProxySelector selector = new DefaultProxySelector();
        for (org.apache.maven.resolver.internal.ant.types.Proxy proxy : this.proxies) {
            selector.add(ConverterUtils.toProxy(proxy), proxy.getNonProxyHosts());
        }
        Settings settings = this.getSettings();
        for (Proxy proxy : settings.getProxies()) {
            AuthenticationBuilder auth = new AuthenticationBuilder();
            auth.addUsername(proxy.getUsername()).addPassword(proxy.getPassword());
            selector.add(new org.apache.maven.resolver.internal.ant.org.eclipse.aether.repository.Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), auth.build()), proxy.getNonProxyHosts());
        }
        return selector;
    }

    private MirrorSelector getMirrorSelector() {
        DefaultMirrorSelector selector = new DefaultMirrorSelector();
        for (Mirror mirror : this.mirrors) {
            selector.add(mirror.getId(), mirror.getUrl(), mirror.getType(), false, mirror.getMirrorOf(), null);
        }
        Settings settings = this.getSettings();
        for (org.apache.maven.resolver.internal.ant.org.apache.maven.settings.Mirror mirror : settings.getMirrors()) {
            selector.add(String.valueOf(mirror.getId()), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        return selector;
    }

    private AuthenticationSelector getAuthSelector() {
        DefaultAuthenticationSelector selector = new DefaultAuthenticationSelector();
        HashSet<String> ids = new HashSet<String>();
        for (org.apache.maven.resolver.internal.ant.types.Authentication auth : this.authentications) {
            List<String> servers = auth.getServers();
            if (servers.isEmpty()) continue;
            Authentication a = ConverterUtils.toAuthentication(auth);
            for (String server : servers) {
                if (!ids.add(server)) continue;
                selector.add(server, a);
            }
        }
        Settings settings = this.getSettings();
        for (Server server : settings.getServers()) {
            AuthenticationBuilder auth = new AuthenticationBuilder();
            auth.addUsername(server.getUsername()).addPassword(server.getPassword());
            auth.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            selector.add(server.getId(), auth.build());
        }
        return new ConservativeAuthenticationSelector(selector);
    }

    private RemoteRepositories getRemoteRepositories() {
        RemoteRepositories remoteRepositories = new RemoteRepositories();
        remoteRepositories.setProject(this.project);
        Settings settings = this.getSettings();
        List<String> activeProfiles = settings.getActiveProfiles();
        for (String profileId : activeProfiles) {
            Profile profile = settings.getProfilesAsMap().get(profileId);
            for (Repository repository : profile.getRepositories()) {
                RemoteRepository.Policy policy;
                RepositoryPolicy repositoryPolicy;
                String id = repository.getId();
                org.apache.maven.resolver.internal.ant.types.RemoteRepository repo = new org.apache.maven.resolver.internal.ant.types.RemoteRepository();
                repo.setProject(this.project);
                repo.setId(id);
                repo.setUrl(repository.getUrl());
                if (repository.getReleases() != null) {
                    repositoryPolicy = repository.getReleases();
                    policy = new RemoteRepository.Policy();
                    policy.setEnabled(repositoryPolicy.isEnabled());
                    if (repositoryPolicy.getChecksumPolicy() != null) {
                        policy.setChecksums(repositoryPolicy.getChecksumPolicy());
                    }
                    if (repositoryPolicy.getUpdatePolicy() != null) {
                        policy.setUpdates(repositoryPolicy.getUpdatePolicy());
                    }
                    repo.addReleases(policy);
                }
                if (repository.getSnapshots() != null) {
                    repositoryPolicy = repository.getSnapshots();
                    policy = new RemoteRepository.Policy();
                    policy.setEnabled(repositoryPolicy.isEnabled());
                    if (repositoryPolicy.getChecksumPolicy() != null) {
                        policy.setChecksums(repositoryPolicy.getChecksumPolicy());
                    }
                    if (repositoryPolicy.getUpdatePolicy() != null) {
                        policy.setUpdates(repositoryPolicy.getUpdatePolicy());
                    }
                    repo.addSnapshots(policy);
                }
                this.project.addReference(id, (Object)repo);
                repo = new org.apache.maven.resolver.internal.ant.types.RemoteRepository();
                repo.setProject(this.project);
                repo.setRefid(new Reference(this.project, id));
                remoteRepositories.addRemoterepo(repo);
            }
        }
        return remoteRepositories;
    }

    private RemoteRepositories getMergedRepositories() {
        RemoteRepositories defaultRepositories = AetherUtils.getDefaultRepositories(this.project);
        RemoteRepositories settingsRepositories = this.getRemoteRepositories();
        RemoteRepositories mergedRepositories = new RemoteRepositories();
        mergedRepositories.setProject(this.project);
        mergedRepositories.addRemoterepos(defaultRepositories);
        mergedRepositories.addRemoterepos(settingsRepositories);
        return mergedRepositories;
    }

    public synchronized void setUserSettings(File file) {
        if (!AntRepoSys.eq(this.userSettings, file)) {
            this.settings = null;
        }
        this.userSettings = file;
    }

    File getUserSettings() {
        if (this.userSettings == null) {
            this.userSettings = AetherUtils.findUserSettings(this.project);
        }
        return this.userSettings;
    }

    public void setGlobalSettings(File file) {
        if (!AntRepoSys.eq(this.globalSettings, file)) {
            this.settings = null;
        }
        this.globalSettings = file;
    }

    File getGlobalSettings() {
        if (this.globalSettings == null) {
            this.globalSettings = AetherUtils.findGlobalSettings(this.project);
        }
        return this.globalSettings;
    }

    public void addProxy(org.apache.maven.resolver.internal.ant.types.Proxy proxy) {
        this.proxies.add(proxy);
    }

    public void addMirror(Mirror mirror) {
        this.mirrors.add(mirror);
    }

    public void addAuthentication(org.apache.maven.resolver.internal.ant.types.Authentication authentication) {
        this.authentications.add(authentication);
    }

    public void setLocalRepository(org.apache.maven.resolver.internal.ant.types.LocalRepository localRepository) {
        this.localRepository = localRepository;
    }

    public Model loadModel(Task task, File pomFile, boolean local, RemoteRepositories remoteRepositories) {
        RepositorySystemSession session = this.getSession(task, null);
        remoteRepositories = remoteRepositories == null ? this.getMergedRepositories() : remoteRepositories;
        List<RemoteRepository> repositories = ConverterUtils.toRepositories(task.getProject(), session, remoteRepositories, this.getRemoteRepoMan());
        AntModelResolver modelResolver = new AntModelResolver(session, "project", this.getSystem(), this.getRemoteRepoMan(), repositories);
        Settings settings = this.getSettings();
        try {
            DefaultModelBuildingRequest request = new DefaultModelBuildingRequest();
            request.setLocationTracking(true);
            request.setProcessPlugins(false);
            if (local) {
                request.setPomFile(pomFile);
                request.setValidationLevel(30);
            } else {
                request.setModelSource(new FileModelSource(pomFile));
                request.setValidationLevel(0);
            }
            request.setSystemProperties(this.getSystemProperties());
            request.setUserProperties(this.getUserProperties());
            request.setProfiles((List)SettingsUtils.convert(settings.getProfiles()));
            request.setActiveProfileIds((List)settings.getActiveProfiles());
            request.setModelResolver(modelResolver);
            return MODEL_BUILDER.build(request).getEffectiveModel();
        }
        catch (ModelBuildingException e) {
            throw new BuildException("Could not load POM " + pomFile + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private Properties getSystemProperties() {
        Properties props = new Properties();
        this.getEnvProperties(props);
        props.putAll((Map<?, ?>)System.getProperties());
        ConverterUtils.addProperties(props, this.project.getProperties());
        return props;
    }

    private Properties getEnvProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        boolean envCaseInsensitive = OS_WINDOWS;
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            String key = entry.getKey();
            if (envCaseInsensitive) {
                key = key.toUpperCase(Locale.ENGLISH);
            }
            key = "env." + key;
            props.put(key, entry.getValue());
        }
        return props;
    }

    private Properties getUserProperties() {
        return ConverterUtils.addProperties(null, this.project.getUserProperties());
    }

    public void setDefaultPom(Pom pom) {
        this.defaultPom = pom;
    }

    public Pom getDefaultPom() {
        return this.defaultPom;
    }

    public CollectResult collectDependencies(Task task, Dependencies dependencies, org.apache.maven.resolver.internal.ant.types.LocalRepository localRepository, RemoteRepositories remoteRepositories) {
        CollectResult result;
        RepositorySystemSession session = this.getSession(task, localRepository);
        remoteRepositories = remoteRepositories == null ? this.getMergedRepositories() : remoteRepositories;
        List<RemoteRepository> repos = ConverterUtils.toRepositories(this.project, session, remoteRepositories, this.getRemoteRepoMan());
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRequestContext("project");
        for (RemoteRepository repo : repos) {
            task.getProject().log("Using remote repository " + repo, 3);
            collectRequest.addRepository(repo);
        }
        if (dependencies != null) {
            this.populateCollectRequest(collectRequest, task, session, dependencies, Collections.emptyList());
        }
        task.getProject().log("Collecting dependencies", 3);
        try {
            result = this.getSystem().collectDependencies(session, collectRequest);
        }
        catch (DependencyCollectionException e) {
            throw new BuildException("Could not collect dependencies: " + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void populateCollectRequest(CollectRequest collectRequest, Task task, RepositorySystemSession session, Dependencies dependencies, List<org.apache.maven.resolver.internal.ant.types.Exclusion> exclusions) {
        List<org.apache.maven.resolver.internal.ant.types.Exclusion> globalExclusions = exclusions;
        if (!dependencies.getExclusions().isEmpty()) {
            globalExclusions = new ArrayList<org.apache.maven.resolver.internal.ant.types.Exclusion>(exclusions);
            globalExclusions.addAll(dependencies.getExclusions());
        }
        HashSet<String> ids = new HashSet<String>();
        for (DependencyContainer container : dependencies.getDependencyContainers()) {
            if (container instanceof org.apache.maven.resolver.internal.ant.types.Dependency) {
                org.apache.maven.resolver.internal.ant.types.Dependency dependency = (org.apache.maven.resolver.internal.ant.types.Dependency)container;
                ids.add(dependency.getVersionlessKey());
                collectRequest.addDependency(ConverterUtils.toDependency(dependency, globalExclusions, session));
                continue;
            }
            this.populateCollectRequest(collectRequest, task, session, (Dependencies)container, globalExclusions);
        }
        if (dependencies.getPom() != null) {
            Model model = dependencies.getPom().getModel(task);
            for (Dependency dependency : model.getDependencies()) {
                org.apache.maven.resolver.internal.ant.types.Dependency dependency2 = new org.apache.maven.resolver.internal.ant.types.Dependency();
                dependency2.setArtifactId(dependency.getArtifactId());
                dependency2.setClassifier(dependency.getClassifier());
                dependency2.setGroupId(dependency.getGroupId());
                dependency2.setScope(dependency.getScope());
                dependency2.setType(dependency.getType());
                dependency2.setVersion(dependency.getVersion());
                if (ids.contains(dependency2.getVersionlessKey())) {
                    this.project.log("Ignoring dependency " + dependency2.getVersionlessKey() + " from " + model.getId() + ", already declared locally", 3);
                    continue;
                }
                if (dependency.getSystemPath() != null && dependency.getSystemPath().length() > 0) {
                    dependency2.setSystemPath(task.getProject().resolveFile(dependency.getSystemPath()));
                }
                for (Exclusion exc : dependency.getExclusions()) {
                    org.apache.maven.resolver.internal.ant.types.Exclusion exclusion = new org.apache.maven.resolver.internal.ant.types.Exclusion();
                    exclusion.setGroupId(exc.getGroupId());
                    exclusion.setArtifactId(exc.getArtifactId());
                    exclusion.setClassifier("*");
                    exclusion.setExtension("*");
                    dependency2.addExclusion(exclusion);
                }
                collectRequest.addDependency(ConverterUtils.toDependency(dependency2, globalExclusions, session));
            }
        }
        if (dependencies.getFile() != null) {
            List<org.apache.maven.resolver.internal.ant.types.Dependency> deps = this.readDependencies(dependencies.getFile());
            for (org.apache.maven.resolver.internal.ant.types.Dependency dependency : deps) {
                if (ids.contains(dependency.getVersionlessKey())) {
                    this.project.log("Ignoring dependency " + dependency.getVersionlessKey() + " from " + dependencies.getFile() + ", already declared locally", 3);
                    continue;
                }
                collectRequest.addDependency(ConverterUtils.toDependency(dependency, globalExclusions, session));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<org.apache.maven.resolver.internal.ant.types.Dependency> readDependencies(File file) {
        ArrayList<org.apache.maven.resolver.internal.ant.types.Dependency> dependencies = new ArrayList<org.apache.maven.resolver.internal.ant.types.Dependency>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
            String line = reader.readLine();
            while (line != null) {
                int comment = line.indexOf(35);
                if (comment >= 0) {
                    line = line.substring(0, comment);
                }
                if ((line = line.trim()).length() > 0) {
                    org.apache.maven.resolver.internal.ant.types.Dependency dependency = new org.apache.maven.resolver.internal.ant.types.Dependency();
                    dependency.setCoords(line);
                    dependencies.add(dependency);
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new BuildException("Cannot read " + file, (Throwable)e);
        }
        return dependencies;
    }

    public void install(Task task, Pom pom, Artifacts artifacts) {
        RepositorySystemSession session = this.getSession(task, null);
        InstallRequest request = new InstallRequest();
        request.setArtifacts(this.toArtifacts(task, session, pom, artifacts));
        try {
            this.getSystem().install(session, request);
        }
        catch (InstallationException e) {
            throw new BuildException("Could not install artifacts: " + e.getMessage(), (Throwable)e);
        }
    }

    public void deploy(Task task, Pom pom, Artifacts artifacts, org.apache.maven.resolver.internal.ant.types.RemoteRepository releaseRepository, org.apache.maven.resolver.internal.ant.types.RemoteRepository snapshotRepository) {
        RepositorySystemSession session = this.getSession(task, null);
        DeployRequest request = new DeployRequest();
        request.setArtifacts(this.toArtifacts(task, session, pom, artifacts));
        boolean snapshot = request.getArtifacts().iterator().next().isSnapshot();
        org.apache.maven.resolver.internal.ant.types.RemoteRepository distRepo = snapshot && snapshotRepository != null ? snapshotRepository : releaseRepository;
        request.setRepository(ConverterUtils.toDistRepository(distRepo, session));
        try {
            this.getSystem().deploy(session, request);
        }
        catch (DeploymentException e) {
            throw new BuildException("Could not deploy artifacts: " + e.getMessage(), (Throwable)e);
        }
    }

    private List<org.apache.maven.resolver.internal.ant.org.eclipse.aether.artifact.Artifact> toArtifacts(Task task, RepositorySystemSession session, Pom pom, Artifacts artifacts) {
        Model model = pom.getModel(task);
        File pomFile = pom.getFile();
        ArrayList<org.apache.maven.resolver.internal.ant.org.eclipse.aether.artifact.Artifact> results = new ArrayList<org.apache.maven.resolver.internal.ant.org.eclipse.aether.artifact.Artifact>();
        org.apache.maven.resolver.internal.ant.org.eclipse.aether.artifact.Artifact pomArtifact = new DefaultArtifact(model.getGroupId(), model.getArtifactId(), "pom", model.getVersion()).setFile(pomFile);
        results.add(pomArtifact);
        for (Artifact artifact : artifacts.getArtifacts()) {
            org.apache.maven.resolver.internal.ant.org.eclipse.aether.artifact.Artifact buildArtifact = new DefaultArtifact(model.getGroupId(), model.getArtifactId(), artifact.getClassifier(), artifact.getType(), model.getVersion()).setFile(artifact.getFile());
            results.add(buildArtifact);
        }
        return results;
    }
}

