/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.resolver.internal.ant;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.resolver.internal.ant.org.apache.maven.model.ActivationOS;
import org.apache.maven.resolver.internal.ant.org.apache.maven.model.ActivationProperty;
import org.apache.maven.resolver.internal.ant.org.apache.maven.model.Profile;
import org.apache.maven.resolver.internal.ant.org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.resolver.internal.ant.org.apache.maven.settings.Activation;
import org.apache.maven.resolver.internal.ant.org.apache.maven.settings.ActivationFile;
import org.apache.maven.resolver.internal.ant.org.apache.maven.settings.Repository;

class SettingsUtils {
    SettingsUtils() {
    }

    public static List<Profile> convert(List<org.apache.maven.resolver.internal.ant.org.apache.maven.settings.Profile> profiles) {
        if (profiles == null) {
            return null;
        }
        ArrayList<Profile> results = new ArrayList<Profile>();
        for (org.apache.maven.resolver.internal.ant.org.apache.maven.settings.Profile profile : profiles) {
            results.add(SettingsUtils.convert(profile));
        }
        return results;
    }

    static Profile convert(org.apache.maven.resolver.internal.ant.org.apache.maven.settings.Profile profile) {
        if (profile == null) {
            return null;
        }
        Profile result = new Profile();
        result.setId(profile.getId());
        result.setProperties(profile.getProperties());
        result.setSource("settings.xml");
        result.setActivation(SettingsUtils.convert(profile.getActivation()));
        for (Repository repo : profile.getRepositories()) {
            result.addRepository(SettingsUtils.convert(repo));
        }
        for (Repository repo : profile.getPluginRepositories()) {
            result.addPluginRepository(SettingsUtils.convert(repo));
        }
        return result;
    }

    static org.apache.maven.resolver.internal.ant.org.apache.maven.model.Activation convert(Activation activation) {
        if (activation == null) {
            return null;
        }
        org.apache.maven.resolver.internal.ant.org.apache.maven.model.Activation result = new org.apache.maven.resolver.internal.ant.org.apache.maven.model.Activation();
        result.setActiveByDefault(activation.isActiveByDefault());
        result.setJdk(activation.getJdk());
        result.setFile(SettingsUtils.convert(activation.getFile()));
        result.setProperty(SettingsUtils.convert(activation.getProperty()));
        result.setOs(SettingsUtils.convert(activation.getOs()));
        return result;
    }

    static ActivationOS convert(org.apache.maven.resolver.internal.ant.org.apache.maven.settings.ActivationOS activation) {
        if (activation == null) {
            return null;
        }
        ActivationOS result = new ActivationOS();
        result.setArch(activation.getArch());
        result.setFamily(activation.getFamily());
        result.setName(activation.getName());
        result.setVersion(activation.getVersion());
        return result;
    }

    static ActivationProperty convert(org.apache.maven.resolver.internal.ant.org.apache.maven.settings.ActivationProperty activation) {
        if (activation == null) {
            return null;
        }
        ActivationProperty result = new ActivationProperty();
        result.setName(activation.getName());
        result.setValue(activation.getValue());
        return result;
    }

    static org.apache.maven.resolver.internal.ant.org.apache.maven.model.ActivationFile convert(ActivationFile activation) {
        if (activation == null) {
            return null;
        }
        org.apache.maven.resolver.internal.ant.org.apache.maven.model.ActivationFile result = new org.apache.maven.resolver.internal.ant.org.apache.maven.model.ActivationFile();
        result.setExists(activation.getExists());
        result.setMissing(activation.getMissing());
        return result;
    }

    static org.apache.maven.resolver.internal.ant.org.apache.maven.model.Repository convert(Repository repo) {
        if (repo == null) {
            return null;
        }
        org.apache.maven.resolver.internal.ant.org.apache.maven.model.Repository result = new org.apache.maven.resolver.internal.ant.org.apache.maven.model.Repository();
        result.setId(repo.getId());
        result.setUrl(repo.getUrl());
        result.setLayout(repo.getLayout());
        result.setReleases(SettingsUtils.convert(repo.getReleases()));
        result.setSnapshots(SettingsUtils.convert(repo.getSnapshots()));
        return result;
    }

    static RepositoryPolicy convert(org.apache.maven.resolver.internal.ant.org.apache.maven.settings.RepositoryPolicy policy) {
        if (policy == null) {
            return null;
        }
        RepositoryPolicy result = new RepositoryPolicy();
        result.setEnabled(policy.isEnabled());
        result.setChecksumPolicy(policy.getChecksumPolicy());
        result.setUpdatePolicy(policy.getUpdatePolicy());
        return result;
    }
}

