/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.resolver.internal.ant.org.apache.http.protocol;

import java.io.IOException;
import org.apache.maven.resolver.internal.ant.org.apache.http.HttpException;
import org.apache.maven.resolver.internal.ant.org.apache.http.HttpRequest;
import org.apache.maven.resolver.internal.ant.org.apache.http.HttpRequestInterceptor;
import org.apache.maven.resolver.internal.ant.org.apache.http.annotation.Contract;
import org.apache.maven.resolver.internal.ant.org.apache.http.annotation.ThreadingBehavior;
import org.apache.maven.resolver.internal.ant.org.apache.http.params.HttpParams;
import org.apache.maven.resolver.internal.ant.org.apache.http.protocol.HttpContext;
import org.apache.maven.resolver.internal.ant.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestUserAgent
implements HttpRequestInterceptor {
    private final String userAgent;

    public RequestUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public RequestUserAgent() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("User-Agent")) {
            String s = null;
            HttpParams params = request.getParams();
            if (params != null) {
                s = (String)params.getParameter("http.useragent");
            }
            if (s == null) {
                s = this.userAgent;
            }
            if (s != null) {
                request.addHeader("User-Agent", s);
            }
        }
    }
}

