// Code generated by go-swagger; DO NOT EDIT.

package global_network_manager_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewAgentDiscoverParams creates a new AgentDiscoverParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAgentDiscoverParams() *AgentDiscoverParams {
	return &AgentDiscoverParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAgentDiscoverParamsWithTimeout creates a new AgentDiscoverParams object
// with the ability to set a timeout on a request.
func NewAgentDiscoverParamsWithTimeout(timeout time.Duration) *AgentDiscoverParams {
	return &AgentDiscoverParams{
		timeout: timeout,
	}
}

// NewAgentDiscoverParamsWithContext creates a new AgentDiscoverParams object
// with the ability to set a context for a request.
func NewAgentDiscoverParamsWithContext(ctx context.Context) *AgentDiscoverParams {
	return &AgentDiscoverParams{
		Context: ctx,
	}
}

// NewAgentDiscoverParamsWithHTTPClient creates a new AgentDiscoverParams object
// with the ability to set a custom HTTPClient for a request.
func NewAgentDiscoverParamsWithHTTPClient(client *http.Client) *AgentDiscoverParams {
	return &AgentDiscoverParams{
		HTTPClient: client,
	}
}

/*
AgentDiscoverParams contains all the parameters to send to the API endpoint

	for the agent discover operation.

	Typically these are written to a http.Request.
*/
type AgentDiscoverParams struct {

	// Body.
	Body AgentDiscoverBody

	/* ID.

	   id is the name of the cluster
	*/
	ID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the agent discover params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AgentDiscoverParams) WithDefaults() *AgentDiscoverParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the agent discover params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AgentDiscoverParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the agent discover params
func (o *AgentDiscoverParams) WithTimeout(timeout time.Duration) *AgentDiscoverParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the agent discover params
func (o *AgentDiscoverParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the agent discover params
func (o *AgentDiscoverParams) WithContext(ctx context.Context) *AgentDiscoverParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the agent discover params
func (o *AgentDiscoverParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the agent discover params
func (o *AgentDiscoverParams) WithHTTPClient(client *http.Client) *AgentDiscoverParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the agent discover params
func (o *AgentDiscoverParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the agent discover params
func (o *AgentDiscoverParams) WithBody(body AgentDiscoverBody) *AgentDiscoverParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the agent discover params
func (o *AgentDiscoverParams) SetBody(body AgentDiscoverBody) {
	o.Body = body
}

// WithID adds the id to the agent discover params
func (o *AgentDiscoverParams) WithID(id string) *AgentDiscoverParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the agent discover params
func (o *AgentDiscoverParams) SetID(id string) {
	o.ID = id
}

// WithLocationOrganizationID adds the locationOrganizationID to the agent discover params
func (o *AgentDiscoverParams) WithLocationOrganizationID(locationOrganizationID string) *AgentDiscoverParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the agent discover params
func (o *AgentDiscoverParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the agent discover params
func (o *AgentDiscoverParams) WithLocationProjectID(locationProjectID string) *AgentDiscoverParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the agent discover params
func (o *AgentDiscoverParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *AgentDiscoverParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if err := r.SetBodyParam(o.Body); err != nil {
		return err
	}

	// path param id
	if err := r.SetPathParam("id", o.ID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
