/*
 *	largefile.h
 *
 *	presumely autoconf is not very reliable when it comes to largefile
 *	support. Therefore this here to ensure proper support 
 *	21.10.02 tn@xcdroast.org
 *
 *
 *  Copyright (C) 1995, 1996, 1997 Free Software Foundation, Inc.
 *
 *  This file is part of xcdroast.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

/* some defines to get large-file support */
#ifdef  USE_LARGEFILES

#define HAVE_LARGEFILES 1

#ifdef  HAVE_LARGEFILES         /* If we have working largefiles at all    */
                                /* This is not defined with glibc-2.1.3    */

#ifndef _FILE_OFFSET_BITS
#define _FILE_OFFSET_BITS 64    /* # of bits in off_t if settable          */
#endif
#define _LARGEFILE_SOURCE 1     /* To make ftello() visible (HP-UX 10.20). */
/* #undef _LARGE_FILES */       /* Large file defined on AIX-style hosts.  */
/* #undef _XOPEN_SOURCE */      /* To make ftello() visible (glibc 2.1.3). */
                                /* XXX We don't use this because glibc2.1.3*/
                                /* XXX is bad anyway. If we define         */
                                /* XXX _XOPEN_SOURCE we will loose caddr_t */

/* #undef HAVE_FSEEKO */        /* Do we need this? If HAVE_LARGEFILES is  */
                                /* defined, we have fseeko()               */

#endif  /* HAVE_LARGEFILES */
#endif  /* USE_LARGEFILES */

 
