/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.commands;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.rundeck.client.api.model.ExecRetry;
import org.rundeck.client.api.model.Execution;
import org.rundeck.client.api.model.JobFileUploadResult;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.commands.Executions;
import org.rundeck.client.tool.commands.Run;
import org.rundeck.client.tool.commands.jobs.Files;
import org.rundeck.client.tool.extension.BaseCommand;
import org.rundeck.client.tool.options.FollowOptions;
import org.rundeck.client.tool.options.RetryBaseOptions;
import picocli.CommandLine;

@CommandLine.Command(description={"Run a Job based on a specific execution."}, name="retry", showEndOfOptionsDelimiterInUsageHelp=true)
public class Retry
extends BaseCommand
implements Callable<Integer> {
    @CommandLine.Mixin
    RetryBaseOptions options;
    @CommandLine.Mixin
    FollowOptions followOptions;

    @Override
    public Integer call() throws IOException, InputError {
        this.getRdTool().requireApiVersion("retry", 24);
        String jobId = Run.getJobIdFromOpts(this.options, this.getRdOutput(), this.getRdTool(), () -> this.getRdTool().projectOrEnv(this.options));
        String execId = this.options.getEid();
        if (null == jobId) {
            return 2;
        }
        String loglevel = null != this.options.getLoglevel() ? this.options.getLoglevel().toString().toUpperCase() : null;
        ExecRetry request = new ExecRetry();
        request.setLoglevel(loglevel);
        request.setAsUser(this.options.getUser());
        request.setFailedNodes(Boolean.toString(this.options.isFailedNodes()));
        List<String> commandString = this.options.getCommandString();
        boolean rawOptions = this.options.isRawOptions();
        HashMap<String, String> jobopts = new HashMap<String, String>();
        HashMap<String, File> fileinputs = new HashMap<String, File>();
        String key = null;
        if (null != commandString) {
            boolean isfile = false;
            for (String part : commandString) {
                if (key == null && part.startsWith("-")) {
                    key = part.substring(1);
                    if (!key.endsWith("@")) continue;
                    key = key.substring(0, key.length() - 1);
                    isfile = true;
                    continue;
                }
                if (key == null) continue;
                String filepath = null;
                if (!rawOptions && part.charAt(0) == '@' && !isfile) {
                    filepath = part.substring(1);
                    isfile = true;
                }
                if (isfile) {
                    File file = new File(filepath != null ? filepath : part);
                    fileinputs.put(key, file);
                }
                jobopts.put(key, part);
                key = null;
                isfile = false;
            }
        }
        if (key != null) {
            throw new InputError(String.format("Incorrect job options, expected: \"-%s value\", but saw only \"-%s\"", key, key));
        }
        if (fileinputs.size() > 0) {
            File file;
            for (String optionName : fileinputs.keySet()) {
                file = (File)fileinputs.get(optionName);
                if (!Files.invalidInputFile(file)) continue;
                throw new InputError("File Option -" + optionName + ": File cannot be read: " + file);
            }
            for (String optionName : fileinputs.keySet()) {
                file = (File)fileinputs.get(optionName);
                JobFileUploadResult jobFileUploadResult = Files.uploadFileForJob(this.getRdTool(), file, jobId, optionName);
                String fileid = jobFileUploadResult.getFileIdForOption(optionName);
                jobopts.put(optionName, fileid);
                this.getRdOutput().info(String.format("File Upload OK (%s -> %s)", file, fileid));
            }
        }
        request.setOptions(jobopts);
        Execution execution = (Execution)this.apiCall(api -> api.retryJob(jobId, execId, request));
        String started = "started";
        this.getRdOutput().info(String.format("Execution %s: %s%n", started, execution.toBasicString()));
        return Executions.maybeFollow(this.getRdTool(), this.followOptions, this.options, execution.getId(), this.getRdOutput()) ? 0 : 1;
    }
}

