/*
	file automatically generated by make_test_files.pl
	Wed Mar 16 14:50:45 2022
*/

/*****************************************************************************
 *                                                                           *
 *          UNU.RAN -- Universal Non-Uniform Random number generator         *
 *                                                                           *
 *****************************************************************************/
    
/**
 ** Tests for VMT
 **/
    
/*---------------------------------------------------------------------------*/
#include "testunuran.h"

#ifdef UNUR_URNG_DEFAULT_RNGSTREAM
#include <RngStream.h>
#endif
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* global variables                                                          */

static FILE *TESTLOG;               /* test log file                         */
static FILE *UNURANLOG;             /* unuran log file                       */

static int test_ok = TRUE;          /* all tests ok (boolean)                */
static int fullcheck = FALSE;       /* whether all checks are performed      */ 

static TIMER watch;                 /* stop watch                            */

/*---------------------------------------------------------------------------*/

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par );

int unur_vmt_set_verify( UNUR_PAR *par, int verify);


/*---------------------------------------------------------------------------*/

void test_new (void);
void test_set (void);
void test_get (void);
void test_chg (void);
void test_init (void);
void test_reinit (void);
void test_sample (void);
void test_validate (void);
void test_special(void);

/*---------------------------------------------------------------------------*/



/* prototypes */

#define COMPARE_SAMPLE_SIZE   (10000)
#define VIOLATE_SAMPLE_SIZE   (20)

/* #define SEED   (298346) */

/* we need marginal distributions for the chi2 tests */
#define unur_distr_multicauchy   unur_distr_multicauchy_w_marginals
#define unur_distr_multinormal   unur_distr_multinormal_w_marginals
#define unur_distr_multistudent  unur_distr_multistudent_w_marginals





/*---------------------------------------------------------------------------*/

#ifndef CHI2_FAILURES_TOLERATED
#  define CHI2_FAILURES_TOLERATED DEFAULT_CHI2_FAILURES_TOLERATED
#endif

/*---------------------------------------------------------------------------*/
/* [verbatim] */



/*---------------------------------------------------------------------------*/
/* [new] */

void test_new (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[new "); fflush(stdout);
	fprintf(TESTLOG,"\n[new]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_DISTR *distr = NULL;
   distr = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,38,(unur_vmt_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,38,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* invalid distribution type */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_discr_new(); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,45,(unur_vmt_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,45,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* data missing in distribution object */
UNUR_DISTR *distr = NULL;
   double mean[] = {1.,2.};
   double covar[] = {2.,1., 1., 2.};
   distr = unur_distr_cvec_new(2); 


unur_reset_errno();
/* mean */
n_tests_failed += (check_expected_NULL(TESTLOG,55,(unur_vmt_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,55,UNUR_ERR_DISTR_REQUIRED)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* covariance matrix */
unur_distr_cvec_set_mean(distr,mean);
unur_distr_cvec_set_covar(distr,covar);
n_tests_failed += (check_expected_NULL(TESTLOG,61,(unur_vmt_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,61,UNUR_ERR_DISTR_REQUIRED)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_new() */

/*---------------------------------------------------------------------------*/
/* [reinit] */

void test_reinit (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[reinit "); fflush(stdout);
	fprintf(TESTLOG,"\n[reinit]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* exists */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   distr = unur_distr_multinormal(3,NULL,NULL);
   par = unur_vmt_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 86,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_reinit(TESTLOG,90,(unur_reinit( gen )))==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_reinit() */

/*---------------------------------------------------------------------------*/
/* [sample] */

void test_sample (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[sample "); fflush(stdout);
	fprintf(TESTLOG,"\n[sample]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* compare clone */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   const int dim = 3;
   double mean[] = {1.,2.,3.};
   double covar[] = { 2., 2., 1.,   2., 4., 3.,   1., 3., 3. };
   UNUR_GEN *clone;
   distr = unur_distr_multinormal( dim, mean, covar );
   par = unur_vmt_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 102,    gen );


unur_reset_errno();
/* normal distribution */;
n_tests_failed += (compare_sequence_gen_start(TESTLOG,106,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,112,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* compare clone */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   const int dim = 3;
   double mean[] = {1.,2.,3.};
   double covar[] = { 2., 2., 1.,   2., 4., 3.,   1., 3., 3. };
   double beta_params[] = {3.,5.};
   UNUR_GEN *clone;
   distr = unur_distr_cvec_new(dim);
   unur_distr_cvec_set_mean(distr,mean);
   unur_distr_cvec_set_covar(distr,covar);
   unur_distr_cvec_set_marginal_list(distr,
	unur_distr_normal(NULL,0),
	unur_distr_cauchy(NULL,0),
	unur_distr_beta(beta_params,2) );
   unur_distr_cvec_set_stdmarginal_list(distr,
	unur_distr_normal(NULL,0),
	unur_distr_cauchy(NULL,0),
	unur_distr_beta(beta_params,2) );
   par = unur_vmt_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 133,    gen );


unur_reset_errno();
/* multivariate distribution with given marginals */;
n_tests_failed += (compare_sequence_gen_start(TESTLOG,137,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,143,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* compare clone */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double mean[] = {1.,2.,3.};
   double covar[] = { 2., 2., 1.,   2., 4., 3.,   1., 3., 3. };
   double beta_params[] = {3.,5.};
   UNUR_DISTR *marginals[3];
   UNUR_GEN *clone;
   distr = unur_distr_cvec_new(3);
   unur_distr_cvec_set_mean(distr,mean);
   unur_distr_cvec_set_covar(distr,covar);
   marginals[0] = unur_distr_normal(NULL,0);
   marginals[1] = unur_distr_cauchy(NULL,0);
   marginals[2] = unur_distr_beta(beta_params,2);
   unur_distr_cvec_set_marginal_array(distr,marginals);
   unur_distr_cvec_set_stdmarginal_array(distr,marginals);
   unur_distr_free(marginals[0]);
   unur_distr_free(marginals[1]);
   unur_distr_free(marginals[2]);
   par = unur_vmt_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 164,    gen );


unur_reset_errno();
/* multivariate distribution with given marginals */;
n_tests_failed += (compare_sequence_gen_start(TESTLOG,168,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,174,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* compare clone 1dim */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   const int dim = 1;
   double mean[] = {1.};
   double covar[] = {2.};
   double beta_params[] = {3.,5.};
   UNUR_GEN *clone;
   distr = unur_distr_cvec_new(dim);
   unur_distr_cvec_set_mean(distr,mean);
   unur_distr_cvec_set_covar(distr,covar);
   unur_distr_cvec_set_marginal_list(distr,
	unur_distr_beta(beta_params,2) );
   unur_distr_cvec_set_stdmarginal_list(distr,
	unur_distr_beta(beta_params,2) );
   par = unur_vmt_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 191,    gen );


unur_reset_errno();
/* multivariate distribution with given marginals */;
n_tests_failed += (compare_sequence_gen_start(TESTLOG,195,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,201,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* compare clone 1dim */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double mean[] = {1.};
   double covar[] = {2.};
   double beta_params[] = {3.,5.};
   UNUR_DISTR *marginals[1];
   UNUR_GEN *clone;
   distr = unur_distr_cvec_new(1);
   unur_distr_cvec_set_mean(distr,mean);
   unur_distr_cvec_set_covar(distr,covar);
   marginals[0] = unur_distr_beta(beta_params,2);
   unur_distr_cvec_set_marginal_array(distr,marginals);
   unur_distr_cvec_set_stdmarginal_array(distr,marginals);
   unur_distr_free(marginals[0]);
   par = unur_vmt_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 218,    gen );


unur_reset_errno();
/* multivariate distribution with given marginals */;
n_tests_failed += (compare_sequence_gen_start(TESTLOG,222,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,228,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* compare reinit */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   distr = unur_distr_multinormal(3,NULL,NULL);
   par = NULL;
   gen = NULL; 


unur_reset_errno();
/* original generator object */
par = unur_vmt_new(distr);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,240,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* reinit */
unur_reinit(gen);
n_tests_failed += (compare_sequence_gen(TESTLOG,244,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* set domain and compare clone */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   const int dim = 3;
   double mean[] = {1.,2.,3.};
   double covar[] = { 2., 2., 1.,   2., 4., 3.,   1., 3., 3. };
   double ll[] = {0.,0.,0.};
   double ru[] = {UNUR_INFINITY, 1., 2.};
   UNUR_GEN *clone;
   distr = unur_distr_multinormal( dim, mean, covar );
   unur_distr_cvec_set_domain_rect( distr, ll, ru );
   par = unur_vmt_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 257,    gen );


unur_reset_errno();
/* normal distribution */;
n_tests_failed += (compare_sequence_gen_start(TESTLOG,261,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,267,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_sample() */

/*---------------------------------------------------------------------------*/
/* [validate] */

/*---------------------------------------------------------------------------*/

/* [validate] */

void test_validate (void)
{
	/* suppress GCC compiler warning */
GCC_DIAG_OFF(unused-variable)

	UNUR_DISTR *distr[33];
	UNUR_PAR *par;
	UNUR_GEN *gen;
	double *darray;
	double fpm[10];
	int n_tests_failed;
	int rcode;

	/* start test */
	printf("[validate "); fflush(stdout);
	fprintf(TESTLOG,"\n[validate]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);


/* distributions: 33 */
{
distr[0] = unur_distr_multinormal(3,NULL,NULL);
}

{
double mean[]  = { 1., 2., 3. };
double covar[] = { 2., 2., 1.,   2., 4., 3.,   1., 3., 3. };
distr[1] = unur_distr_multinormal(3,mean,covar);
}

{
double ll[3] = {0.,0.,0.};
double ru[3] = {UNUR_INFINITY,UNUR_INFINITY,UNUR_INFINITY};
distr[30] = unur_distr_multinormal(3,NULL,NULL);
unur_distr_cvec_set_domain_rect(distr[30],ll,ru);
}

{
double ll[3] = {0.,0.,0.};
double ru[3] = {1.,UNUR_INFINITY,UNUR_INFINITY};
distr[31] = unur_distr_multinormal(3,NULL,NULL);
unur_distr_cvec_set_domain_rect(distr[31],ll,ru);
}

{
double ll[3] = {-1.,-1.,1.};
double ru[3] = {1.,0.,2.};
distr[32] = unur_distr_multinormal(3,NULL,NULL);
unur_distr_cvec_set_domain_rect(distr[32],ll,ru);
}

{
#define dim (2)
int i;
double mean[dim], covar[dim*dim];
UNUR_DISTR *covar_distr;
UNUR_GEN *covar_gen;
UNUR_GEN *mean_gen;
covar_distr = unur_distr_correlation(dim);
covar_gen = unur_init(unur_mcorr_new(covar_distr));
mean_gen = unur_str2gen("normal(5,1)");
for (i=0; i<dim; i++) 
   mean[i] = unur_sample_cont(mean_gen);
do { 
   unur_sample_matr(covar_gen,covar);
   distr[2] = unur_distr_multinormal(dim,mean,covar); 
} while (distr[2]==NULL);
unur_distr_free(covar_distr);
unur_free(covar_gen);
unur_free(mean_gen); 
#undef dim
}

{
#define dim (3)
int i;
double mean[dim], covar[dim*dim];
UNUR_DISTR *covar_distr;
UNUR_GEN *covar_gen;
UNUR_GEN *mean_gen;
covar_distr = unur_distr_correlation(dim);
covar_gen = unur_init(unur_mcorr_new(covar_distr));
mean_gen = unur_str2gen("normal(5,1)");
for (i=0; i<dim; i++) 
   mean[i] = unur_sample_cont(mean_gen);
do { 
   unur_sample_matr(covar_gen,covar);
   distr[3] = unur_distr_multinormal(dim,mean,covar); 
} while (distr[3]==NULL);
unur_distr_free(covar_distr);
unur_free(covar_gen);
unur_free(mean_gen); 
#undef dim
}

{
#define dim (4)
int i;
double mean[dim], covar[dim*dim];
UNUR_DISTR *covar_distr;
UNUR_GEN *covar_gen;
UNUR_GEN *mean_gen;
covar_distr = unur_distr_correlation(dim);
covar_gen = unur_init(unur_mcorr_new(covar_distr));
mean_gen = unur_str2gen("normal(5,1)");
for (i=0; i<dim; i++) 
   mean[i] = unur_sample_cont(mean_gen);
do { 
   unur_sample_matr(covar_gen,covar);
   distr[4] = unur_distr_multinormal(dim,mean,covar); 
} while (distr[4]==NULL);
unur_distr_free(covar_distr);
unur_free(covar_gen);
unur_free(mean_gen); 
#undef dim
}

{
#define dim (5)
int i;
double mean[dim], covar[dim*dim];
UNUR_DISTR *covar_distr;
UNUR_GEN *covar_gen;
UNUR_GEN *mean_gen;
covar_distr = unur_distr_correlation(dim);
covar_gen = unur_init(unur_mcorr_new(covar_distr));
mean_gen = unur_str2gen("normal(5,1)");
for (i=0; i<dim; i++) 
   mean[i] = unur_sample_cont(mean_gen);
do { 
   unur_sample_matr(covar_gen,covar);
   distr[5] = unur_distr_multinormal(dim,mean,covar); 
} while (distr[5]==NULL);
unur_distr_free(covar_distr);
unur_free(covar_gen);
unur_free(mean_gen); 
#undef dim
}

{
#define dim (7)
int i;
double mean[dim], covar[dim*dim];
UNUR_DISTR *covar_distr;
UNUR_GEN *covar_gen;
UNUR_GEN *mean_gen;
covar_distr = unur_distr_correlation(dim);
covar_gen = unur_init(unur_mcorr_new(covar_distr));
mean_gen = unur_str2gen("normal(5,1)");
for (i=0; i<dim; i++) 
   mean[i] = unur_sample_cont(mean_gen);
do { 
   unur_sample_matr(covar_gen,covar);
   distr[6] = unur_distr_multinormal(dim,mean,covar); 
} while (distr[6]==NULL);
unur_distr_free(covar_distr);
unur_free(covar_gen);
unur_free(mean_gen); 
#undef dim
}

{
#define dim (10)
int i;
double mean[dim], covar[dim*dim];
UNUR_DISTR *covar_distr;
UNUR_GEN *covar_gen;
UNUR_GEN *mean_gen;
covar_distr = unur_distr_correlation(dim);
covar_gen = unur_init(unur_mcorr_new(covar_distr));
mean_gen = unur_str2gen("normal(5,1)");
for (i=0; i<dim; i++) 
   mean[i] = unur_sample_cont(mean_gen);
do { 
   unur_sample_matr(covar_gen,covar);
   distr[7] = unur_distr_multinormal(dim,mean,covar); 
} while (distr[7]==NULL);
unur_distr_free(covar_distr);
unur_free(covar_gen);
unur_free(mean_gen); 
#undef dim
}

{
#define dim (15)
int i;
double mean[dim], covar[dim*dim];
UNUR_DISTR *covar_distr;
UNUR_GEN *covar_gen;
UNUR_GEN *mean_gen;
covar_distr = unur_distr_correlation(dim);
covar_gen = unur_init(unur_mcorr_new(covar_distr));
mean_gen = unur_str2gen("normal(5,1)");
for (i=0; i<dim; i++) 
   mean[i] = unur_sample_cont(mean_gen);
do { 
   unur_sample_matr(covar_gen,covar);
   distr[8] = unur_distr_multinormal(dim,mean,covar); 
} while (distr[8]==NULL);
unur_distr_free(covar_distr);
unur_free(covar_gen);
unur_free(mean_gen); 
#undef dim
}

{
#define dim (20)
int i;
double mean[dim], covar[dim*dim];
UNUR_DISTR *covar_distr;
UNUR_GEN *covar_gen;
UNUR_GEN *mean_gen;
covar_distr = unur_distr_correlation(dim);
covar_gen = unur_init(unur_mcorr_new(covar_distr));
mean_gen = unur_str2gen("normal(5,1)");
for (i=0; i<dim; i++) 
   mean[i] = unur_sample_cont(mean_gen);
do { 
   unur_sample_matr(covar_gen,covar);
   distr[9] = unur_distr_multinormal(dim,mean,covar); 
} while (distr[9]==NULL);
unur_distr_free(covar_distr);
unur_free(covar_gen);
unur_free(mean_gen); 
#undef dim
}

{
#define dim (100)
int i;
double mean[dim], covar[dim*dim];
UNUR_DISTR *covar_distr;
UNUR_GEN *covar_gen;
UNUR_GEN *mean_gen;
covar_distr = unur_distr_correlation(dim);
covar_gen = unur_init(unur_mcorr_new(covar_distr));
mean_gen = unur_str2gen("normal(5,1)");
for (i=0; i<dim; i++) 
   mean[i] = unur_sample_cont(mean_gen);
do { 
   unur_sample_matr(covar_gen,covar);
   distr[10] = unur_distr_multinormal(dim,mean,covar); 
} while (distr[10]==NULL);
unur_distr_free(covar_distr);
unur_free(covar_gen);
unur_free(mean_gen); 
#undef dim
}

{
#define dim (100)
distr[26] = unur_distr_multinormal_ar1(dim,NULL,0.5);
#undef dim
}

{
#define dim (100)
distr[27] = unur_distr_multinormal_ar1(dim,NULL,0.9);
#undef dim
}

{
#define dim (100)
distr[28] = unur_distr_multinormal_ar1(dim,NULL,0.99);
#undef dim
}

{
#define dim (100)
distr[29] = unur_distr_multinormal_ar1(dim,NULL,0.999);
#undef dim
}

{
#define dim (5)
double beta_params[2] = {5.,3.};
double gamma_params[1] = {7.};
int i;
double mean[dim], covar[dim*dim];
UNUR_DISTR *covar_distr;
UNUR_GEN *covar_gen;
UNUR_GEN *mean_gen;
covar_distr = unur_distr_correlation(dim);
covar_gen = unur_init(unur_mcorr_new(covar_distr));
mean_gen = unur_str2gen("normal(5,1)");
distr[11] = unur_distr_cvec_new(dim);
for (i=0; i<dim; i++) 
   mean[i] = unur_sample_cont(mean_gen);
unur_distr_cvec_set_mean(distr[11],mean);
do { 
   unur_sample_matr(covar_gen,covar);
} while (unur_distr_cvec_set_covar(distr[11],covar) != UNUR_SUCCESS);
unur_distr_cvec_set_marginal_list(distr[11],
	unur_distr_normal(NULL,0),
	unur_distr_cauchy(NULL,0),
	unur_distr_exponential(NULL,0),
	unur_distr_beta(beta_params,2),
	unur_distr_gamma(gamma_params,1));
unur_distr_cvec_set_stdmarginal_list(distr[11],
	unur_distr_normal(NULL,0),
	unur_distr_cauchy(NULL,0),
	unur_distr_exponential(NULL,0),
	unur_distr_beta(beta_params,2),
	unur_distr_gamma(gamma_params,1));
unur_distr_set_name(distr[11],"non-normal");
unur_distr_free(covar_distr);
unur_free(covar_gen);
unur_free(mean_gen); 
#undef dim
}

{
distr[12] = unur_distr_multinormal(1,NULL,NULL);
}

{
#define dim (1)
int i;
double mean[dim], covar[dim*dim];
UNUR_DISTR *covar_distr;
UNUR_GEN *covar_gen;
UNUR_GEN *mean_gen;
covar_distr = unur_distr_correlation(dim);
covar_gen = unur_init(unur_mcorr_new(covar_distr));
mean_gen = unur_str2gen("normal(5,1)");
for (i=0; i<dim; i++) 
   mean[i] = unur_sample_cont(mean_gen);
do { 
   unur_sample_matr(covar_gen,covar);
   distr[13] = unur_distr_multinormal(dim,mean,covar); 
} while (distr[13]==NULL);
unur_distr_free(covar_distr);
unur_free(covar_gen);
unur_free(mean_gen); 
#undef dim
}

{
#define dim (2)
double covar[] = { 2., 1.,  1., 3. };
distr[14] = unur_distr_cvec_new(dim);
unur_distr_cvec_set_covar(distr[14],covar);
unur_distr_cvec_set_mean(distr[14],NULL);
unur_distr_cvec_set_marginal_list(distr[14],
  unur_distr_normal(NULL,0),
  unur_distr_cont_new() );
unur_distr_cvec_set_stdmarginal_list(distr[14],
  unur_distr_normal(NULL,0),
  unur_distr_cont_new() );
unur_distr_set_name(distr[14],"no_marginal_generator");
#undef dim
}

{
distr[15] = unur_distr_multicauchy(3,NULL,NULL);
}

{
double mean[]  = { 1., 2., 3. };
double covar[] = { 2., 2., 1.,   2., 4., 3.,   1., 3., 3. };
distr[16] = unur_distr_multicauchy(3,mean,covar);
}

{
#define dim (2)
int i;
double mean[dim], covar[dim*dim];
UNUR_DISTR *covar_distr;
UNUR_GEN *covar_gen;
UNUR_GEN *mean_gen;
covar_distr = unur_distr_correlation(dim);
covar_gen = unur_init(unur_mcorr_new(covar_distr));
mean_gen = unur_str2gen("normal(5,1)");
for (i=0; i<dim; i++) 
   mean[i] = unur_sample_cont(mean_gen);
do { 
   unur_sample_matr(covar_gen,covar);
   distr[17] = unur_distr_multicauchy(dim,mean,covar); 
} while (distr[17]==NULL);
unur_distr_free(covar_distr);
unur_free(covar_gen);
unur_free(mean_gen); 
#undef dim
}

{
#define dim (3)
int i;
double mean[dim], covar[dim*dim];
UNUR_DISTR *covar_distr;
UNUR_GEN *covar_gen;
UNUR_GEN *mean_gen;
covar_distr = unur_distr_correlation(dim);
covar_gen = unur_init(unur_mcorr_new(covar_distr));
mean_gen = unur_str2gen("normal(5,1)");
for (i=0; i<dim; i++) 
   mean[i] = unur_sample_cont(mean_gen);
do { 
   unur_sample_matr(covar_gen,covar);
   distr[18] = unur_distr_multicauchy(dim,mean,covar); 
} while (distr[18]==NULL);
unur_distr_free(covar_distr);
unur_free(covar_gen);
unur_free(mean_gen); 
#undef dim
}

{
#define dim (4)
int i;
double mean[dim], covar[dim*dim];
UNUR_DISTR *covar_distr;
UNUR_GEN *covar_gen;
UNUR_GEN *mean_gen;
covar_distr = unur_distr_correlation(dim);
covar_gen = unur_init(unur_mcorr_new(covar_distr));
mean_gen = unur_str2gen("normal(5,1)");
for (i=0; i<dim; i++) 
   mean[i] = unur_sample_cont(mean_gen);
do { 
   unur_sample_matr(covar_gen,covar);
   distr[19] = unur_distr_multicauchy(dim,mean,covar); 
} while (distr[19]==NULL);
unur_distr_free(covar_distr);
unur_free(covar_gen);
unur_free(mean_gen); 
#undef dim
}

{
#define dim (5)
int i;
double mean[dim], covar[dim*dim];
UNUR_DISTR *covar_distr;
UNUR_GEN *covar_gen;
UNUR_GEN *mean_gen;
covar_distr = unur_distr_correlation(dim);
covar_gen = unur_init(unur_mcorr_new(covar_distr));
mean_gen = unur_str2gen("normal(5,1)");
for (i=0; i<dim; i++) 
   mean[i] = unur_sample_cont(mean_gen);
do { 
   unur_sample_matr(covar_gen,covar);
   distr[20] = unur_distr_multicauchy(dim,mean,covar); 
} while (distr[20]==NULL);
unur_distr_free(covar_distr);
unur_free(covar_gen);
unur_free(mean_gen); 
#undef dim
}

{
#define dim (7)
int i;
double mean[dim], covar[dim*dim];
UNUR_DISTR *covar_distr;
UNUR_GEN *covar_gen;
UNUR_GEN *mean_gen;
covar_distr = unur_distr_correlation(dim);
covar_gen = unur_init(unur_mcorr_new(covar_distr));
mean_gen = unur_str2gen("normal(5,1)");
for (i=0; i<dim; i++) 
   mean[i] = unur_sample_cont(mean_gen);
do { 
   unur_sample_matr(covar_gen,covar);
   distr[21] = unur_distr_multicauchy(dim,mean,covar); 
} while (distr[21]==NULL);
unur_distr_free(covar_distr);
unur_free(covar_gen);
unur_free(mean_gen); 
#undef dim
}

{
#define dim (10)
int i;
double mean[dim], covar[dim*dim];
UNUR_DISTR *covar_distr;
UNUR_GEN *covar_gen;
UNUR_GEN *mean_gen;
covar_distr = unur_distr_correlation(dim);
covar_gen = unur_init(unur_mcorr_new(covar_distr));
mean_gen = unur_str2gen("normal(5,1)");
for (i=0; i<dim; i++) 
   mean[i] = unur_sample_cont(mean_gen);
do { 
   unur_sample_matr(covar_gen,covar);
   distr[22] = unur_distr_multicauchy(dim,mean,covar); 
} while (distr[22]==NULL);
unur_distr_free(covar_distr);
unur_free(covar_gen);
unur_free(mean_gen); 
#undef dim
}

{
#define dim (15)
int i;
double mean[dim], covar[dim*dim];
UNUR_DISTR *covar_distr;
UNUR_GEN *covar_gen;
UNUR_GEN *mean_gen;
covar_distr = unur_distr_correlation(dim);
covar_gen = unur_init(unur_mcorr_new(covar_distr));
mean_gen = unur_str2gen("normal(5,1)");
for (i=0; i<dim; i++) 
   mean[i] = unur_sample_cont(mean_gen);
do { 
   unur_sample_matr(covar_gen,covar);
   distr[23] = unur_distr_multicauchy(dim,mean,covar); 
} while (distr[23]==NULL);
unur_distr_free(covar_distr);
unur_free(covar_gen);
unur_free(mean_gen); 
#undef dim
}

{
#define dim (20)
int i;
double mean[dim], covar[dim*dim];
UNUR_DISTR *covar_distr;
UNUR_GEN *covar_gen;
UNUR_GEN *mean_gen;
covar_distr = unur_distr_correlation(dim);
covar_gen = unur_init(unur_mcorr_new(covar_distr));
mean_gen = unur_str2gen("normal(5,1)");
for (i=0; i<dim; i++) 
   mean[i] = unur_sample_cont(mean_gen);
do { 
   unur_sample_matr(covar_gen,covar);
   distr[24] = unur_distr_multicauchy(dim,mean,covar); 
} while (distr[24]==NULL);
unur_distr_free(covar_distr);
unur_free(covar_gen);
unur_free(mean_gen); 
#undef dim
}

{
#define dim (100)
int i;
double mean[dim], covar[dim*dim];
UNUR_DISTR *covar_distr;
UNUR_GEN *covar_gen;
UNUR_GEN *mean_gen;
covar_distr = unur_distr_correlation(dim);
covar_gen = unur_init(unur_mcorr_new(covar_distr));
mean_gen = unur_str2gen("normal(5,1)");
for (i=0; i<dim; i++) 
   mean[i] = unur_sample_cont(mean_gen);
do { 
   unur_sample_matr(covar_gen,covar);
   distr[25] = unur_distr_multicauchy(dim,mean,covar); 
} while (distr[25]==NULL);
unur_distr_free(covar_distr);
unur_free(covar_gen);
unur_free(mean_gen); 
#undef dim
}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>setup time = %.3f ms\n", stopwatch_lap(&watch));

	printf("\n(chi^2) "); fflush(stdout);

/* chi^2 tests: 66 */

	unur_set_default_debug(~UNUR_DEBUG_SAMPLE);
	fprintf( TESTLOG,"\nChi^2 Test:\n");

/* distribution [0] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
{ UNUR_DISTR *dg =NULL;
double mean[]  = { -1., 2., -3. };
double covar[] = { 2., 2., 0.9,   2., 4., 3.,   0.9, 3., 3. };
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cvec_set_mean(dg,mean);
unur_distr_cvec_set_covar(dg,covar);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [1] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
{ UNUR_DISTR *dg =NULL;
double mean[]  = { -1., 2., -3. };
double covar[] = { 2., 2., 0.9,   2., 4., 3.,   0.9, 3., 3. };
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cvec_set_mean(dg,mean);
unur_distr_cvec_set_covar(dg,covar);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [2] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [3] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
{ UNUR_DISTR *dg =NULL;
double mean[]  = { -1., 2., -3. };
double covar[] = { 2., 2., 0.9,   2., 4., 3.,   0.9, 3., 3. };
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cvec_set_mean(dg,mean);
unur_distr_cvec_set_covar(dg,covar);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [4] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [5] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [6] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [7] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [8] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [9] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [10] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [26] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [27] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [28] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [29] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [11] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [12] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [13] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [14] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [15] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
{ UNUR_DISTR *dg =NULL;
double mean[]  = { -1., 2., -3. };
double covar[] = { 2., 2., 0.9,   2., 4., 3.,   0.9, 3., 3. };
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cvec_set_mean(dg,mean);
unur_distr_cvec_set_covar(dg,covar);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [16] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
{ UNUR_DISTR *dg =NULL;
double mean[]  = { -1., 2., -3. };
double covar[] = { 2., 2., 0.9,   2., 4., 3.,   0.9, 3., 3. };
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cvec_set_mean(dg,mean);
unur_distr_cvec_set_covar(dg,covar);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [17] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [18] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
{ UNUR_DISTR *dg =NULL;
double mean[]  = { -1., 2., -3. };
double covar[] = { 2., 2., 0.9,   2., 4., 3.,   0.9, 3., 3. };
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cvec_set_mean(dg,mean);
unur_distr_cvec_set_covar(dg,covar);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [19] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [20] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [21] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [22] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [23] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [24] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [25] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [30] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
{ UNUR_DISTR *dg =NULL;
double mean[]  = { -1., 2., -3. };
double covar[] = { 2., 2., 0.9,   2., 4., 3.,   0.9, 3., 3. };
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cvec_set_mean(dg,mean);
unur_distr_cvec_set_covar(dg,covar);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'-');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [31] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[31]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[31],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [32] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[32]);
par = unur_vmt_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[32],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.0f ms\n", stopwatch_lap(&watch));


/* free distributions */
	unur_distr_free(distr[0]);
	unur_distr_free(distr[1]);
	unur_distr_free(distr[2]);
	unur_distr_free(distr[3]);
	unur_distr_free(distr[4]);
	unur_distr_free(distr[5]);
	unur_distr_free(distr[6]);
	unur_distr_free(distr[7]);
	unur_distr_free(distr[8]);
	unur_distr_free(distr[9]);
	unur_distr_free(distr[10]);
	unur_distr_free(distr[11]);
	unur_distr_free(distr[12]);
	unur_distr_free(distr[13]);
	unur_distr_free(distr[14]);
	unur_distr_free(distr[15]);
	unur_distr_free(distr[16]);
	unur_distr_free(distr[17]);
	unur_distr_free(distr[18]);
	unur_distr_free(distr[19]);
	unur_distr_free(distr[20]);
	unur_distr_free(distr[21]);
	unur_distr_free(distr[22]);
	unur_distr_free(distr[23]);
	unur_distr_free(distr[24]);
	unur_distr_free(distr[25]);
	unur_distr_free(distr[26]);
	unur_distr_free(distr[27]);
	unur_distr_free(distr[28]);
	unur_distr_free(distr[29]);
	unur_distr_free(distr[30]);
	unur_distr_free(distr[31]);
	unur_distr_free(distr[32]);

	/* test finished */
	test_ok &= (n_tests_failed>CHI2_FAILURES_TOLERATED) ? 0 : 1;
	/* we accept CHI2_FAILURES_TOLERATED failures */
	(n_tests_failed>CHI2_FAILURES_TOLERATED) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_validate */

/* enable GCC compiler warning */
GCC_DIAG_ON(unused-variable)


/*---------------------------------------------------------------------------*/
/* run generator in verifying mode */

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par )
{
	UNUR_GEN *gen;
	int i;

	/* switch to verifying mode */
	unur_vmt_set_verify(par,1);

	/* initialize generator */
	gen = unur_init( par ); abort_if_NULL(LOG, line, gen);

	/* run generator */
	for (i=0; i<VIOLATE_SAMPLE_SIZE; i++)
		unur_sample_cont(gen);

	/* destroy generator */
	unur_free(gen); 

} /* end of run_verify_generator() */

int unur_vmt_set_verify(UNUR_PAR *par ATTRIBUTE__UNUSED, int verify ATTRIBUTE__UNUSED) {return 0;}

/*---------------------------------------------------------------------------*/

int main(void)
{ 
        unsigned long seed;
	char *str_seed, *str_tail;

	/* start stop watch */
	stopwatch_init();
	stopwatch_start(&watch);

        /* open log file for unuran and set output stream for unuran messages */
        UNURANLOG = fopen( "t_deprecated_vmt_unuran.log","w" );
        abort_if_NULL( stderr,-1, UNURANLOG );
        unur_set_stream( UNURANLOG );

        /* open log file for testing */
	TESTLOG = fopen( "t_deprecated_vmt_test.log","w" );
	abort_if_NULL( stderr,-1, TESTLOG );

        /* seed for uniform generators */

	/* seed set by environment */
	str_seed = getenv("SEED");

	if (str_seed != NULL) {
	    seed = strtol(str_seed, &str_tail, 10);
	    if (seed == 0u) 
		seed = 286732;
	}
	else {
#ifdef SEED
	    seed = SEED;
#else
	    seed = 286732;
#endif
	}

        /* seed build-in uniform generators */
        unur_urng_MRG31k3p_seed(NULL,seed);
        unur_urng_fish_seed(NULL,seed);
	unur_urng_mstd_seed(NULL,seed);

	/* seed uniform random number generator */
#ifdef UNUR_URNG_UNURAN
#  ifdef UNUR_URNG_DEFAULT_RNGSTREAM
	{
	        unsigned long sa[6];
	        int i;
	        for (i=0; i<6; i++) sa[i] = seed;
                RngStream_SetPackageSeed(sa);
        }
#  else
	if (unur_urng_seed(NULL,seed) != UNUR_SUCCESS) {
	        fprintf(stderr,"WARNING: Seed could not be set at random\n");
                seed = ~0u;
	}
#  endif  /* UNUR_URNG_DEFAULT_RNGSTREAM */
#endif  /* UNUR_URNG_UNURAN */
 
	/* set default debugging flag */
	unur_set_default_debug(UNUR_DEBUG_ALL);

        /* detect required check mode */
        fullcheck = (getenv("UNURANFULLCHECK")==NULL) ? FALSE : TRUE;

	/* write header into log file */
        print_test_log_header( TESTLOG, seed, fullcheck );

	/* set timer for sending SIGALRM signal */
	set_alarm(TESTLOG);

	/* start test */
	printf("vmt: ");

	/* run tests */
test_new();
test_reinit();
test_sample();
test_validate();


	/* test finished */
	printf("\n");  fflush(stdout);

	/* close log files */
	fprintf(TESTLOG,"\n====================================================\n\n");
	if (test_ok)
		fprintf(TESTLOG,"All tests PASSED.\n");
	else
		fprintf(TESTLOG,"Test(s) FAILED.\n");

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>total time = %.0f ms\n\n", stopwatch_stop(&watch));

	fclose(UNURANLOG);
	fclose(TESTLOG);

	/* free memory */
	compare_free_memory();
	unur_urng_free(unur_get_default_urng());
	unur_urng_free(unur_get_default_urng_aux());

	/* exit */
	exit( (test_ok) ? EXIT_SUCCESS : EXIT_FAILURE );

} /* end of main */

