// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#include "Fish.h"




// *******************
// *** CONSTRUCTOR ***
// *******************
FS::Fish::Fish()
{
    x = fish_x_c;
    y = fish_y_c;
    width = fish_w_c;
    height = fish_h_c;
    
    coll_box_x_offset = COLL_BOX_X_OFFSET;
    coll_box_y_offset = COLL_BOX_Y_OFFSET;
            
    coll_box.w = COLL_BOX_WIDTH;
    coll_box.h = COLL_BOX_HEIGHT;
    
    bounding_box.w = width;
    bounding_box.h = height;
    
} // FS::Fish::Fish()

// ******************
// *** DESTRUCTOR ***
// ******************
FS::Fish::~Fish()
{
    // nothing yet
    
} // FS::Fish::~Fish()




// ************************
// *** MEMBER FUNCTIONS ***
// ************************

// **************************************************

void FS::Fish::draw()
{
    if (fish_taken)
    {
        gfx_ptr->draw_texture(FS_gfx::PLATE, x, y);
    }
    else
    {
        gfx_ptr->draw_texture(FS_gfx::FISH, x, y);
    } // if ... else

} // FS::Fish::draw

// **************************************************

void FS::Fish::reset()
{
    fish_taken = false;
    
} // FS::Fish::reset();

// **************************************************

void FS::Fish::remove_fish()
{
    fish_taken = true;
    
} // FS::Fish::remove_fish()

// **************************************************
// **************************************************
// **************************************************     
