// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef Scrolling_sprite_h
#define Scrolling_sprite_h




#include "Sprite.h"
#include "enums.h"
#include "constants.h"




namespace FS
{
    
// This is an abstract class and therefore cannot be instantiated.
// You must provide derived classes with an implementation of the 
// update function if you want to create instances of those classes.
// In Fish Supper these classes are: Log, Crystal and Bonus.
    
class Scrolling_sprite : public Sprite
{    
    public:
        Scrolling_sprite() {}
        virtual ~Scrolling_sprite() {}
        
        int get_row() const { return my_row; }
        
        // Pure virtual function makes Scrolling_sprite an abstract class.
        // Subclasses must provide a definition.
        virtual void update( const ScrollingData& sd ) = 0;
    
    protected:
            
        int my_row;
        
        void scroll_x( const ScrollingData& sd );
        
}; // class Scrolling_sprite

} // namespace FS




#endif

        
          
